/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.LifeCycleAwareChannelHandler;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.ssl.ImmediateExecutor;
import org.jboss.netty.handler.ssl.SslBufferPool;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.NonReentrantLock;
import org.jboss.netty.util.internal.QueueFactory;

public class SslHandler
extends FrameDecoder
implements ChannelDownstreamHandler,
LifeCycleAwareChannelHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private static SslBufferPool defaultBufferPool;
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final SslBufferPool bufferPool;
    private final Executor delegatedTaskExecutor;
    private final boolean startTls;
    private volatile boolean enableRenegotiation = true;
    final Object handshakeLock = new Object();
    private boolean handshaking;
    private volatile boolean handshaken;
    private volatile ChannelFuture handshakeFuture;
    private final AtomicBoolean sentFirstMessage = new AtomicBoolean();
    private final AtomicBoolean sentCloseNotify = new AtomicBoolean();
    int ignoreClosedChannelException;
    final Object ignoreClosedChannelExceptionLock = new Object();
    private final Queue<PendingWrite> pendingUnencryptedWrites = new LinkedList<PendingWrite>();
    private final Queue<MessageEvent> pendingEncryptedWrites = QueueFactory.createQueue(MessageEvent.class);
    private final NonReentrantLock pendingEncryptedWritesLock = new NonReentrantLock();
    private volatile boolean issueHandshake;
    private static final ChannelFutureListener HANDSHAKE_LISTENER;

    public static synchronized SslBufferPool getDefaultBufferPool() {
        if (defaultBufferPool == null) {
            defaultBufferPool = new SslBufferPool();
        }
        return defaultBufferPool;
    }

    public SslHandler(SSLEngine engine) {
        this(engine, SslHandler.getDefaultBufferPool(), (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool) {
        this(engine, bufferPool, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls) {
        this(engine, bufferPool, startTls, ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, SslHandler.getDefaultBufferPool(), delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, Executor delegatedTaskExecutor) {
        this(engine, bufferPool, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        this(engine, SslHandler.getDefaultBufferPool(), startTls, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, SslBufferPool bufferPool, boolean startTls, Executor delegatedTaskExecutor) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (bufferPool == null) {
            throw new NullPointerException("bufferPool");
        }
        if (delegatedTaskExecutor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = engine;
        this.bufferPool = bufferPool;
        this.delegatedTaskExecutor = delegatedTaskExecutor;
        this.startTls = startTls;
    }

    public SSLEngine getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture handshake() {
        ChannelFuture handshakeFuture;
        if (this.handshaken && !this.isEnableRenegotiation()) {
            throw new IllegalStateException("renegotiation disabled");
        }
        ChannelHandlerContext ctx = this.ctx;
        Channel channel = ctx.getChannel();
        Exception exception = null;
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                return this.handshakeFuture;
            }
            this.handshaking = true;
            try {
                this.engine.beginHandshake();
                this.runDelegatedTasks();
                handshakeFuture = this.handshakeFuture = Channels.future(channel);
            }
            catch (Exception e) {
                handshakeFuture = this.handshakeFuture = Channels.failedFuture(channel, e);
                exception = e;
            }
        }
        if (exception == null) {
            try {
                this.wrapNonAppData(ctx, channel);
            }
            catch (SSLException e) {
                Channels.fireExceptionCaught(ctx, (Throwable)e);
                handshakeFuture.setFailure(e);
            }
        } else {
            Channels.fireExceptionCaught(ctx, (Throwable)exception);
        }
        return handshakeFuture;
    }

    @Deprecated
    public ChannelFuture handshake(Channel channel) {
        return this.handshake();
    }

    public ChannelFuture close() {
        ChannelHandlerContext ctx = this.ctx;
        Channel channel = ctx.getChannel();
        try {
            this.engine.closeOutbound();
            return this.wrapNonAppData(ctx, channel);
        }
        catch (SSLException e) {
            Channels.fireExceptionCaught(ctx, (Throwable)e);
            return Channels.failedFuture(channel, e);
        }
    }

    @Deprecated
    public ChannelFuture close(Channel channel) {
        return this.close();
    }

    public boolean isEnableRenegotiation() {
        return this.enableRenegotiation;
    }

    public void setEnableRenegotiation(boolean enableRenegotiation) {
        this.enableRenegotiation = enableRenegotiation;
    }

    public void setIssueHandshake(boolean issueHandshake) {
        this.issueHandshake = issueHandshake;
    }

    public boolean isIssueHandshake() {
        return this.issueHandshake;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDownstream(ChannelHandlerContext context, ChannelEvent evt) throws Exception {
        ChannelEvent e;
        if (evt instanceof ChannelStateEvent) {
            e = (ChannelStateEvent)evt;
            switch (e.getState()) {
                case OPEN: 
                case CONNECTED: 
                case BOUND: {
                    if (!Boolean.FALSE.equals(e.getValue()) && e.getValue() != null) break;
                    this.closeOutboundAndChannel(context, (ChannelStateEvent)e);
                    return;
                }
            }
        }
        if (!(evt instanceof MessageEvent)) {
            context.sendDownstream(evt);
            return;
        }
        e = (MessageEvent)evt;
        if (!(e.getMessage() instanceof ChannelBuffer)) {
            context.sendDownstream(evt);
            return;
        }
        if (this.startTls && this.sentFirstMessage.compareAndSet(false, true)) {
            context.sendDownstream(evt);
            return;
        }
        ChannelBuffer msg = (ChannelBuffer)e.getMessage();
        PendingWrite pendingWrite = msg.readable() ? new PendingWrite(evt.getFuture(), msg.toByteBuffer(msg.readerIndex(), msg.readableBytes())) : new PendingWrite(evt.getFuture(), null);
        Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
        synchronized (queue) {
            boolean offered = this.pendingUnencryptedWrites.offer(pendingWrite);
            assert (offered);
        }
        this.wrap(context, evt.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                this.handshakeFuture.setFailure(new ClosedChannelException());
            }
        }
        try {
            super.channelDisconnected(ctx, e);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block12: {
                Object var6_6 = null;
                this.unwrap(ctx, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
                this.engine.closeOutbound();
                if (!this.sentCloseNotify.get() && this.handshaken) {
                    try {
                        this.engine.closeInbound();
                    }
                    catch (SSLException ex) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug("Failed to clean up SSLEngine.", ex);
                    }
                }
            }
            throw throwable;
        }
        this.unwrap(ctx, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
        this.engine.closeOutbound();
        if (!this.sentCloseNotify.get() && this.handshaken) {
            try {
                this.engine.closeInbound();
            }
            catch (SSLException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to clean up SSLEngine.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            String message;
            if (cause instanceof ClosedChannelException) {
                Object object = this.ignoreClosedChannelExceptionLock;
                synchronized (object) {
                    if (this.ignoreClosedChannelException > 0) {
                        --this.ignoreClosedChannelException;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Swallowing an exception raised while writing non-app data", cause);
                        }
                        return;
                    }
                }
            } else if (this.engine.isOutboundDone() && IGNORABLE_ERROR_MESSAGE.matcher(message = String.valueOf(cause.getMessage()).toLowerCase()).matches()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Swallowing a 'connection reset by peer / broken pipe' error occurred while writing 'closure_notify'", cause);
                }
                Channels.close(ctx, Channels.succeededFuture(e.getChannel()));
                return;
            }
        }
        ctx.sendUpstream(e);
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        boolean tls;
        if (buffer.readableBytes() < 5) {
            return null;
        }
        int packetLength = 0;
        switch (buffer.getUnsignedByte(buffer.readerIndex())) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                tls = true;
                break;
            }
            default: {
                tls = false;
            }
        }
        if (tls) {
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + 1);
            if (majorVersion == 3) {
                packetLength = (SslHandler.getShort(buffer, buffer.readerIndex() + 3) & 0xFFFF) + 5;
                if (packetLength <= 5) {
                    tls = false;
                }
            } else {
                tls = false;
            }
        }
        if (!tls) {
            boolean sslv2 = true;
            int headerLength = (buffer.getUnsignedByte(buffer.readerIndex()) & 0x80) != 0 ? 2 : 3;
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + headerLength + 1);
            if (majorVersion == 2 || majorVersion == 3) {
                packetLength = headerLength == 2 ? (SslHandler.getShort(buffer, buffer.readerIndex()) & Short.MAX_VALUE) + 2 : (SslHandler.getShort(buffer, buffer.readerIndex()) & 0x3FFF) + 3;
                if (packetLength <= headerLength) {
                    sslv2 = false;
                }
            } else {
                sslv2 = false;
            }
            if (!sslv2) {
                SSLException e = new SSLException("not an SSL/TLS record: " + ChannelBuffers.hexDump(buffer));
                buffer.skipBytes(buffer.readableBytes());
                throw e;
            }
        }
        assert (packetLength > 0);
        if (buffer.readableBytes() < packetLength) {
            return null;
        }
        int packetOffset = buffer.readerIndex();
        buffer.skipBytes(packetLength);
        return this.unwrap(ctx, channel, buffer, packetOffset, packetLength);
    }

    private static short getShort(ChannelBuffer buf, int offset) {
        return (short)(buf.getByte(offset) << 8 | buf.getByte(offset + 1) & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ChannelFuture wrap(ChannelHandlerContext context, Channel channel) throws SSLException {
        boolean needsUnwrap;
        ChannelFuture future;
        block36: {
            IllegalStateException cause2;
            future = null;
            ByteBuffer outNetBuf = this.bufferPool.acquire();
            boolean success = true;
            boolean offered = false;
            needsUnwrap = false;
            try {
                try {
                    block19: while (true) {
                        Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
                        synchronized (queue) {
                            PendingWrite pendingWrite = this.pendingUnencryptedWrites.peek();
                            if (pendingWrite == null) {
                                break;
                            }
                            ByteBuffer outAppBuf = pendingWrite.outAppBuf;
                            if (outAppBuf == null) {
                                this.pendingUnencryptedWrites.remove();
                                this.offerEncryptedWriteRequest(new DownstreamMessageEvent(channel, pendingWrite.future, ChannelBuffers.EMPTY_BUFFER, channel.getRemoteAddress()));
                                offered = true;
                            } else {
                                Object var16_15;
                                SSLEngineResult result = null;
                                try {
                                    Object object = this.handshakeLock;
                                    synchronized (object) {
                                        result = this.engine.wrap(outAppBuf, outNetBuf);
                                    }
                                    var16_15 = null;
                                }
                                catch (Throwable throwable) {
                                    var16_15 = null;
                                    if (outAppBuf.hasRemaining()) throw throwable;
                                    this.pendingUnencryptedWrites.remove();
                                    throw throwable;
                                }
                                if (!outAppBuf.hasRemaining()) {
                                    this.pendingUnencryptedWrites.remove();
                                }
                                if (result.bytesProduced() > 0) {
                                    outNetBuf.flip();
                                    ChannelBuffer msg = ChannelBuffers.buffer(outNetBuf.remaining());
                                    msg.writeBytes(outNetBuf.array(), 0, msg.capacity());
                                    outNetBuf.clear();
                                    future = pendingWrite.outAppBuf.hasRemaining() ? Channels.succeededFuture(channel) : pendingWrite.future;
                                    DownstreamMessageEvent encryptedWrite = new DownstreamMessageEvent(channel, future, msg, channel.getRemoteAddress());
                                    this.offerEncryptedWriteRequest(encryptedWrite);
                                    offered = true;
                                } else {
                                    if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                                        success = false;
                                        break;
                                    }
                                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                                    this.handleRenegotiation(handshakeStatus);
                                    switch (handshakeStatus) {
                                        case NEED_WRAP: {
                                            if (outAppBuf.hasRemaining()) break;
                                            break block19;
                                        }
                                        case NEED_UNWRAP: {
                                            needsUnwrap = true;
                                            break block19;
                                        }
                                        case NEED_TASK: {
                                            this.runDelegatedTasks();
                                            break;
                                        }
                                        case FINISHED: 
                                        case NOT_HANDSHAKING: {
                                            if (handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                                                this.setHandshakeSuccess(channel);
                                            }
                                            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                                                success = false;
                                            }
                                            break block19;
                                        }
                                        default: {
                                            throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)handshakeStatus));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    Object var19_17 = null;
                    this.bufferPool.release(outNetBuf);
                    if (offered) {
                        this.flushPendingEncryptedWrites(context);
                    }
                    if (success) break block36;
                    cause2 = new IllegalStateException("SSLEngine already closed");
                }
                catch (SSLException e) {
                    success = false;
                    this.setHandshakeFailure(channel, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                this.bufferPool.release(outNetBuf);
                if (offered) {
                    this.flushPendingEncryptedWrites(context);
                }
                if (success) throw throwable;
                IllegalStateException cause2 = new IllegalStateException("SSLEngine already closed");
                while (true) {
                    PendingWrite pendingWrite;
                    Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
                    synchronized (queue) {
                        pendingWrite = this.pendingUnencryptedWrites.poll();
                        if (pendingWrite == null) {
                            throw throwable;
                        }
                    }
                    pendingWrite.future.setFailure(cause2);
                }
            }
            while (true) {
                PendingWrite pendingWrite;
                Queue<PendingWrite> queue = this.pendingUnencryptedWrites;
                synchronized (queue) {
                    pendingWrite = this.pendingUnencryptedWrites.poll();
                    if (pendingWrite == null) {
                        break;
                    }
                }
                pendingWrite.future.setFailure(cause2);
            }
        }
        if (needsUnwrap) {
            this.unwrap(context, channel, ChannelBuffers.EMPTY_BUFFER, 0, 0);
        }
        if (future != null) return future;
        return Channels.succeededFuture(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerEncryptedWriteRequest(MessageEvent encryptedWrite) {
        boolean locked = this.pendingEncryptedWritesLock.tryLock();
        try {
            this.pendingEncryptedWrites.offer(encryptedWrite);
            Object var4_3 = null;
            if (locked) {
                this.pendingEncryptedWritesLock.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (locked) {
                this.pendingEncryptedWritesLock.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPendingEncryptedWrites(ChannelHandlerContext ctx) {
        if (!this.pendingEncryptedWritesLock.tryLock()) {
            return;
        }
        try {
            MessageEvent e;
            while ((e = this.pendingEncryptedWrites.poll()) != null) {
                ctx.sendDownstream(e);
            }
            Object var4_3 = null;
            this.pendingEncryptedWritesLock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.pendingEncryptedWritesLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture wrapNonAppData(ChannelHandlerContext ctx, Channel channel) throws SSLException {
        ChannelFuture future = null;
        ByteBuffer outNetBuf = this.bufferPool.acquire();
        try {
            try {
                SSLEngineResult result;
                block13: do {
                    Object object = this.handshakeLock;
                    synchronized (object) {
                        result = this.engine.wrap(EMPTY_BUFFER, outNetBuf);
                    }
                    if (result.bytesProduced() > 0) {
                        outNetBuf.flip();
                        ChannelBuffer msg = ChannelBuffers.buffer(outNetBuf.remaining());
                        msg.writeBytes(outNetBuf.array(), 0, msg.capacity());
                        outNetBuf.clear();
                        future = Channels.future(channel);
                        future.addListener(new ChannelFutureListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (future.getCause() instanceof ClosedChannelException) {
                                    Object object = SslHandler.this.ignoreClosedChannelExceptionLock;
                                    synchronized (object) {
                                        ++SslHandler.this.ignoreClosedChannelException;
                                    }
                                }
                            }
                        });
                        Channels.write(ctx, future, msg);
                    }
                    SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                    this.handleRenegotiation(handshakeStatus);
                    switch (handshakeStatus) {
                        case FINISHED: {
                            this.setHandshakeSuccess(channel);
                            this.runDelegatedTasks();
                            break;
                        }
                        case NEED_TASK: {
                            this.runDelegatedTasks();
                            break;
                        }
                        case NEED_UNWRAP: {
                            if (Thread.holdsLock(this.handshakeLock)) continue block13;
                            this.unwrap(ctx, channel, ChannelBuffers.EMPTY_BUFFER, 0, 0);
                            break;
                        }
                        case NEED_WRAP: 
                        case NOT_HANDSHAKING: {
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unexpected handshake status: " + (Object)((Object)handshakeStatus));
                        }
                    }
                } while (result.bytesProduced() != 0);
                Object var9_9 = null;
                this.bufferPool.release(outNetBuf);
            }
            catch (SSLException e) {
                this.setHandshakeFailure(channel, e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.bufferPool.release(outNetBuf);
            throw throwable;
        }
        if (future == null) {
            future = Channels.succeededFuture(channel);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelBuffer unwrap(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, int offset, int length) throws SSLException {
        ByteBuffer outAppBuf;
        block22: {
            ByteBuffer inNetBuf = buffer.toByteBuffer(offset, length);
            outAppBuf = this.bufferPool.acquire();
            boolean needsWrap = false;
            block18: while (true) {
                SSLEngineResult result;
                boolean needsHandshake = false;
                Object object = this.handshakeLock;
                synchronized (object) {
                    if (!(this.handshaken || this.handshaking || this.engine.getUseClientMode() || this.engine.isInboundDone() || this.engine.isOutboundDone())) {
                        needsHandshake = true;
                    }
                }
                if (needsHandshake) {
                    this.handshake();
                }
                object = this.handshakeLock;
                synchronized (object) {
                    result = this.engine.unwrap(inNetBuf, outAppBuf);
                }
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                this.handleRenegotiation(handshakeStatus);
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        if (!inNetBuf.hasRemaining() || this.engine.isInboundDone()) break block18;
                        break;
                    }
                    case NEED_WRAP: {
                        this.wrapNonAppData(ctx, channel);
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess(channel);
                        needsWrap = true;
                        break block18;
                    }
                    case NOT_HANDSHAKING: {
                        needsWrap = true;
                        break block18;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
            }
            if (needsWrap && !Thread.holdsLock(this.handshakeLock) && !this.pendingEncryptedWritesLock.isHeldByCurrentThread()) {
                this.wrap(ctx, channel);
            }
            outAppBuf.flip();
            if (!outAppBuf.hasRemaining()) break block22;
            ChannelBuffer frame = ctx.getChannel().getConfig().getBufferFactory().getBuffer(outAppBuf.remaining());
            frame.writeBytes(outAppBuf.array(), 0, frame.capacity());
            ChannelBuffer channelBuffer = frame;
            Object var15_16 = null;
            this.bufferPool.release(outAppBuf);
            return channelBuffer;
        }
        try {
            ChannelBuffer channelBuffer = null;
            Object var15_17 = null;
            this.bufferPool.release(outAppBuf);
            return channelBuffer;
        }
        catch (SSLException e) {
            try {
                this.setHandshakeFailure(channel, e);
                throw e;
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                this.bufferPool.release(outAppBuf);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRenegotiation(SSLEngineResult.HandshakeStatus handshakeStatus) {
        boolean renegotiate;
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            return;
        }
        if (!this.handshaken) {
            return;
        }
        Object object = this.handshakeLock;
        synchronized (object) {
            if (this.handshaking) {
                return;
            }
            if (this.engine.isInboundDone() || this.engine.isOutboundDone()) {
                return;
            }
            if (this.isEnableRenegotiation()) {
                renegotiate = true;
            } else {
                renegotiate = false;
                this.handshaking = true;
            }
        }
        if (renegotiate) {
            this.handshake();
        } else {
            Channels.fireExceptionCaught(this.ctx, (Throwable)new SSLException("renegotiation attempted by peer; closing the connection"));
            Channels.close(this.ctx, Channels.succeededFuture(this.ctx.getChannel()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDelegatedTasks() {
        while (true) {
            Runnable task;
            Object object = this.handshakeLock;
            synchronized (object) {
                task = this.engine.getDelegatedTask();
            }
            if (task == null) break;
            this.delegatedTaskExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = SslHandler.this.handshakeLock;
                    synchronized (object) {
                        task.run();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeSuccess(Channel channel) {
        Object object = this.handshakeLock;
        synchronized (object) {
            this.handshaking = false;
            this.handshaken = true;
            if (this.handshakeFuture == null) {
                this.handshakeFuture = Channels.future(channel);
            }
        }
        this.handshakeFuture.setSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHandshakeFailure(Channel channel, SSLException cause) {
        Object object = this.handshakeLock;
        synchronized (object) {
            block7: {
                if (!this.handshaking) {
                    return;
                }
                this.handshaking = false;
                this.handshaken = false;
                if (this.handshakeFuture == null) {
                    this.handshakeFuture = Channels.future(channel);
                }
                this.engine.closeOutbound();
                try {
                    this.engine.closeInbound();
                }
                catch (SSLException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("SSLEngine.closeInbound() raised an exception after a handshake failure.", e);
                }
            }
        }
        this.handshakeFuture.setFailure(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundAndChannel(ChannelHandlerContext context, ChannelStateEvent e) {
        if (!e.getChannel().isConnected()) {
            context.sendDownstream(e);
            return;
        }
        boolean success = false;
        try {
            block13: {
                try {
                    this.unwrap(context, e.getChannel(), ChannelBuffers.EMPTY_BUFFER, 0, 0);
                }
                catch (SSLException ex) {
                    if (!logger.isDebugEnabled()) break block13;
                    logger.debug("Failed to unwrap before sending a close_notify message", ex);
                }
            }
            if (!this.engine.isInboundDone()) {
                if (this.sentCloseNotify.compareAndSet(false, true)) {
                    this.engine.closeOutbound();
                    try {
                        ChannelFuture closeNotifyFuture = this.wrapNonAppData(context, e.getChannel());
                        closeNotifyFuture.addListener(new ClosingChannelFutureListener(context, e));
                        success = true;
                    }
                    catch (SSLException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Failed to encode a close_notify message", ex);
                        }
                    }
                }
            } else {
                success = true;
            }
            Object var6_7 = null;
            if (!success) {
                context.sendDownstream(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!success) {
                context.sendDownstream(e);
            }
            throw throwable;
        }
    }

    public void beforeAdd(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }

    public void afterAdd(ChannelHandlerContext ctx) throws Exception {
    }

    public void beforeRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void afterRemove(ChannelHandlerContext ctx) throws Exception {
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.issueHandshake) {
            this.handshake().addListener(HANDSHAKE_LISTENER);
        }
        super.channelConnected(ctx, e);
    }

    static {
        HANDSHAKE_LISTENER = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Channels.fireExceptionCaught(future.getChannel(), future.getCause());
                }
            }
        };
    }

    private static final class ClosingChannelFutureListener
    implements ChannelFutureListener {
        private final ChannelHandlerContext context;
        private final ChannelStateEvent e;

        ClosingChannelFutureListener(ChannelHandlerContext context, ChannelStateEvent e) {
            this.context = context;
            this.e = e;
        }

        public void operationComplete(ChannelFuture closeNotifyFuture) throws Exception {
            if (!(closeNotifyFuture.getCause() instanceof ClosedChannelException)) {
                Channels.close(this.context, this.e.getFuture());
            } else {
                this.e.getFuture().setSuccess();
            }
        }
    }

    private static final class PendingWrite {
        final ChannelFuture future;
        final ByteBuffer outAppBuf;

        PendingWrite(ChannelFuture future, ByteBuffer outAppBuf) {
            this.future = future;
            this.outAppBuf = outAppBuf;
        }
    }
}

