/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.replay;

import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.replay.ReplayError;
import org.jboss.netty.handler.codec.replay.ReplayingDecoderBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplayingDecoder<T extends Enum<T>>
extends SimpleChannelUpstreamHandler {
    private ChannelBuffer cumulation;
    private final boolean unfold;
    private ReplayingDecoderBuffer replayable;
    private T state;
    private int checkpoint;
    private boolean needsCleanup;

    protected ReplayingDecoder() {
        this(null);
    }

    protected ReplayingDecoder(boolean unfold) {
        this(null, unfold);
    }

    protected ReplayingDecoder(T initialState) {
        this(initialState, false);
    }

    protected ReplayingDecoder(T initialState, boolean unfold) {
        this.state = initialState;
        this.unfold = unfold;
    }

    protected void checkpoint() {
        ChannelBuffer cumulation = this.cumulation;
        this.checkpoint = cumulation != null ? cumulation.readerIndex() : -1;
    }

    protected void checkpoint(T state) {
        this.checkpoint();
        this.setState(state);
    }

    protected T getState() {
        return this.state;
    }

    protected T setState(T newState) {
        T oldState = this.state;
        this.state = newState;
        return oldState;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ChannelBuffer internalBuffer() {
        ChannelBuffer buf = this.cumulation;
        if (buf == null) {
            return ChannelBuffers.EMPTY_BUFFER;
        }
        return buf;
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, ChannelBuffer var3, T var4) throws Exception;

    protected Object decodeLast(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, T state) throws Exception {
        return this.decode(ctx, channel, buffer, state);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer input = (ChannelBuffer)m;
        if (!input.readable()) {
            return;
        }
        this.needsCleanup = true;
        if (this.cumulation == null) {
            this.cumulation = input;
            this.replayable = new ReplayingDecoderBuffer(input);
            int oldReaderIndex = input.readerIndex();
            int inputSize = input.readableBytes();
            this.callDecode(ctx, e.getChannel(), input, this.replayable, e.getRemoteAddress());
            if (input.readable()) {
                ChannelBuffer cumulation;
                if (this.checkpoint > 0) {
                    int bytesToPreserve = inputSize - (this.checkpoint - oldReaderIndex);
                    cumulation = this.cumulation = this.newCumulationBuffer(ctx, bytesToPreserve);
                    cumulation.writeBytes(input, this.checkpoint, bytesToPreserve);
                } else if (this.checkpoint == 0) {
                    cumulation = this.cumulation = this.newCumulationBuffer(ctx, inputSize);
                    cumulation.writeBytes(input, oldReaderIndex, inputSize);
                    cumulation.readerIndex(input.readerIndex());
                } else {
                    cumulation = this.cumulation = this.newCumulationBuffer(ctx, input.readableBytes());
                    cumulation.writeBytes(input);
                }
                this.replayable = new ReplayingDecoderBuffer(cumulation);
            } else {
                this.cumulation = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            }
        } else {
            ChannelBuffer buf;
            assert (this.cumulation.readable());
            boolean fit = false;
            int readable = input.readableBytes();
            int writable = this.cumulation.writableBytes();
            int w = writable - readable;
            if (w < 0) {
                int readerIndex = this.cumulation.readerIndex();
                if (w + readerIndex >= 0) {
                    this.cumulation.discardReadBytes();
                    fit = true;
                }
            } else {
                fit = true;
            }
            if (fit) {
                buf = this.cumulation;
                buf.writeBytes(input);
            } else {
                this.cumulation = buf = ChannelBuffers.wrappedBuffer(this.cumulation, input);
                this.replayable = new ReplayingDecoderBuffer(this.cumulation);
            }
            this.callDecode(ctx, e.getChannel(), buf, this.replayable, e.getRemoteAddress());
            if (!buf.readable()) {
                this.cumulation = null;
                this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            } else {
                this.cumulation = this.newCumulationBuffer(ctx, buf.readableBytes());
                this.cumulation.writeBytes(buf);
                this.replayable = new ReplayingDecoderBuffer(this.cumulation);
            }
        }
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.cleanup(ctx, e);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ctx.sendUpstream(e);
    }

    private void callDecode(ChannelHandlerContext context, Channel channel, ChannelBuffer input, ChannelBuffer replayableInput, SocketAddress remoteAddress) throws Exception {
        while (input.readable()) {
            T oldState;
            Object result;
            int oldReaderIndex;
            block5: {
                oldReaderIndex = this.checkpoint = input.readerIndex();
                result = null;
                oldState = this.state;
                try {
                    result = this.decode(context, channel, replayableInput, this.state);
                    if (result == null) {
                        if (oldReaderIndex != input.readerIndex() || oldState != this.state) continue;
                        throw new IllegalStateException("null cannot be returned if no data is consumed and state didn't change.");
                    }
                }
                catch (ReplayError replay) {
                    int checkpoint = this.checkpoint;
                    if (checkpoint < 0) break block5;
                    input.readerIndex(checkpoint);
                }
            }
            if (result == null) break;
            if (oldReaderIndex == input.readerIndex() && oldState == this.state) {
                throw new IllegalStateException("decode() method must consume at least one byte if it returned a decoded message (caused by: " + this.getClass() + ")");
            }
            this.unfoldAndFireMessageReceived(context, result, remoteAddress);
        }
    }

    private void unfoldAndFireMessageReceived(ChannelHandlerContext context, Object result, SocketAddress remoteAddress) {
        if (this.unfold) {
            if (result instanceof Object[]) {
                for (Object r : (Object[])result) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else if (result instanceof Iterable) {
                for (Object r : (Iterable)result) {
                    Channels.fireMessageReceived(context, r, remoteAddress);
                }
            } else {
                Channels.fireMessageReceived(context, result, remoteAddress);
            }
        } else {
            Channels.fireMessageReceived(context, result, remoteAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        try {
            Object partiallyDecoded;
            ChannelBuffer cumulation = this.cumulation;
            if (!this.needsCleanup) {
                return;
            }
            this.needsCleanup = false;
            this.cumulation = null;
            this.replayable.terminate();
            if (cumulation != null && cumulation.readable()) {
                this.callDecode(ctx, e.getChannel(), cumulation, this.replayable, null);
            }
            if ((partiallyDecoded = this.decodeLast(ctx, e.getChannel(), this.replayable, this.state)) != null) {
                this.unfoldAndFireMessageReceived(ctx, partiallyDecoded, null);
            }
        }
        catch (ReplayError replayError) {
        }
        finally {
            this.replayable = ReplayingDecoderBuffer.EMPTY_BUFFER;
            ctx.sendUpstream(e);
        }
    }

    protected ChannelBuffer newCumulationBuffer(ChannelHandlerContext ctx, int minimumCapacity) {
        ChannelBufferFactory factory = ctx.getChannel().getConfig().getBufferFactory();
        return factory.getBuffer(Math.max(minimumCapacity, 256));
    }
}

