/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.pubsub;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.protocol.CommandHandler;
import io.lettuce.core.protocol.RedisCommand;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.PubSubOutput;
import io.lettuce.core.resource.ClientResources;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;

public class PubSubCommandHandler<K, V>
extends CommandHandler {
    private final PubSubEndpoint<K, V> endpoint;
    private final RedisCodec<K, V> codec;
    private PubSubOutput<K, V, V> output;

    public PubSubCommandHandler(ClientOptions clientOptions, ClientResources clientResources, RedisCodec<K, V> codec, PubSubEndpoint<K, V> endpoint) {
        super(clientOptions, clientResources, endpoint);
        this.endpoint = endpoint;
        this.codec = codec;
        this.output = new PubSubOutput(codec);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        super.decode(ctx, buffer);
        while (buffer.isReadable()) {
            if (!super.decode(buffer, this.output)) {
                return;
            }
            this.endpoint.notifyMessage(this.output);
            this.output = new PubSubOutput(this.codec);
            buffer.discardReadBytes();
        }
    }

    @Override
    protected boolean canDecode(ByteBuf buffer) {
        return super.canDecode(buffer) && this.output.type() == null;
    }

    @Override
    protected void afterComplete(ChannelHandlerContext ctx, RedisCommand<?, ?, ?> command) {
        if (command.getOutput() instanceof PubSubOutput) {
            this.endpoint.notifyMessage((PubSubOutput)command.getOutput());
        }
    }
}

