/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javaslang.collection.AbstractIterator;
import javaslang.collection.ArrayType;
import javaslang.collection.HashSet;
import javaslang.collection.Iterator;
import javaslang.collection.LinkedHashMap;
import javaslang.collection.List;
import javaslang.collection.Map;
import javaslang.collection.Seq;
import javaslang.collection.Traversable;
import javaslang.control.Option;

final class Collections {
    Collections() {
    }

    static boolean areEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        java.util.Iterator<?> iter1 = iterable1.iterator();
        java.util.Iterator<?> iter2 = iterable2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return iter1.hasNext() == iter2.hasNext();
    }

    static <T, S extends Seq<T>> Iterator<S> crossProduct(S empty, S seq, int power) {
        if (power < 0) {
            return Iterator.empty();
        }
        return Iterator.range(0, power).foldLeft(Iterator.of(empty), (product, ignored) -> product.flatMap(el -> seq.map(t -> el.append(t))));
    }

    static <T> Iterator<T> fill(int n, Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return Collections.tabulate(n, ignored -> supplier.get());
    }

    static <C extends Traversable<T>, T> C fill(int n, Supplier<? extends T> s, C empty, Function<T[], C> of) {
        Objects.requireNonNull(s, "s is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        return Collections.tabulate(n, anything -> s.get(), empty, of);
    }

    static <T, C, R extends Iterable<T>> Map<C, R> groupBy(Traversable<T> source, Function<? super T, ? extends C> classifier, Function<? super Iterable<T>, R> mapper) {
        Objects.requireNonNull(classifier, "classifier is null");
        Objects.requireNonNull(mapper, "mapper is null");
        java.util.LinkedHashMap<Object, Collection> mutableResults = new java.util.LinkedHashMap<Object, Collection>(source.isTraversableAgain() ? source.size() : 16);
        for (Object value : source) {
            C key = classifier.apply(value);
            mutableResults.computeIfAbsent(key, k -> new ArrayList()).add(value);
        }
        Map results = LinkedHashMap.empty();
        for (Map.Entry entry : mutableResults.entrySet()) {
            results = results.put(entry.getKey(), mapper.apply(entry.getValue()));
        }
        return results;
    }

    static int hash(Iterable<?> iterable) {
        int hashCode = 1;
        for (Object o : iterable) {
            hashCode = 31 * hashCode + Objects.hashCode(o);
        }
        return hashCode;
    }

    static Option<Integer> indexOption(int index) {
        return Option.when(index >= 0, index);
    }

    static <T> boolean isTraversableAgain(Iterable<? extends T> iterable) {
        return iterable instanceof Collection || iterable instanceof Traversable && ((Traversable)iterable).isTraversableAgain();
    }

    static <K, V, K2, U extends Map<K2, V>> U mapKeys(Map<K, V> source, U zero, Function<? super K, ? extends K2> keyMapper, BiFunction<? super V, ? super V, ? extends V> valueMerge) {
        Objects.requireNonNull(zero, "zero is null");
        Objects.requireNonNull(keyMapper, "keyMapper is null");
        Objects.requireNonNull(valueMerge, "valueMerge is null");
        return (U)source.foldLeft(zero, (acc, entry) -> {
            Object k2 = keyMapper.apply((Object)entry._1);
            Object v2 = entry._2;
            Option v1 = acc.get(k2);
            Object v = v1.isDefined() ? valueMerge.apply((Object)v1.get(), (Object)v2) : v2;
            return acc.put(k2, v);
        });
    }

    static <C extends Traversable<T>, T> C removeAll(C source, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashSet removed = HashSet.ofAll(elements);
        return (C)source.filter(e -> !removed.contains(e));
    }

    static <C extends Traversable<T>, T> C removeAll(C source, Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return (C)source.filter(predicate.negate());
    }

    static <C extends Traversable<T>, T> C removeAll(C source, T element) {
        Objects.requireNonNull(element, "element is null");
        return Collections.removeAll(source, List.of(element));
    }

    static <C extends Traversable<T>, T> C retainAll(C source, Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        HashSet<? extends T> removed = HashSet.ofAll(elements);
        return (C)source.filter(removed::contains);
    }

    static <T> Iterator<T> reverseIterator(Iterable<T> iterable) {
        if (iterable instanceof java.util.List) {
            return Collections.reverseListIterator((java.util.List)iterable);
        }
        if (iterable instanceof Seq) {
            return ((Seq)iterable).reverseIterator();
        }
        return List.empty().pushAll((Iterable)iterable).iterator();
    }

    private static <T> Iterator<T> reverseListIterator(final java.util.List<T> list) {
        return new Iterator<T>(){
            private final ListIterator<T> delegate;
            {
                this.delegate = list.listIterator(list.size());
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasPrevious();
            }

            @Override
            public T next() {
                return this.delegate.previous();
            }
        };
    }

    static <T, U, R extends Traversable<U>> R scanLeft(Traversable<? extends T> source, U zero, BiFunction<? super U, ? super T, ? extends U> operation, Function<Iterator<U>, R> finisher) {
        Objects.requireNonNull(operation, "operation is null");
        Traversable iterator = source.iterator().scanLeft(zero, operation);
        return (R)((Traversable)finisher.apply((Iterator<U>)iterator));
    }

    static <T, U, R extends Traversable<U>> R scanRight(Traversable<? extends T> source, U zero, BiFunction<? super T, ? super U, ? extends U> operation, Function<Iterator<U>, R> finisher) {
        Objects.requireNonNull(operation, "operation is null");
        Iterator<? extends T> reversedElements = Collections.reverseIterator(source);
        return (R)Collections.scanLeft(reversedElements, zero, (u, t) -> operation.apply(t, u), us -> (Traversable)finisher.apply(Collections.reverseIterator(us)));
    }

    static <T, S extends Seq<T>> S shuffle(S source, Function<? super Iterable<T>, S> ofAll) {
        if (source.length() <= 1) {
            return source;
        }
        java.util.List list = source.toJavaList();
        java.util.Collections.shuffle(list);
        return (S)((Seq)ofAll.apply(list));
    }

    static <T> Iterator<T> tabulate(final int n, final Function<? super Integer, ? extends T> f) {
        Objects.requireNonNull(f, "f is null");
        if (n <= 0) {
            return Iterator.empty();
        }
        return new AbstractIterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < n;
            }

            @Override
            protected T getNext() {
                return f.apply(this.i++);
            }
        };
    }

    static <C extends Traversable<T>, T> C tabulate(int n, Function<? super Integer, ? extends T> f, C empty, Function<T[], C> of) {
        Objects.requireNonNull(f, "f is null");
        Objects.requireNonNull(empty, "empty is null");
        Objects.requireNonNull(of, "of is null");
        if (n <= 0) {
            return empty;
        }
        Object[] elements = new Object[n];
        for (int i = 0; i < n; ++i) {
            elements[i] = f.apply(i);
        }
        return (C)((Traversable)of.apply((Object[][])elements));
    }

    static <T> IterableWithSize<T> withSize(Iterable<? extends T> iterable) {
        if (iterable instanceof Collection) {
            return new IterableWithSize<T>(iterable, ((Collection)iterable).size());
        }
        if (Collections.isTraversableAgain(iterable)) {
            return new IterableWithSize<T>(iterable, ((Traversable)iterable).size());
        }
        List<T> list = List.ofAll(iterable);
        return new IterableWithSize<T>(list, list.size());
    }

    static class IterableWithSize<T> {
        private final Iterable<? extends T> iterable;
        private final int size;

        IterableWithSize(Iterable<? extends T> iterable, int size) {
            this.iterable = iterable;
            this.size = size;
        }

        java.util.Iterator<? extends T> iterator() {
            return this.iterable.iterator();
        }

        java.util.Iterator<? extends T> reverseIterator() {
            return Collections.reverseIterator(this.iterable);
        }

        int size() {
            return this.size;
        }

        T[] toArray() {
            return ArrayType.asArray(this.iterator(), this.size());
        }
    }
}

