/*
 * Decompiled with CFR 0.152.
 */
package javaslang;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javaslang.Function1;
import javaslang.Lazy;
import javaslang.Tuple0;
import javaslang.control.Option;
import javaslang.control.Try;
import javaslang.\u03bb;

@FunctionalInterface
public interface Function0<R>
extends \u03bb<R>,
Supplier<R> {
    public static final long serialVersionUID = 1L;

    public static <R> Function0<R> of(Function0<R> methodReference) {
        return methodReference;
    }

    public static <R> Function0<Option<R>> lift(Supplier<? extends R> partialFunction) {
        return () -> Try.of(((Supplier)partialFunction)::get).getOption();
    }

    public static <R> Function0<Try<R>> liftTry(Supplier<? extends R> partialFunction) {
        return () -> Try.of(((Supplier)partialFunction)::get);
    }

    public R apply();

    @Override
    default public R get() {
        return this.apply();
    }

    @Override
    default public int arity() {
        return 0;
    }

    public static <R> Function0<R> constant(R value) {
        return () -> value;
    }

    @Override
    default public Function0<R> curried() {
        return this;
    }

    default public Function1<Tuple0, R> tupled() {
        return t -> this.apply();
    }

    @Override
    default public Function0<R> reversed() {
        return this;
    }

    @Override
    default public Function0<R> memoized() {
        if (this.isMemoized()) {
            return this;
        }
        return Lazy.of(this::apply)::get;
    }

    default public <V> Function0<V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after, "after is null");
        return () -> after.apply((R)this.apply());
    }
}

