/*
 * Decompiled with CFR 0.152.
 */
package javaslang;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import javaslang.CheckedFunction1;
import javaslang.Function1;
import javaslang.Function2;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.control.Option;
import javaslang.control.Try;
import javaslang.\u03bb;

@FunctionalInterface
public interface CheckedFunction2<T1, T2, R>
extends \u03bb<R> {
    public static final long serialVersionUID = 1L;

    public static <T1, T2, R> CheckedFunction2<T1, T2, R> of(CheckedFunction2<T1, T2, R> methodReference) {
        return methodReference;
    }

    public static <T1, T2, R> Function2<T1, T2, Option<R>> lift(CheckedFunction2<? super T1, ? super T2, ? extends R> partialFunction) {
        return (t1, t2) -> Try.of(() -> partialFunction.apply(t1, t2)).getOption();
    }

    public static <T1, T2, R> Function2<T1, T2, Try<R>> liftTry(CheckedFunction2<? super T1, ? super T2, ? extends R> partialFunction) {
        return (t1, t2) -> Try.of(() -> partialFunction.apply(t1, t2));
    }

    public R apply(T1 var1, T2 var2) throws Throwable;

    default public CheckedFunction1<T2, R> apply(T1 t1) {
        return t2 -> this.apply(t1, t2);
    }

    @Override
    default public int arity() {
        return 2;
    }

    public static <T1, T2, R> CheckedFunction2<T1, T2, R> constant(R value) {
        return (t1, t2) -> value;
    }

    default public Function1<T1, CheckedFunction1<T2, R>> curried() {
        return t1 -> t2 -> this.apply(t1, t2);
    }

    default public CheckedFunction1<Tuple2<T1, T2>, R> tupled() {
        return t -> this.apply(t._1, t._2);
    }

    default public CheckedFunction2<T2, T1, R> reversed() {
        return (t2, t1) -> this.apply(t1, t2);
    }

    default public CheckedFunction2<T1, T2, R> memoized() {
        if (this.isMemoized()) {
            return this;
        }
        Object lock = new Object();
        HashMap cache = new HashMap();
        \u03bb tupled = this.tupled();
        return (arg_0, arg_1) -> CheckedFunction2.lambda$memoized$760657ce$1(lock, cache, (CheckedFunction1)tupled, arg_0, arg_1);
    }

    default public Function2<T1, T2, R> recover(Function<? super Throwable, ? extends BiFunction<? super T1, ? super T2, ? extends R>> recover) {
        Objects.requireNonNull(recover, "recover is null");
        return (t1, t2) -> {
            try {
                return this.apply(t1, t2);
            }
            catch (Throwable throwable) {
                BiFunction func = (BiFunction)recover.apply(throwable);
                Objects.requireNonNull(func, () -> "recover return null for " + throwable.getClass() + ": " + throwable.getMessage());
                return func.apply(t1, t2);
            }
        };
    }

    default public Function2<T1, T2, R> unchecked(Function<? super Throwable, ? extends RuntimeException> exceptionMapper) {
        return this.recover(throwable -> {
            throw (RuntimeException)exceptionMapper.apply((Throwable)throwable);
        });
    }

    default public Function2<T1, T2, R> unchecked() {
        return this.unchecked(IllegalStateException::new);
    }

    default public <V> CheckedFunction2<T1, T2, V> andThen(CheckedFunction1<? super R, ? extends V> after) {
        Objects.requireNonNull(after, "after is null");
        return (t1, t2) -> after.apply((R)this.apply(t1, t2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object lambda$memoized$760657ce$1(Object lock, Map cache, CheckedFunction1 tupled, Object t1, Object t2) throws Throwable {
        Object object = lock;
        synchronized (object) {
            return cache.computeIfAbsent(Tuple.of(t1, t2), t -> Try.of(() -> tupled.apply(t)).get());
        }
    }
}

