/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.instrumentation.common.Duration;
import com.google.instrumentation.common.Timestamp;
import com.google.instrumentation.stats.DistributionAggregation;
import com.google.instrumentation.stats.DistributionAggregationDescriptor;
import com.google.instrumentation.stats.IntervalAggregation;
import com.google.instrumentation.stats.IntervalAggregationDescriptor;
import com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.instrumentation.stats.Tag;
import com.google.instrumentation.stats.TagKey;
import com.google.instrumentation.stats.View;
import com.google.instrumentation.stats.ViewDescriptor;
import com.google.instrumentation.stats.proto.CensusProto;
import io.grpc.ExperimentalApi;
import io.grpc.instrumentation.v1alpha.StatsResponse;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/2776")
final class MonitoringUtil {
    private MonitoringUtil() {
    }

    static StatsResponse buildCanonicalRpcStatsView(View view) {
        return StatsResponse.newBuilder().setMeasurementDescriptor(MonitoringUtil.serializeMeasurementDescriptor(view.getViewDescriptor().getMeasurementDescriptor())).setViewDescriptor(MonitoringUtil.serializeViewDescriptor(view.getViewDescriptor())).setView(MonitoringUtil.serializeView(view)).build();
    }

    @VisibleForTesting
    static CensusProto.MeasurementDescriptor serializeMeasurementDescriptor(MeasurementDescriptor measurementDescriptor) {
        return CensusProto.MeasurementDescriptor.newBuilder().setName(measurementDescriptor.getName()).setDescription(measurementDescriptor.getDescription()).setUnit(MonitoringUtil.serializeMeasurementUnit(measurementDescriptor.getUnit())).build();
    }

    @VisibleForTesting
    static CensusProto.MeasurementDescriptor.MeasurementUnit serializeMeasurementUnit(MeasurementDescriptor.MeasurementUnit unit) {
        CensusProto.MeasurementDescriptor.MeasurementUnit.Builder unitBuilder = CensusProto.MeasurementDescriptor.MeasurementUnit.newBuilder().setPower10(unit.getPower10());
        for (MeasurementDescriptor.BasicUnit basicUnit : unit.getNumerators()) {
            unitBuilder.addNumerators(MonitoringUtil.serializeBasicUnit(basicUnit));
        }
        for (MeasurementDescriptor.BasicUnit basicUnit : unit.getDenominators()) {
            unitBuilder.addDenominators(MonitoringUtil.serializeBasicUnit(basicUnit));
        }
        return unitBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.MeasurementDescriptor.BasicUnit serializeBasicUnit(MeasurementDescriptor.BasicUnit basicUnit) {
        switch (basicUnit) {
            case SCALAR: {
                return CensusProto.MeasurementDescriptor.BasicUnit.SCALAR;
            }
            case BITS: {
                return CensusProto.MeasurementDescriptor.BasicUnit.BITS;
            }
            case BYTES: {
                return CensusProto.MeasurementDescriptor.BasicUnit.BYTES;
            }
            case SECONDS: {
                return CensusProto.MeasurementDescriptor.BasicUnit.SECONDS;
            }
            case CORES: {
                return CensusProto.MeasurementDescriptor.BasicUnit.CORES;
            }
        }
        return CensusProto.MeasurementDescriptor.BasicUnit.UNKNOWN;
    }

    @VisibleForTesting
    static CensusProto.ViewDescriptor serializeViewDescriptor(ViewDescriptor viewDescriptor) {
        CensusProto.ViewDescriptor.Builder viewDescriptorBuilder = CensusProto.ViewDescriptor.newBuilder().setName(viewDescriptor.getName()).setDescription(viewDescriptor.getDescription()).setMeasurementDescriptorName(viewDescriptor.getMeasurementDescriptor().getName());
        for (TagKey tagKey : viewDescriptor.getTagKeys()) {
            viewDescriptorBuilder.addTagKeys(tagKey.toString());
        }
        if (viewDescriptor instanceof ViewDescriptor.DistributionViewDescriptor) {
            viewDescriptorBuilder.setDistributionAggregation(MonitoringUtil.serializeDistributionAggregationDescriptor(((ViewDescriptor.DistributionViewDescriptor)viewDescriptor).getDistributionAggregationDescriptor()));
        } else {
            viewDescriptorBuilder.setIntervalAggregation(MonitoringUtil.serializeIntervalAggregationDescriptor(((ViewDescriptor.IntervalViewDescriptor)viewDescriptor).getIntervalAggregationDescriptor()));
        }
        return viewDescriptorBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.DistributionAggregationDescriptor serializeDistributionAggregationDescriptor(DistributionAggregationDescriptor distributionAggregationDescriptor) {
        CensusProto.DistributionAggregationDescriptor.Builder distributionAggregationDescriptorBuilder = CensusProto.DistributionAggregationDescriptor.newBuilder();
        if (distributionAggregationDescriptor.getBucketBoundaries() != null) {
            distributionAggregationDescriptorBuilder.addAllBucketBounds(distributionAggregationDescriptor.getBucketBoundaries());
        }
        return distributionAggregationDescriptorBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.IntervalAggregationDescriptor serializeIntervalAggregationDescriptor(IntervalAggregationDescriptor intervalAggregationDescriptor) {
        CensusProto.IntervalAggregationDescriptor.Builder intervalAggregationDescriptorBuilder = CensusProto.IntervalAggregationDescriptor.newBuilder().setNSubIntervals(intervalAggregationDescriptor.getNumSubIntervals());
        for (Duration intervalSize : intervalAggregationDescriptor.getIntervalSizes()) {
            intervalAggregationDescriptorBuilder.addIntervalSizes(MonitoringUtil.serializeDuration(intervalSize));
        }
        return intervalAggregationDescriptorBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.Duration serializeDuration(Duration duration) {
        return CensusProto.Duration.newBuilder().setSeconds(duration.getSeconds()).setNanos(duration.getNanos()).build();
    }

    @VisibleForTesting
    static CensusProto.View serializeView(View view) {
        CensusProto.View.Builder viewBuilder = CensusProto.View.newBuilder().setViewName(view.getViewDescriptor().getName());
        if (view instanceof View.DistributionView) {
            viewBuilder.setDistributionView(MonitoringUtil.serializeDistributionView((View.DistributionView)view));
        } else {
            viewBuilder.setIntervalView(MonitoringUtil.serializeIntervalView((View.IntervalView)view));
        }
        return viewBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.DistributionView serializeDistributionView(View.DistributionView distributionView) {
        CensusProto.DistributionView.Builder distributionViewBuilder = CensusProto.DistributionView.newBuilder();
        for (DistributionAggregation aggregation : distributionView.getDistributionAggregations()) {
            distributionViewBuilder.addAggregations(MonitoringUtil.serializeDistributionAggregation(aggregation));
        }
        return distributionViewBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.Timestamp serializeTimestamp(Timestamp timestamp) {
        return CensusProto.Timestamp.newBuilder().setSeconds(timestamp.getSeconds()).setNanos(timestamp.getNanos()).build();
    }

    @VisibleForTesting
    static CensusProto.DistributionAggregation serializeDistributionAggregation(DistributionAggregation aggregation) {
        CensusProto.DistributionAggregation.Builder aggregationBuilder = CensusProto.DistributionAggregation.newBuilder().setCount(aggregation.getCount()).setMean(aggregation.getMean()).setSum(aggregation.getSum()).setRange(MonitoringUtil.serializeRange(aggregation.getRange()));
        if (aggregation.getBucketCounts() != null) {
            aggregationBuilder.addAllBucketCounts(aggregation.getBucketCounts());
        }
        for (Tag tag : aggregation.getTags()) {
            aggregationBuilder.addTags(MonitoringUtil.serializeTag(tag));
        }
        return aggregationBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.DistributionAggregation.Range serializeRange(DistributionAggregation.Range range) {
        CensusProto.DistributionAggregation.Range.Builder builder = CensusProto.DistributionAggregation.Range.newBuilder();
        if (range != null) {
            builder.setMin(range.getMin()).setMax(range.getMax());
        }
        return builder.build();
    }

    @VisibleForTesting
    static CensusProto.Tag serializeTag(Tag tag) {
        return CensusProto.Tag.newBuilder().setKey(tag.getKey().toString()).setValue(tag.getValue().toString()).build();
    }

    @VisibleForTesting
    static CensusProto.IntervalView serializeIntervalView(View.IntervalView intervalView) {
        CensusProto.IntervalView.Builder intervalViewBuilder = CensusProto.IntervalView.newBuilder();
        for (IntervalAggregation aggregation : intervalView.getIntervalAggregations()) {
            intervalViewBuilder.addAggregations(MonitoringUtil.serializeIntervalAggregation(aggregation));
        }
        return intervalViewBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.IntervalAggregation serializeIntervalAggregation(IntervalAggregation aggregation) {
        CensusProto.IntervalAggregation.Builder aggregationBuilder = CensusProto.IntervalAggregation.newBuilder();
        for (IntervalAggregation.Interval interval : aggregation.getIntervals()) {
            aggregationBuilder.addIntervals(MonitoringUtil.serializeInterval(interval));
        }
        for (Tag tag : aggregation.getTags()) {
            aggregationBuilder.addTags(MonitoringUtil.serializeTag(tag));
        }
        return aggregationBuilder.build();
    }

    @VisibleForTesting
    static CensusProto.IntervalAggregation.Interval serializeInterval(IntervalAggregation.Interval interval) {
        return CensusProto.IntervalAggregation.Interval.newBuilder().setIntervalSize(MonitoringUtil.serializeDuration(interval.getIntervalSize())).setCount(interval.getCount()).setSum(interval.getSum()).build();
    }
}

