/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.primitive;

import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.reflection.FastStringUtils;
import java.io.IOException;
import java.io.StringReader;

public class InMemoryReader
extends StringReader {
    private static final String EMPTY_STRING = "";
    private char[] buffer;
    private int position;

    @Override
    public final void close() {
        this.position = 0;
        this.buffer = null;
    }

    public InMemoryReader(char[] buffer) {
        super(EMPTY_STRING);
        this.buffer = buffer;
    }

    public InMemoryReader(String bufferSource) {
        super(EMPTY_STRING);
        this.buffer = FastStringUtils.toCharArray(bufferSource);
    }

    @Override
    public final int read() {
        if (this.position >= this.buffer.length) {
            return -1;
        }
        char value = this.buffer[this.position];
        ++this.position;
        return value & 0xFF;
    }

    @Override
    public int read(char[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(char[] destination, int destinationOffset, int destinationLength) {
        int available = this.buffer.length - this.position;
        int readAmount = 0;
        if (available >= destinationLength) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, destinationLength);
            this.position += destinationLength;
            readAmount = destinationLength;
        } else if (available > 0) {
            System.arraycopy(this.buffer, this.position, destination, destinationOffset, available);
            this.position += available;
            readAmount = available;
        }
        return readAmount <= 0 ? -1 : readAmount;
    }

    @Override
    public final long skip(long n) {
        return Exceptions.die(Long.class, "Skip not supported");
    }

    @Override
    public final void mark(int limit) {
    }

    @Override
    public final void reset() {
        Exceptions.die("Resetting not supported");
    }

    @Override
    public final boolean markSupported() {
        return false;
    }

    @Override
    public boolean ready() {
        return this.buffer != null;
    }
}

