/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core.reflection.impl;

import io.advantageous.boon.core.Conversions;
import io.advantageous.boon.core.Exceptions;
import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.TypeType;
import io.advantageous.boon.core.reflection.AnnotationData;
import io.advantageous.boon.core.reflection.Annotations;
import io.advantageous.boon.core.reflection.Invoker;
import io.advantageous.boon.core.reflection.MethodAccess;
import io.advantageous.boon.core.reflection.MethodParamAccess;
import io.advantageous.boon.core.reflection.MethodReturnAccess;
import io.advantageous.boon.core.reflection.impl.MethodParamAccessImpl;
import io.advantageous.boon.core.reflection.impl.MethodReturnAccessImpl;
import io.advantageous.boon.primitive.Arry;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MethodAccessImpl
implements MethodAccess {
    public final Method method;
    final List<AnnotationData> annotationData;
    final List<List<AnnotationData>> annotationDataForParams;
    final Map<String, AnnotationData> annotationMap;
    final List<TypeType> paramTypeEnumList;
    final List<MethodParamAccess> methodParamList;
    final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private final MethodReturnAccess returnAccess;
    MethodHandle methodHandle;
    Object instance;
    private int score;

    public MethodAccessImpl() {
        this.method = null;
        this.annotationData = null;
        this.annotationMap = null;
        this.methodHandle = null;
        this.annotationDataForParams = null;
        this.paramTypeEnumList = null;
        this.methodParamList = null;
        this.returnAccess = null;
    }

    public MethodAccessImpl(Method method) {
        MethodReturnAccessImpl returnAccess;
        this.method = method;
        this.method.setAccessible(true);
        this.annotationData = Annotations.getAnnotationDataForMethod(method);
        this.annotationDataForParams = Annotations.getAnnotationDataForMethodParams(method);
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        ArrayList<MethodParamAccessImpl> methodParamList = new ArrayList<MethodParamAccessImpl>(method.getParameterCount());
        ArrayList<TypeType> paramTypeEnumList = new ArrayList<TypeType>(method.getParameterCount());
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> paramClass = parameterTypes[index];
            Type type = genericParameterTypes[index];
            TypeType paramType = TypeType.getType(paramClass);
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                ArrayList genericList = new ArrayList(actualTypeArguments.length);
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    Class<?> componentType = this.getClassFromParameterizedType(i, parameterizedType);
                    genericList.add(componentType);
                }
                methodParamList.add(new MethodParamAccessImpl(true, paramType, paramClass, genericList));
            } else {
                methodParamList.add(new MethodParamAccessImpl(false, paramType, paramClass, Collections.emptyList()));
            }
            paramTypeEnumList.add(paramType);
        }
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            ArrayList genericList = new ArrayList(actualTypeArguments.length);
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Class<?> componentType = this.getClassFromParameterizedType(i, parameterizedType);
                genericList.add(componentType);
            }
            returnAccess = new MethodReturnAccessImpl(true, TypeType.getType(method.getReturnType()), method.getReturnType(), genericList);
        } else {
            returnAccess = new MethodReturnAccessImpl(false, TypeType.getType(method.getReturnType()), method.getReturnType(), Collections.emptyList());
        }
        this.returnAccess = returnAccess;
        this.methodParamList = Collections.unmodifiableList(methodParamList);
        this.paramTypeEnumList = Collections.unmodifiableList(paramTypeEnumList);
        this.annotationMap = new ConcurrentHashMap<String, AnnotationData>();
        for (AnnotationData data : this.annotationData) {
            this.annotationMap.put(data.getName(), data);
            this.annotationMap.put(data.getSimpleClassName(), data);
            this.annotationMap.put(data.getFullClassName(), data);
        }
        this.score(method);
    }

    @Override
    public List<List<AnnotationData>> annotationDataForParams() {
        return this.annotationDataForParams;
    }

    private Class<?> getClassFromParameterizedType(int index, ParameterizedType parameterizedType) {
        Type type1 = parameterizedType.getActualTypeArguments()[index];
        if (type1 instanceof Class) {
            return (Class)type1;
        }
        if (type1 instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type1).getUpperBounds();
            if (upperBounds.length == 1) {
                if (upperBounds[0] instanceof Class) {
                    return (Class)upperBounds[0];
                }
                return Object.class;
            }
            return Object.class;
        }
        return Object.class;
    }

    private void score(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int index = 0;
        for (Class<?> paramType : parameterTypes) {
            if (paramType.isPrimitive()) {
                this.score += 100;
                continue;
            }
            TypeType type = this.paramTypeEnumList.get(index);
            switch (type) {
                case LONG_WRAPPER: {
                    this.score += 85;
                    break;
                }
                case INTEGER_WRAPPER: {
                    this.score += 75;
                    break;
                }
                case SHORT_WRAPPER: 
                case BYTE_WRAPPER: {
                    this.score += 65;
                    break;
                }
                case BOOLEAN_WRAPPER: {
                    this.score += 60;
                    break;
                }
                case FLOAT_WRAPPER: {
                    this.score += 55;
                    break;
                }
                case DOUBLE_WRAPPER: {
                    this.score += 50;
                    break;
                }
                case BIG_INT: {
                    this.score += 45;
                    break;
                }
                case BIG_DECIMAL: {
                    this.score += 40;
                    break;
                }
                case STRING: {
                    this.score += 30;
                    break;
                }
                case INSTANCE: {
                    this.score += 25;
                }
            }
            ++index;
        }
        if (method.isVarArgs()) {
            this.score += -10000;
        }
    }

    public Object invokeDynamicList(Object object, List<?> args) {
        return this.invokeDynamic(object, Arry.objectArray(args));
    }

    @Override
    public Object invokeDynamicObject(Object object, Object args) {
        if (args instanceof List) {
            return this.invokeDynamicList(object, (List)args);
        }
        return this.invokeDynamic(object, args);
    }

    @Override
    public Object invokeDynamic(Object object, Object ... args) {
        Class<?>[] parameterTypes = this.parameterTypes();
        int paramLength = this.method.getParameterCount();
        int argsLength = args.length;
        if (paramLength == 0) {
            return this.invoke(object, new Object[0]);
        }
        if (paramLength == argsLength) {
            Object[] newArgs = new Object[argsLength];
            block6: for (int index = 0; index < argsLength; ++index) {
                Object arg = args[index];
                MethodParamAccess methodParamAccess = this.methodParamList.get(index);
                switch (methodParamAccess.typeEnum()) {
                    case SET: {
                        if (!(arg instanceof Collection)) continue block6;
                        Collection argCollection = (Collection)arg;
                        newArgs[index] = argCollection.stream().map(original -> Conversions.coerce(methodParamAccess.componentType(), methodParamAccess.getComponentClass(), original)).collect(Collectors.toSet());
                        continue block6;
                    }
                    case LIST: {
                        if (!(arg instanceof Collection)) continue block6;
                        Collection argCollection = (Collection)arg;
                        newArgs[index] = argCollection.stream().map(original -> Conversions.coerce(methodParamAccess.componentType(), methodParamAccess.getComponentClass(), original)).collect(Collectors.toList());
                        continue block6;
                    }
                    case MAP: {
                        if (!(arg instanceof Map)) continue block6;
                        Map argMap = (Map)arg;
                        HashMap convertedMap = new HashMap(argMap.size());
                        argMap.forEach((oKey, oValue) -> {
                            Object newKey = Conversions.coerce(methodParamAccess.componentKeyType(), methodParamAccess.getComponentKeyClass(), oKey);
                            Object newValue = Conversions.coerce(methodParamAccess.componentValueType(), methodParamAccess.getComponentValueClass(), oValue);
                            convertedMap.put(newKey, newValue);
                        });
                        newArgs[index] = convertedMap;
                        continue block6;
                    }
                    case INSTANCE: {
                        newArgs[index] = Conversions.coerce(methodParamAccess.typeEnum(), methodParamAccess.getType(), arg);
                        continue block6;
                    }
                    default: {
                        if (!methodParamAccess.getType().isInstance(arg)) {
                            TypeType type = this.paramTypeEnumList.get(index);
                            newArgs[index] = Conversions.coerce(type, methodParamAccess.getType(), arg);
                            continue block6;
                        }
                        newArgs[index] = arg;
                    }
                }
            }
            return this.invoke(object, newArgs);
        }
        if (this.method.isVarArgs() && paramLength == 1) {
            return this.invoke(object, new Object[]{args});
        }
        return Invoker.invokeOverloadedFromList(object, this.name(), Lists.list(args));
    }

    @Override
    public Object invoke(Object object, Object ... args) {
        try {
            return this.method.invoke(object, args);
        }
        catch (InvocationTargetException invocationTargetException) {
            return Exceptions.handle(Object.class, invocationTargetException.getTargetException(), "unable to invoke method", this.method, " on object ", object, "with arguments", args, "\nparameter types", this.parameterTypes(), "\nargument types are", args);
        }
        catch (Throwable ex) {
            return Exceptions.handle(Object.class, ex, "unable to invoke method", this.method, " on object ", object, "with arguments", args, "\nparameter types", this.parameterTypes(), "\nargument types are", args);
        }
    }

    public Object invokeBound(Object ... args) {
        try {
            return this.method.invoke(this.instance, args);
        }
        catch (Throwable ex) {
            return Exceptions.handle(Object.class, ex, "unable to invoke method", this.method, " on object with arguments", args, "\nparameter types", this.parameterTypes(), "\nargument types are");
        }
    }

    @Override
    public Object invokeStatic(Object ... args) {
        try {
            return this.method.invoke(null, args);
        }
        catch (Throwable ex) {
            return Exceptions.handle(Object.class, ex, "unable to invoke method", this.method, " with arguments", args);
        }
    }

    @Override
    public MethodAccess bind(Object instance) {
        Exceptions.die("Bind does not work for cached methodAccess make a copy with methodAccsess() first");
        return null;
    }

    @Override
    public MethodHandle methodHandle() {
        MethodHandle m;
        try {
            m = this.lookup.unreflect(this.method);
        }
        catch (Exception e) {
            m = null;
            Exceptions.handle(e);
        }
        return m;
    }

    @Override
    public MethodAccess methodAccess() {
        if (this.methodHandle == null) {
            this.methodHandle = this.methodHandle();
        }
        return new MethodAccessImpl(this.method){

            @Override
            public MethodAccess bind(Object instance) {
                this.methodHandle.bindTo(instance);
                this.instance = instance;
                return this;
            }

            @Override
            public Object bound() {
                return this.instance;
            }
        };
    }

    @Override
    public Object bound() {
        return null;
    }

    @Override
    public <T> ConstantCallSite invokeReducerLongIntReturnLongMethodHandle(T object) {
        MethodType methodType = MethodType.methodType(Long.TYPE, Long.TYPE, Integer.TYPE);
        try {
            return new ConstantCallSite(this.lookup.bind(object, this.name(), methodType));
        }
        catch (NoSuchMethodException e) {
            Exceptions.handle(e, "Method not found", this.name());
        }
        catch (IllegalAccessException e) {
            Exceptions.handle(e, "Illegal access to method", this.name());
        }
        return null;
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public int score() {
        return this.score;
    }

    @Override
    public Iterable<AnnotationData> annotationData() {
        return new Iterable<AnnotationData>(){

            @Override
            public Iterator<AnnotationData> iterator() {
                return MethodAccessImpl.this.annotationData.iterator();
            }
        };
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotationMap.containsKey(annotationName);
    }

    @Override
    public AnnotationData annotation(String annotationName) {
        return this.annotationMap.get(annotationName);
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.method.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.method.getModifiers());
    }

    @Override
    public MethodReturnAccess returnAccess() {
        return this.returnAccess;
    }

    @Override
    public String name() {
        return this.method.getName();
    }

    @Override
    public Class<?> declaringType() {
        return this.method.getDeclaringClass();
    }

    @Override
    public Class<?> returnType() {
        return this.method.getReturnType();
    }

    @Override
    public boolean respondsTo(Class<?>[] parametersToMatch) {
        boolean match = true;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length != parametersToMatch.length) {
            return false;
        }
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> type = parameterTypes[index];
            Class<?> matchToType = parametersToMatch[index];
            if (type.isPrimitive()) {
                if (type == Integer.TYPE && (matchToType == Integer.class || matchToType == Integer.TYPE) || type == Boolean.TYPE && (matchToType == Boolean.class || matchToType == Boolean.TYPE) || type == Long.TYPE && (matchToType == Long.class || matchToType == Long.TYPE) || type == Float.TYPE && (matchToType == Float.class || matchToType == Float.TYPE) || type == Double.TYPE && (matchToType == Double.class || matchToType == Double.TYPE) || type == Short.TYPE && (matchToType == Short.class || matchToType == Short.TYPE) || type == Byte.TYPE && (matchToType == Byte.class || matchToType == Byte.TYPE) || type == Character.TYPE && (matchToType == Character.class || matchToType == Character.TYPE)) continue;
                match = false;
                break;
            }
            if (type.isAssignableFrom(matchToType)) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public boolean respondsTo(Object ... args) {
        boolean match = true;
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (parameterTypes.length != args.length) {
            return false;
        }
        for (int index = 0; index < parameterTypes.length; ++index) {
            Class<?> matchToType;
            Object arg = args[index];
            Class<?> type = parameterTypes[index];
            Class<?> clazz = matchToType = arg != null ? arg.getClass() : null;
            if (type.isPrimitive()) {
                if (arg == null) {
                    match = false;
                    break;
                }
                if (type == Integer.TYPE && matchToType == Integer.class || type == Boolean.TYPE && matchToType == Boolean.class || type == Long.TYPE && matchToType == Long.class || type == Float.TYPE && matchToType == Float.class || type == Double.TYPE && matchToType == Double.class || type == Short.TYPE && matchToType == Short.class || type == Byte.TYPE && matchToType == Byte.class || type == Character.TYPE && matchToType == Character.class) continue;
                match = false;
                break;
            }
            if (arg == null || type.isInstance(arg)) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public Class<?>[] parameterTypes() {
        return this.method.getParameterTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    public String toString() {
        return "MethodAccessImpl{method=" + this.method + ", annotationData=" + this.annotationData + ", instance=" + this.instance + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodAccessImpl that = (MethodAccessImpl)o;
        if (this.annotationData != null ? !this.annotationData.equals(that.annotationData) : that.annotationData != null) {
            return false;
        }
        if (this.annotationMap != null ? !this.annotationMap.equals(that.annotationMap) : that.annotationMap != null) {
            return false;
        }
        if (this.instance != null ? !this.instance.equals(that.instance) : that.instance != null) {
            return false;
        }
        return !(this.method != null ? !this.method.equals(that.method) : that.method != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.annotationData != null ? this.annotationData.hashCode() : 0);
        result = 31 * result + (this.annotationMap != null ? this.annotationMap.hashCode() : 0);
        result = 31 * result + (this.instance != null ? this.instance.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(MethodAccess o2) {
        if (this.score() > o2.score()) {
            return -1;
        }
        if (this.score() < o2.score()) {
            return 1;
        }
        return 0;
    }

    @Override
    public List<TypeType> paramTypeEnumList() {
        return this.paramTypeEnumList;
    }

    @Override
    public List<MethodParamAccess> parameters() {
        return this.methodParamList;
    }
}

