/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core.reflection;

import io.advantageous.boon.core.Str;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AnnotationData {
    private String annotationClassName;
    private String annotationSimpleName;
    private String annotationPackageName;
    private Set<String> allowedAnnotations;
    private String name;
    private Map<String, Object> values;

    public AnnotationData(Annotation annotation) {
        this(annotation, new HashSet<String>());
    }

    public AnnotationData(Annotation annotation, Set<String> allowedAnnotations) {
        this.annotationSimpleName = annotation.annotationType().getSimpleName();
        this.annotationClassName = annotation.annotationType().getName();
        this.annotationPackageName = this.annotationClassName.substring(0, this.annotationClassName.length() - this.annotationSimpleName.length() - 1);
        this.allowedAnnotations = allowedAnnotations;
        this.name = Str.uncapitalize(this.annotationSimpleName);
        this.values = this.doGetValues(annotation);
    }

    public boolean isAllowed() {
        if (this.allowedAnnotations == null || this.allowedAnnotations.size() == 0) {
            return true;
        }
        return this.allowedAnnotations.contains(this.annotationPackageName);
    }

    public String getName() {
        return this.name;
    }

    Map<String, Object> doGetValues(Annotation annotation) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        Object[] noargs = null;
        for (Method method : methods) {
            if (method.getParameterTypes().length != 0) continue;
            try {
                Object value = method.invoke((Object)annotation, noargs);
                if (value instanceof Enum) {
                    Enum enumVal = (Enum)value;
                    value = enumVal.name();
                }
                values.put(method.getName(), value);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return values;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public String toString() {
        return this.name;
    }

    public String getFullClassName() {
        return this.annotationClassName;
    }

    public String getSimpleClassName() {
        return this.annotationSimpleName;
    }
}

