/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core;

import io.advantageous.boon.core.Typ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum TypeType {
    BOOLEAN(false, true),
    BYTE(false, true),
    SHORT(false, true),
    CHAR(false, true),
    INT(false, true),
    FLOAT(false, true),
    LONG(false, true),
    DOUBLE(false, true),
    LONG_WRAPPER(LONG),
    INTEGER_WRAPPER(INT),
    SHORT_WRAPPER(SHORT),
    CHAR_WRAPPER(CHAR),
    BOOLEAN_WRAPPER(BOOLEAN),
    BYTE_WRAPPER(BYTE),
    FLOAT_WRAPPER(FLOAT),
    DOUBLE_WRAPPER(DOUBLE),
    TRUE(BOOLEAN),
    FALSE(BOOLEAN),
    INSTANCE,
    NULL,
    INTERFACE,
    ABSTRACT,
    SYSTEM,
    VOID,
    UNKNOWN,
    BASIC_TYPE,
    CHAR_SEQUENCE,
    NUMBER,
    OBJECT,
    CLASS,
    ENUM,
    STRING(CHAR_SEQUENCE),
    CALENDAR,
    DATE,
    LOCALE_DATE_TIME,
    URL(BASIC_TYPE),
    URI(BASIC_TYPE),
    LOCALE(BASIC_TYPE),
    TIME_ZONE(BASIC_TYPE),
    CURRENCY(BASIC_TYPE),
    FILE(BASIC_TYPE),
    PATH(BASIC_TYPE),
    UUID(BASIC_TYPE),
    BIG_INT(NUMBER),
    BIG_DECIMAL(NUMBER),
    COLLECTION,
    LIST(COLLECTION),
    SET(COLLECTION),
    MAP,
    MAP_STRING_OBJECT(MAP),
    ARRAY(true),
    ARRAY_INT(true, INT),
    ARRAY_BYTE(true, SHORT),
    ARRAY_SHORT(true, SHORT),
    ARRAY_FLOAT(true, FLOAT),
    ARRAY_DOUBLE(true, DOUBLE),
    ARRAY_LONG(true, LONG),
    ARRAY_STRING(true, STRING),
    ARRAY_OBJECT(true, OBJECT),
    VALUE_MAP,
    VALUE;

    final TypeType baseTypeOrWrapper;
    private final boolean array;
    private final boolean primitive;

    private TypeType() {
        this.baseTypeOrWrapper = null;
        this.array = false;
        this.primitive = false;
    }

    private TypeType(TypeType type) {
        this.baseTypeOrWrapper = type;
        this.array = false;
        this.primitive = false;
    }

    private TypeType(boolean isarray) {
        this.array = isarray;
        this.baseTypeOrWrapper = null;
        this.primitive = false;
    }

    private TypeType(boolean isarray, TypeType type) {
        this.array = isarray;
        this.baseTypeOrWrapper = type;
        this.primitive = false;
    }

    private TypeType(boolean array, boolean primitive) {
        this.array = array;
        this.primitive = primitive;
        this.baseTypeOrWrapper = null;
    }

    public static TypeType getInstanceType(Object object) {
        if (object == null) {
            return NULL;
        }
        return TypeType.getType(object.getClass(), object);
    }

    public static TypeType getType(Class<?> clazz) {
        return TypeType.getType(clazz, null);
    }

    public static TypeType getType(Class<?> clazz, Object object) {
        String className = clazz.getName();
        TypeType type = TypeType.getType(className);
        if (type != UNKNOWN) {
            return type;
        }
        if (clazz.isInterface()) {
            type = INTERFACE;
        } else if (clazz.isEnum()) {
            type = ENUM;
        } else if (clazz.isArray()) {
            type = TypeType.getArrayType(clazz);
        } else if (Typ.isAbstract(clazz)) {
            type = ABSTRACT;
        } else if (className.startsWith("java")) {
            type = Typ.isCharSequence(clazz) ? CHAR_SEQUENCE : (Typ.isCollection(clazz) ? (Typ.isList(clazz) ? LIST : (Typ.isSet(clazz) ? SET : COLLECTION)) : (Typ.isMap(clazz) ? MAP : SYSTEM));
        } else if (className.startsWith("com.sun") || className.startsWith("sun.")) {
            type = SYSTEM;
        } else if (object != null) {
            if (object instanceof Map) {
                type = MAP;
            } else if (object instanceof Collection) {
                type = COLLECTION;
                if (object instanceof List) {
                    type = LIST;
                } else if (object instanceof Set) {
                    type = SET;
                }
            } else {
                type = INSTANCE;
            }
        } else {
            type = INSTANCE;
        }
        return type;
    }

    private static TypeType getArrayType(Class<?> clazz) {
        TypeType type;
        TypeType componentType = TypeType.getType(clazz.getComponentType());
        switch (componentType) {
            case BYTE: {
                type = ARRAY_BYTE;
                break;
            }
            case SHORT: {
                type = ARRAY_SHORT;
                break;
            }
            case INT: {
                type = ARRAY_INT;
                break;
            }
            case FLOAT: {
                type = ARRAY_FLOAT;
                break;
            }
            case DOUBLE: {
                type = ARRAY_DOUBLE;
                break;
            }
            case LONG: {
                type = ARRAY_LONG;
                break;
            }
            case STRING: {
                type = ARRAY_STRING;
                break;
            }
            case OBJECT: {
                type = ARRAY_OBJECT;
                break;
            }
            default: {
                type = ARRAY;
            }
        }
        return type;
    }

    public static TypeType getType(String typeName) {
        switch (typeName) {
            case "int": {
                return INT;
            }
            case "short": {
                return SHORT;
            }
            case "byte": {
                return BYTE;
            }
            case "float": {
                return FLOAT;
            }
            case "double": {
                return DOUBLE;
            }
            case "boolean": {
                return BOOLEAN;
            }
            case "char": {
                return CHAR;
            }
            case "long": {
                return LONG;
            }
            case "java.lang.String": {
                return STRING;
            }
            case "java.lang.Boolean": {
                return BOOLEAN_WRAPPER;
            }
            case "java.lang.Byte": {
                return BYTE_WRAPPER;
            }
            case "java.lang.Short": {
                return SHORT_WRAPPER;
            }
            case "java.lang.Integer": {
                return INTEGER_WRAPPER;
            }
            case "java.lang.Double": {
                return DOUBLE_WRAPPER;
            }
            case "java.lang.Float": {
                return FLOAT_WRAPPER;
            }
            case "java.lang.Character": {
                return CHAR_WRAPPER;
            }
            case "java.lang.Number": {
                return NUMBER;
            }
            case "java.lang.Class": {
                return CLASS;
            }
            case "java.lang.Void": {
                return VOID;
            }
            case "java.lang.Long": {
                return LONG_WRAPPER;
            }
            case "java.util.Set": 
            case "java.util.HashSet": 
            case "java.util.TreeSet": {
                return SET;
            }
            case "java.util.List": 
            case "java.util.ArrayList": 
            case "java.util.LinkedList": {
                return LIST;
            }
            case "java.util.Map": 
            case "java.util.HashMap": 
            case "java.util.LinkedHashMap": 
            case "java.util.TreeMap": {
                return MAP;
            }
            case "java.lang.CharSequence": {
                return CHAR_SEQUENCE;
            }
            case "java.math.BigDecimal": {
                return BIG_DECIMAL;
            }
            case "java.math.BigInteger": {
                return BIG_INT;
            }
            case "java.util.Date": 
            case "java.sql.Date": 
            case "java.sql.Time": 
            case "java.sql.Timestamp": {
                return DATE;
            }
            case "java.util.Calendar": {
                return CALENDAR;
            }
            case "java.time.LocalDateTime": {
                return LOCALE_DATE_TIME;
            }
            case "io.advantageous.boon.core.LazyMap": 
            case "io.advantageous.boon.core.value.LazyValueMap": {
                return MAP;
            }
            case "io.advantageous.boon.core.value.ValueList": {
                return LIST;
            }
            case "io.advantageous.boon.core.value.ValueMapImpl": {
                return VALUE_MAP;
            }
            case "io.advantageous.boon.core.value.NumberValue": 
            case "io.advantageous.boon.core.value.CharSequenceValue": {
                return VALUE;
            }
            case "java.lang.Object": {
                return OBJECT;
            }
            case "java.io.File": {
                return FILE;
            }
            case "java.net.URI": {
                return URI;
            }
            case "java.net.URL": {
                return URL;
            }
            case "java.nio.file.Path": {
                return PATH;
            }
            case "java.util.UUID": {
                return UUID;
            }
            case "java.util.Locale": {
                return LOCALE;
            }
            case "java.util.TimeZone": {
                return TIME_ZONE;
            }
            case "java.util.Currency": {
                return CURRENCY;
            }
        }
        return UNKNOWN;
    }

    public static List<Object> gatherTypes(List<?> list) {
        ArrayList<Object> types = new ArrayList<Object>();
        for (Object o : list) {
            if (o instanceof List) {
                types.add(TypeType.gatherTypes((List)o));
                continue;
            }
            types.add((Object)TypeType.getInstanceType(o));
        }
        return types;
    }

    public static List<Object> gatherActualTypes(List<?> list) {
        ArrayList<Object> types = new ArrayList<Object>();
        for (Object o : list) {
            if (o instanceof List) {
                types.add(TypeType.gatherActualTypes((List)o));
                continue;
            }
            types.add(TypeType.getActualType(o));
        }
        return types;
    }

    private static Object getActualType(Object o) {
        if (o == null) {
            return NULL;
        }
        return o.getClass().getSimpleName();
    }

    public static List<TypeType> gatherTypes(Object ... list) {
        ArrayList<TypeType> types = new ArrayList<TypeType>();
        for (Object o : list) {
            types.add(TypeType.getInstanceType(o));
        }
        return types;
    }

    public boolean hasLength() {
        switch (this) {
            case STRING: 
            case LIST: 
            case MAP: 
            case CHAR_SEQUENCE: 
            case SET: 
            case COLLECTION: {
                return true;
            }
        }
        return this.isArray() || this.isCollection();
    }

    public boolean isCollection() {
        switch (this) {
            case LIST: 
            case SET: 
            case COLLECTION: {
                return true;
            }
        }
        if (this.baseTypeOrWrapper == null) {
            return false;
        }
        return this.baseTypeOrWrapper.isCollection();
    }

    public TypeType wraps() {
        return this.baseTypeOrWrapper;
    }

    public TypeType baseType() {
        return this.baseTypeOrWrapper;
    }

    public TypeType componentType() {
        return this.baseTypeOrWrapper == null ? OBJECT : this.baseTypeOrWrapper;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isMap() {
        return this == MAP || this.baseTypeOrWrapper == MAP;
    }
}

