/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.core;

import io.advantageous.boon.core.Lists;
import io.advantageous.boon.core.reflection.BeanUtils;
import io.advantageous.boon.core.reflection.MapObjectConversion;
import io.advantageous.boon.primitive.CharBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArraySet;

public class Sets {
    public static <V> Set<V> set(Collection<V> collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        if (collection == null) {
            return Collections.EMPTY_SET;
        }
        return new LinkedHashSet<V>(collection);
    }

    public static <V> Enumeration<V> enumeration(Set<V> set) {
        final Iterator<V> iter = set.iterator();
        return new Enumeration<V>(){

            @Override
            public boolean hasMoreElements() {
                return iter.hasNext();
            }

            @Override
            public V nextElement() {
                return iter.next();
            }
        };
    }

    public static <V> Set<V> set(Class<V> clazz) {
        return new LinkedHashSet();
    }

    public static <V> Set<V> set(Iterable<V> iterable) {
        LinkedHashSet<V> set = new LinkedHashSet<V>();
        for (V o : iterable) {
            set.add(o);
        }
        return set;
    }

    public static <V> Set<V> set(Enumeration<V> enumeration) {
        LinkedHashSet<V> set = new LinkedHashSet<V>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static <V> Set<V> set(Iterator<V> iterator) {
        LinkedHashSet<V> set = new LinkedHashSet<V>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @SafeVarargs
    public static <V> Set<V> set(V ... array) {
        LinkedHashSet<V> set = new LinkedHashSet<V>();
        for (V v : array) {
            set.add(v);
        }
        return set;
    }

    @SafeVarargs
    public static <V> Set<V> set(int size, V ... array) {
        int index = 0;
        LinkedHashSet<V> set = new LinkedHashSet<V>();
        for (V v : array) {
            set.add(v);
            if (++index == size) break;
        }
        return set;
    }

    public static <V> NavigableSet<V> sortedSet(Iterator<V> iterator) {
        TreeSet<V> set = new TreeSet<V>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <V> NavigableSet<V> sortedSet(Class<V> clazz) {
        return new TreeSet();
    }

    public static <V> NavigableSet<V> sortedSet(Iterable<V> iterable) {
        TreeSet<V> set = new TreeSet<V>();
        for (V o : iterable) {
            set.add(o);
        }
        return set;
    }

    public static <V> NavigableSet<V> sortedSet(Enumeration<V> enumeration) {
        TreeSet<V> set = new TreeSet<V>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    @SafeVarargs
    public static <V> NavigableSet<V> sortedSet(V ... array) {
        TreeSet<V> set = new TreeSet<V>();
        for (V v : array) {
            set.add(v);
        }
        return set;
    }

    public static <V> NavigableSet<V> sortedSet(Collection<V> collection) {
        return new TreeSet<V>(collection);
    }

    public static <V> NavigableSet<V> safeSortedSet(Iterator<V> iterator) {
        ConcurrentSkipListSet<V> set = new ConcurrentSkipListSet<V>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <V> NavigableSet<V> safeSortedSet(Class<V> clazz) {
        return new ConcurrentSkipListSet();
    }

    public static <V> NavigableSet<V> safeSortedSet(Iterable<V> iterable) {
        ConcurrentSkipListSet<V> set = new ConcurrentSkipListSet<V>();
        for (V o : iterable) {
            set.add(o);
        }
        return set;
    }

    public static <V> NavigableSet<V> safeSortedSet(Enumeration<V> enumeration) {
        ConcurrentSkipListSet<V> set = new ConcurrentSkipListSet<V>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    @SafeVarargs
    public static <V> NavigableSet<V> safeSortedSet(V ... array) {
        ConcurrentSkipListSet<V> set = new ConcurrentSkipListSet<V>();
        for (V v : array) {
            set.add(v);
        }
        return set;
    }

    public static <V> NavigableSet<V> safeSortedSet(Collection<V> collection) {
        return new ConcurrentSkipListSet<V>(collection);
    }

    public static <V> Set<V> safeSet(Class<V> clazz) {
        return new CopyOnWriteArraySet();
    }

    public static <V> Set<V> safeSet(Iterable<V> iterable) {
        CopyOnWriteArraySet<V> set = new CopyOnWriteArraySet<V>();
        for (V o : iterable) {
            set.add(o);
        }
        return set;
    }

    public static <V> Set<V> safeSet(Enumeration<V> enumeration) {
        CopyOnWriteArraySet<V> set = new CopyOnWriteArraySet<V>();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static <V> Set<V> safeSet(Iterator<V> iterator) {
        CopyOnWriteArraySet<V> set = new CopyOnWriteArraySet<V>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    @SafeVarargs
    public static <V> Set<V> safeSet(V ... array) {
        List<V> list = Lists.list(array);
        CopyOnWriteArraySet<V> set = new CopyOnWriteArraySet<V>(list);
        return set;
    }

    public static <V> Set<V> safeSet(Collection<V> collection) {
        return new CopyOnWriteArraySet<V>(collection);
    }

    public static int len(Set<?> set) {
        return set.size();
    }

    public static <V> boolean in(V value, Set<?> set) {
        return set.contains(value);
    }

    public static <V> void add(Set<V> set, V value) {
        set.add(value);
    }

    public static <T> T idx(NavigableSet<T> set, T index) {
        return set.higher(index);
    }

    public static <T> T idx(Set<T> set, T index) {
        if (set instanceof NavigableSet) {
            return Sets.idx((NavigableSet)set, index);
        }
        throw new IllegalArgumentException("Set must be a NavigableSet for idx operation to work");
    }

    public static <T> T after(NavigableSet<T> set, T index) {
        return set.higher(index);
    }

    public static <T> T before(NavigableSet<T> set, T index) {
        return set.lower(index);
    }

    public static <V> SortedSet<V> slc(NavigableSet<V> set, V startIndex, V endIndex) {
        return set.subSet(startIndex, endIndex);
    }

    public static <V> SortedSet<V> slcEnd(NavigableSet<V> set, V fromIndex) {
        return set.tailSet(fromIndex);
    }

    public static <V> SortedSet<V> slc(NavigableSet<V> set, V toIndex) {
        return set.headSet(toIndex);
    }

    public static <V> Set<V> copy(HashSet<V> collection) {
        return new LinkedHashSet<V>(collection);
    }

    public static <V> NavigableSet<V> copy(TreeSet<V> collection) {
        return new TreeSet<V>(collection);
    }

    public static <V> Set<V> copy(CopyOnWriteArraySet<V> collection) {
        return new CopyOnWriteArraySet<V>(collection);
    }

    public static <V> NavigableSet<V> copy(ConcurrentSkipListSet<V> collection) {
        return new ConcurrentSkipListSet<V>(collection);
    }

    public static <V> NavigableSet<V> copy(NavigableSet<V> collection) {
        if (collection instanceof ConcurrentSkipListSet) {
            return Sets.copy((ConcurrentSkipListSet)collection);
        }
        return Sets.copy((TreeSet)collection);
    }

    public static <V> Set<V> copy(Set<V> collection) {
        if (collection instanceof NavigableSet) {
            return Sets.copy((NavigableSet)collection);
        }
        if (collection instanceof CopyOnWriteArraySet) {
            return Sets.copy((CopyOnWriteArraySet)collection);
        }
        return Sets.copy((LinkedHashSet)collection);
    }

    public static <V> Set<V> deepCopy(Collection<V> collection) {
        LinkedHashSet<V> newSet = new LinkedHashSet<V>(collection.size());
        for (V v : collection) {
            newSet.add(BeanUtils.copy(v));
        }
        return newSet;
    }

    public static <V> Set<V> deepCopyToSet(Collection<V> src, Set<V> dst) {
        for (V v : src) {
            dst.add(BeanUtils.copy(v));
        }
        return dst;
    }

    public static <V, T> List<T> deepCopy(Collection<V> src, Class<T> dest) {
        ArrayList<T> list = new ArrayList<T>(src.size());
        for (V v : src) {
            list.add(BeanUtils.createFromSrc(v, dest));
        }
        return list;
    }

    public static <V> Set<V> deepCopy(Set<V> set) {
        if (set instanceof LinkedHashSet) {
            return Sets.deepCopyToSet(set, new LinkedHashSet());
        }
        if (set instanceof CopyOnWriteArraySet) {
            return Sets.deepCopyToSet(set, new CopyOnWriteArraySet());
        }
        if (set instanceof HashSet) {
            return Sets.deepCopyToSet(set, new HashSet());
        }
        return Sets.deepCopy(set);
    }

    public static List<Map<String, Object>> toListOfMaps(Set<?> set) {
        return MapObjectConversion.toListOfMaps(set);
    }

    public static <T> Set<T> setFromProperty(Class<T> propertyType, String propertyPath, Collection<?> list) {
        LinkedHashSet<Object> newSet = new LinkedHashSet<Object>(list.size());
        for (Object item : list) {
            Object newItem = BeanUtils.idx(item, propertyPath);
            newSet.add(newItem);
        }
        return newSet;
    }

    public static <T> Set<T> setFromProperty(Class<T> propertyType, String propertyPath, Iterable<?> list) {
        LinkedHashSet<Object> newSet = new LinkedHashSet<Object>();
        for (Object item : list) {
            Object newItem = BeanUtils.idx(item, propertyPath);
            newSet.add(newItem);
        }
        return newSet;
    }

    public static String toPrettyJson(Set set) {
        CharBuf buf = CharBuf.createCharBuf();
        return buf.prettyPrintCollection(set, false, 0).toString();
    }
}

