/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json.serializers.impl;

import io.advantageous.boon.json.serializers.JsonSerializerInternal;
import io.advantageous.boon.json.serializers.MapSerializer;
import io.advantageous.boon.primitive.CharBuf;
import java.util.Map;
import java.util.Set;

public class MapSerializerThatEncodesKeys
implements MapSerializer {
    private static final char[] EMPTY_MAP_CHARS = new char[]{'{', '}'};
    private final boolean includeNulls;

    public MapSerializerThatEncodesKeys(boolean includeNulls) {
        this.includeNulls = includeNulls;
    }

    private void serializeFieldName(JsonSerializerInternal serializer, Object key, CharBuf builder) {
        serializer.serializeObject(key, builder);
        builder.add(':');
    }

    @Override
    public final void serializeMap(JsonSerializerInternal serializer, Map<Object, Object> map, CharBuf builder) {
        if (map.size() == 0) {
            builder.addChars(EMPTY_MAP_CHARS);
            return;
        }
        builder.addChar('{');
        Set<Map.Entry<Object, Object>> entrySet = map.entrySet();
        int index = 0;
        if (!this.includeNulls) {
            for (Map.Entry<Object, Object> entry : entrySet) {
                if (entry.getValue() == null) continue;
                this.serializeFieldName(serializer, entry.getKey(), builder);
                serializer.serializeObject(entry.getValue(), builder);
                builder.addChar(',');
                ++index;
            }
        } else {
            for (Map.Entry<Object, Object> entry : entrySet) {
                this.serializeFieldName(serializer, entry.getKey(), builder);
                serializer.serializeObject(entry.getValue(), builder);
                builder.addChar(',');
                ++index;
            }
        }
        if (index > 0) {
            builder.removeLastChar();
        }
        builder.addChar('}');
    }
}

