/*
 * Decompiled with CFR 0.152.
 */
package io.advantageous.boon.json;

import io.advantageous.boon.core.Str;
import io.advantageous.boon.core.reflection.Mapper;
import io.advantageous.boon.core.reflection.MapperComplex;
import io.advantageous.boon.core.reflection.MapperSimple;
import io.advantageous.boon.core.reflection.fields.FieldAccessMode;
import io.advantageous.boon.json.JsonMappingParser;
import io.advantageous.boon.json.JsonParserAndMapper;
import io.advantageous.boon.json.JsonParserEvents;
import io.advantageous.boon.json.implementation.BaseJsonParserAndMapper;
import io.advantageous.boon.json.implementation.JsonAsciiParser;
import io.advantageous.boon.json.implementation.JsonFastParser;
import io.advantageous.boon.json.implementation.JsonParserCharArray;
import io.advantageous.boon.json.implementation.JsonParserLax;
import io.advantageous.boon.json.implementation.JsonParserUsingCharacterSource;
import io.advantageous.boon.json.implementation.JsonUTF8Parser;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class JsonParserFactory {
    private Charset charset = StandardCharsets.UTF_8;
    private boolean lax;
    private boolean chop = false;
    private boolean lazyChop = true;
    private FieldAccessMode fieldAccessType = FieldAccessMode.FIELD;
    private boolean useAnnotations = true;
    private boolean caseInsensitiveFields;
    private Set<String> ignoreSet;
    private String view;
    private boolean respectIgnore = true;
    private boolean acceptSingleValueAsArray;
    private boolean checkDates = true;

    public FieldAccessMode getFieldAccessType() {
        return this.fieldAccessType;
    }

    public boolean isChop() {
        return this.chop;
    }

    public JsonParserFactory setChop(boolean chop) {
        this.chop = chop;
        return this;
    }

    public boolean isLazyChop() {
        return this.lazyChop;
    }

    public JsonParserFactory setLazyChop(boolean lazyChop) {
        this.lazyChop = lazyChop;
        return this;
    }

    public JsonParserFactory lax() {
        this.lax = true;
        return this;
    }

    public JsonParserFactory strict() {
        this.lax = false;
        return this;
    }

    public JsonParserFactory setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public JsonParserAndMapper createFastParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonFastParser(false, this.chop, this.lazyChop, this.checkDates), this.createMapper());
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    private Mapper createMapper() {
        if (this.useAnnotations && !this.caseInsensitiveFields && !this.acceptSingleValueAsArray && this.ignoreSet == null && Str.isEmpty((String)this.view) && this.respectIgnore) {
            return new MapperSimple(this.fieldAccessType.create(true));
        }
        return new MapperComplex(this.fieldAccessType, this.useAnnotations, this.caseInsensitiveFields, this.ignoreSet, this.view, this.respectIgnore, this.acceptSingleValueAsArray);
    }

    public JsonParserAndMapper createFastObjectMapperParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonFastParser(true), this.createMapper());
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createUTF8DirectByteParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonUTF8Parser(), this.createMapper());
        jsonParser.setCharset(StandardCharsets.UTF_8);
        return jsonParser;
    }

    public JsonParserAndMapper createASCIIParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonAsciiParser(), this.createMapper());
        jsonParser.setCharset(StandardCharsets.US_ASCII);
        return jsonParser;
    }

    public JsonParserAndMapper createLaxParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserLax(false, this.chop, this.lazyChop, this.checkDates), this.createMapper());
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createParserWithEvents(JsonParserEvents events) {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserLax(false, this.chop, this.lazyChop, false, events), this.createMapper());
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createCharacterSourceParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserUsingCharacterSource(), this.createMapper());
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createJsonCharArrayParser() {
        BaseJsonParserAndMapper jsonParser = new BaseJsonParserAndMapper(new JsonParserCharArray(), this.createMapper());
        jsonParser.setCharset(this.charset);
        return jsonParser;
    }

    public JsonParserAndMapper createLazyFinalParser() {
        return this.createFastParser();
    }

    public JsonParserAndMapper createJsonParserForJsonPath() {
        return this.createFastParser();
    }

    public JsonParserAndMapper create() {
        if (this.charset == null) {
            this.charset = StandardCharsets.UTF_8;
        }
        return new JsonMappingParser(this.createMapper(), this.charset, this.lax, this.chop, this.lazyChop);
    }

    public boolean isUsePropertiesFirst() {
        return this.fieldAccessType == FieldAccessMode.PROPERTY_THEN_FIELD;
    }

    public JsonParserFactory usePropertiesFirst() {
        this.fieldAccessType = FieldAccessMode.PROPERTY_THEN_FIELD;
        return this;
    }

    public boolean isUseFieldsFirst() {
        return this.fieldAccessType == FieldAccessMode.FIELD_THEN_PROPERTY;
    }

    public JsonParserFactory useFieldsFirst() {
        this.fieldAccessType = FieldAccessMode.FIELD_THEN_PROPERTY;
        return this;
    }

    public JsonParserFactory useFieldsOnly() {
        this.fieldAccessType = FieldAccessMode.FIELD;
        return this;
    }

    public JsonParserFactory usePropertyOnly() {
        this.fieldAccessType = FieldAccessMode.PROPERTY;
        return this;
    }

    public JsonParserFactory useAnnotations() {
        this.useAnnotations = true;
        return this;
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public JsonParserFactory setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
        return this;
    }

    public JsonParserFactory caseInsensitiveFields() {
        this.caseInsensitiveFields = true;
        return this;
    }

    public boolean isCaseInsensitiveFields() {
        return this.caseInsensitiveFields;
    }

    public JsonParserFactory setCaseInsensitiveFields(boolean caseInsensitiveFields) {
        this.caseInsensitiveFields = caseInsensitiveFields;
        return this;
    }

    public Set<String> getIgnoreSet() {
        return this.ignoreSet;
    }

    public JsonParserFactory setIgnoreSet(Set<String> ignoreSet) {
        this.ignoreSet = ignoreSet;
        return this;
    }

    public String getView() {
        return this.view;
    }

    public JsonParserFactory setView(String view) {
        this.view = view;
        return this;
    }

    public boolean isRespectIgnore() {
        return this.respectIgnore;
    }

    public JsonParserFactory setRespectIgnore(boolean respectIgnore) {
        this.respectIgnore = respectIgnore;
        return this;
    }

    public JsonParserFactory acceptSingleValueAsArray() {
        this.acceptSingleValueAsArray = true;
        return this;
    }

    public boolean isAcceptSingleValueAsArray() {
        return this.acceptSingleValueAsArray;
    }

    public JsonParserFactory setAcceptSingleValueAsArray(boolean acceptSingleValueAsArray) {
        this.acceptSingleValueAsArray = acceptSingleValueAsArray;
        return this;
    }

    public JsonParserFactory setCheckDates(boolean flag) {
        this.checkDates = flag;
        return this;
    }

    public boolean isCheckDatesSet() {
        return this.checkDates;
    }
}

