/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal;

import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class BackgroundImage {
    private static final int DEFAULT_DPI = 72;
    private final byte[] imageBytes;
    private final Repeat repeat;
    private final Float pageWidth;
    private final Float pageHeight;
    private final Position position;
    private final Float leftMargin;
    private final Float rightMargin;
    private final Float topMargin;
    private final Float bottomMargin;

    private BackgroundImage(Builder builder) {
        this.imageBytes = builder.bytes;
        this.repeat = builder.repeat;
        this.pageWidth = builder.pageWidth;
        this.pageHeight = builder.pageHeight;
        this.position = builder.position;
        this.leftMargin = builder.leftMargin;
        this.rightMargin = builder.rightMargin;
        this.topMargin = builder.topMargin;
        this.bottomMargin = builder.bottomMargin;
    }

    public ByteArrayOutputStream insert(ByteArrayOutputStream out) {
        try {
            Image image = Image.getInstance((byte[])this.imageBytes);
            float imageWidth = image.getWidth() * 72.0f / (float)image.getDpiX();
            float imageHeight = image.getHeight() * 72.0f / (float)image.getDpiY();
            switch (this.repeat) {
                case BOTH: {
                    ByteArrayOutputStream stream = out;
                    for (float x = this.leftMargin.floatValue(); x < this.pageWidth.floatValue() - this.rightMargin.floatValue(); x += imageWidth) {
                        for (float y = this.pageHeight.floatValue() - this.topMargin.floatValue(); y > this.bottomMargin.floatValue(); y -= imageHeight) {
                            if (x + imageWidth > this.pageWidth.floatValue() - this.rightMargin.floatValue() || y - imageHeight < this.bottomMargin.floatValue()) {
                                byte[] data = new byte[(int)imageWidth * (int)imageHeight];
                                for (int k = 0; k < (int)imageHeight; ++k) {
                                    int i = 0;
                                    while ((float)i < imageWidth) {
                                        if (x + (float)i < this.pageWidth.floatValue() - this.rightMargin.floatValue() && y - (float)k > this.bottomMargin.floatValue()) {
                                            data[i + k * (int)imageWidth] = -1;
                                        }
                                        ++i;
                                    }
                                }
                                Image clone = Image.getInstance((Image)image);
                                Image mask = Image.getInstance((int)((int)imageWidth), (int)((int)imageHeight), (int)1, (int)8, (byte[])data);
                                mask.makeMask();
                                clone.setImageMask(mask);
                                clone.setAbsolutePosition(x, y - imageHeight);
                                stream = this.insertImage(stream, clone);
                                continue;
                            }
                            image.setAbsolutePosition(x, y - imageHeight);
                            image.scaleAbsolute(imageWidth, imageHeight);
                            stream = this.insertImage(stream, image);
                        }
                    }
                    return stream;
                }
                case NONE: {
                    float x;
                    float y;
                    if (this.position.name().split("_")[0].equals("TOP")) {
                        y = this.pageHeight.floatValue() - imageHeight - this.topMargin.floatValue();
                    } else if (this.position.name().split("_")[0].equals("CENTER")) {
                        y = (this.pageHeight.floatValue() - imageHeight - this.topMargin.floatValue()) / 2.0f;
                    } else if (this.position.name().split("_")[0].equals("BOTTOM")) {
                        y = this.bottomMargin.floatValue();
                    } else {
                        throw new UnsupportedOperationException((Object)((Object)this.position) + " is not supported");
                    }
                    if (this.position.name().split("_")[1].equals("LEFT")) {
                        x = this.leftMargin.floatValue();
                    } else if (this.position.name().split("_")[1].equals("CENTER")) {
                        x = (this.pageWidth.floatValue() - imageWidth - this.rightMargin.floatValue()) / 2.0f;
                    } else if (this.position.name().split("_")[1].equals("RIGHT")) {
                        x = this.pageWidth.floatValue() - imageWidth - this.rightMargin.floatValue();
                    } else {
                        throw new UnsupportedOperationException((Object)((Object)this.position) + " is not supported");
                    }
                    image.setAbsolutePosition(x, y);
                    image.scaleAbsolute(imageWidth, imageHeight);
                    return this.insertImage(out, image);
                }
                case STRETCH: {
                    image.setAbsolutePosition(this.leftMargin.floatValue(), this.bottomMargin.floatValue());
                    image.scaleAbsolute(this.pageWidth.floatValue() - this.leftMargin.floatValue() - this.rightMargin.floatValue(), this.pageHeight.floatValue() - this.topMargin.floatValue() - this.bottomMargin.floatValue());
                    return this.insertImage(out, image);
                }
            }
            throw new UnsupportedOperationException((Object)((Object)this.repeat) + " is not implemented");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ByteArrayOutputStream insertImage(ByteArrayOutputStream out, Image image) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(out.size());
            PdfReader reader = new PdfReader(out.toByteArray());
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)os);
            for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                PdfContentByte canvas = stamper.getUnderContent(i);
                canvas.addImage(image);
            }
            reader.close();
            stamper.close();
            return os;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private final byte[] bytes;
        private Float pageWidth;
        private Float pageHeight;
        private Repeat repeat;
        private Position position;
        private Float leftMargin;
        private Float rightMargin;
        private Float topMargin;
        private Float bottomMargin;

        public Builder(byte[] image) {
            this.bytes = image;
        }

        public Builder setPageWidth(float width) {
            this.pageWidth = Float.valueOf(width);
            return this;
        }

        public Builder setPageHeight(float height) {
            this.pageHeight = Float.valueOf(height);
            return this;
        }

        public Builder setRepeat(Repeat repeat) {
            this.repeat = repeat;
            return this;
        }

        public Builder setPosition(Position position) {
            this.position = position;
            return this;
        }

        public Builder setLeftMargin(Float margin) {
            this.leftMargin = margin;
            return this;
        }

        public Builder setRightMargin(Float margin) {
            this.rightMargin = margin;
            return this;
        }

        public Builder setTopMargin(Float margin) {
            this.topMargin = margin;
            return this;
        }

        public Builder setBottomMargin(Float margin) {
            this.bottomMargin = margin;
            return this;
        }

        public BackgroundImage build() {
            return new BackgroundImage(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        TOP_LEFT("top left"),
        TOP_CENTER("top center"),
        TOP_RIGHT("top right"),
        CENTER_LEFT("center left"),
        CENTER_CENTER("center center", "center"),
        CENTER_RIGHT("center right"),
        BOTTOM_LEFT("bottom left"),
        BOTTOM_CENTER("bottom center"),
        BOTTOM_RIGHT("bottom right");

        private String[] odtValues;

        private Position(String ... odtValues) {
            this.odtValues = odtValues;
        }

        public static Position fromODT(String str) {
            for (Position position : Position.values()) {
                for (String odtValue : position.odtValues) {
                    if (!odtValue.equals(str)) continue;
                    return position;
                }
            }
            throw new IllegalArgumentException(str + " odt value not recognized.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Repeat {
        STRETCH("stretch"),
        NONE("no-repeat"),
        BOTH("repeat");

        private String odtValue;

        private Repeat(String odtValue) {
            this.odtValue = odtValue;
        }

        public static Repeat fromODT(String str) {
            for (Repeat repeat : Repeat.values()) {
                if (!repeat.odtValue.equals(str)) continue;
                return repeat;
            }
            throw new IllegalArgumentException(str + " odt value not recognized.");
        }
    }
}

