/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.converter.core.utils.StringUtils;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableColumnsElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFUtils {
    public static final String NON_BREAKING_SPACE_STR = "\u00a0";
    public static final String TAB_STR = "\t";
    private static final String REL_SIZE_UNIT = "*";
    private static final String PERCENT_UNIT = "%";
    private static final String INCH_UNIT = "in";
    private static final String POINT_UNIT = "pt";
    private static final String MM_UNIT = "mm";
    private static final String CM_UNIT = "cm";

    public static float[] getColumnWidths(TableTableElement table, OdfDocument odfDocument) {
        List<String> colWidths = ODFUtils.getColumnWidthsAsString((Node)table, odfDocument);
        int i = 0;
        float[] widths = new float[colWidths.size()];
        for (String s : colWidths) {
            widths[i++] = ODFUtils.getDimensionAsPoint(s).floatValue();
        }
        return widths;
    }

    public static List<String> getColumnWidthsAsString(Node table, OdfDocument odfDocument) {
        ArrayList<String> colWidths = new ArrayList<String>();
        Node node = null;
        NodeList tableColums = table.getChildNodes();
        for (int i = 0; i < tableColums.getLength(); ++i) {
            node = tableColums.item(i);
            if (TableTableColumnElement.ELEMENT_NAME.getLocalName().equals(node.getLocalName())) {
                TableTableColumnElement tableColumn = (TableTableColumnElement)node;
                Integer numberColumnsRepeated = tableColumn.getTableNumberColumnsRepeatedAttribute();
                String styleName = tableColumn.getTableStyleNameAttribute();
                try {
                    StyleTableColumnPropertiesElement tableColumnProperties;
                    String columnWidth = null;
                    OdfStyle style = ODFUtils.getOdfStyle(odfDocument, styleName, OdfStyleFamily.TableColumn);
                    if (style != null && (tableColumnProperties = ODFUtils.getStyleTableColumnPropertiesElement(style)) != null) {
                        columnWidth = tableColumnProperties.getStyleColumnWidthAttribute();
                    }
                    if (StringUtils.isEmpty(columnWidth)) {
                        columnWidth = "1";
                    }
                    if (numberColumnsRepeated == null) {
                        colWidths.add(columnWidth);
                        continue;
                    }
                    for (int j = 0; j < numberColumnsRepeated; ++j) {
                        colWidths.add(columnWidth);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (!TableTableColumnsElement.ELEMENT_NAME.getLocalName().equals(node.getLocalName())) break;
            return ODFUtils.getColumnWidthsAsString(node, odfDocument);
        }
        return colWidths;
    }

    public static OdfStyle getOdfStyle(OdfDocument odfDocument, String styleName, OdfStyleFamily styleFamily) throws Exception {
        OdfStyle style = null;
        if (odfDocument.getContentDom() != null && odfDocument.getContentDom().getAutomaticStyles() != null) {
            style = odfDocument.getContentDom().getAutomaticStyles().getStyle(styleName, styleFamily);
        }
        if (style == null && odfDocument.getStylesDom() != null && odfDocument.getStylesDom().getAutomaticStyles() != null) {
            style = odfDocument.getStylesDom().getAutomaticStyles().getStyle(styleName, styleFamily);
        }
        return style;
    }

    public static StyleTableColumnPropertiesElement getStyleTableColumnPropertiesElement(OdfStyle style) {
        Node node = null;
        NodeList nodes = style.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            node = nodes.item(i);
            if (!StyleTableColumnPropertiesElement.ELEMENT_NAME.getLocalName().equals(node.getLocalName())) continue;
            return (StyleTableColumnPropertiesElement)node;
        }
        return null;
    }

    public static Float getDimensionAsPoint(String s) {
        int index = s.indexOf(CM_UNIT);
        if (index != -1) {
            s = s.substring(0, index);
            return Float.valueOf(ODFUtils.millimetersToPoints(Float.valueOf(s).floatValue() * 10.0f));
        }
        index = s.indexOf(MM_UNIT);
        if (index != -1) {
            s = s.substring(0, index);
            return Float.valueOf(ODFUtils.millimetersToPoints(Float.valueOf(s).floatValue()));
        }
        index = s.indexOf(POINT_UNIT);
        if (index != -1) {
            s = s.substring(0, index);
            return Float.valueOf(s);
        }
        index = s.indexOf(INCH_UNIT);
        if (index != -1) {
            s = s.substring(0, index);
            return Float.valueOf(ODFUtils.inchesToPoints(Float.valueOf(s).floatValue()));
        }
        index = s.indexOf(PERCENT_UNIT);
        if (index != -1) {
            s = s.substring(0, index);
            return Float.valueOf(Float.valueOf(s).floatValue() / 100.0f);
        }
        return Float.valueOf(s);
    }

    public static Integer getRelativeSize(String s) {
        int index = s.indexOf(REL_SIZE_UNIT);
        if (index != -1) {
            s = s.substring(0, index);
            return Integer.valueOf(s);
        }
        return Integer.valueOf(s);
    }

    public static boolean hasPercentUnit(String s) {
        return s.indexOf(PERCENT_UNIT) != -1;
    }

    public static final float millimetersToPoints(float value) {
        return ODFUtils.inchesToPoints(ODFUtils.millimetersToInches(value));
    }

    public static final float inchesToPoints(float value) {
        return value * 72.0f;
    }

    public static final float millimetersToInches(float value) {
        return value / 25.4f;
    }

    public static String getDimensionAsPixel(String s) {
        if (s != null && s.endsWith(REL_SIZE_UNIT)) {
            return s;
        }
        return ODFUtils.getDimensionAsPoint(s).floatValue() / 0.75f + "px";
    }

    public static String stripTrailingDigits(String fontName) {
        while (fontName.length() > 0 && Character.isDigit(fontName.charAt(fontName.length() - 1))) {
            fontName = fontName.substring(0, fontName.length() - 1);
        }
        return fontName;
    }
}

