/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.poi.xwpf.converter.core.AbstractXWPFConverter;
import org.apache.poi.xwpf.converter.core.IXWPFConverter;
import org.apache.poi.xwpf.converter.core.XWPFConverterException;
import org.apache.poi.xwpf.converter.pdf.PdfOptions;
import org.apache.poi.xwpf.converter.pdf.internal.PdfMapper;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfConverter
extends AbstractXWPFConverter<PdfOptions> {
    private static final IXWPFConverter<PdfOptions> INSTANCE = new PdfConverter();

    public static IXWPFConverter<PdfOptions> getInstance() {
        return INSTANCE;
    }

    @Override
    protected void doConvert(XWPFDocument document, OutputStream out, Writer writer, PdfOptions options) throws XWPFConverterException, IOException {
        try {
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            PdfMapper mapper = new PdfMapper(document, tempOut, options, null);
            mapper.start();
            if (mapper.useTotalPageField()) {
                Integer actualPageCount = mapper.getPageCount();
                mapper = new PdfMapper(document, out, options, actualPageCount);
                mapper.start();
            } else {
                out.write(tempOut.toByteArray());
            }
        }
        catch (Exception e) {
            throw new XWPFConverterException(e);
        }
    }
}

