/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter.sax;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FieldsMetadataContentHandler
extends DefaultHandler {
    private FieldsMetadata fieldsMetadata;
    private FieldMetadata currentField;
    private StringBuilder description;

    public void startDocument() throws SAXException {
        this.fieldsMetadata = new FieldsMetadata();
    }

    public FieldsMetadata getFieldsMetadata() {
        return this.fieldsMetadata;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("fields".equals(localName)) {
            String templateEngineKind = attributes.getValue("templateEngineKind");
            this.fieldsMetadata.setTemplateEngineKind(templateEngineKind);
        } else if ("field".equals(localName)) {
            String fieldName = attributes.getValue("name");
            boolean listType = StringUtils.asBoolean(attributes.getValue("list"), false);
            String imageName = attributes.getValue("imageName");
            String syntaxKind = attributes.getValue("syntaxKind");
            boolean syntaxKindWithDirective = StringUtils.asBoolean(attributes.getValue("hasDirective"), false);
            this.currentField = this.fieldsMetadata.addField(fieldName, listType, imageName, syntaxKind, syntaxKindWithDirective);
        } else if ("description".equals(localName)) {
            this.description = new StringBuilder();
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("field".equals(localName)) {
            this.currentField = null;
        } else if ("description".equals(localName)) {
            if (this.currentField != null) {
                this.currentField.setDescription(this.description.toString());
            } else {
                this.fieldsMetadata.setDescription(this.description.toString());
            }
            this.description = null;
        }
        super.endElement(uri, localName, qName);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.description != null) {
            this.description.append(ch, start, length);
        }
        super.characters(ch, start, length);
    }
}

