/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.registry;

import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.discovery.ITemplateEngineInitializerDiscovery;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.discovery.ITemplateEngineDiscovery;
import fr.opensagres.xdocreport.template.registry.TemplateEngineRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngineInitializerRegistry
extends AbstractRegistry<ITemplateEngineInitializerDiscovery> {
    private static final TemplateEngineInitializerRegistry INSTANCE = new TemplateEngineInitializerRegistry();
    private Map<String, ITemplateEngine> templateEnginesCache = new HashMap<String, ITemplateEngine>();
    private Map<String, ITemplateEngineInitializerDiscovery> templateEnginesInitializerDiscoveryCache = new HashMap<String, ITemplateEngineInitializerDiscovery>();

    public TemplateEngineInitializerRegistry() {
        super(ITemplateEngineInitializerDiscovery.class);
    }

    @Override
    protected boolean registerInstance(ITemplateEngineInitializerDiscovery instance) {
        ITemplateEngineInitializerDiscovery discovery = instance;
        this.templateEnginesInitializerDiscoveryCache.put(discovery.getId(), discovery);
        return true;
    }

    public static TemplateEngineInitializerRegistry getRegistry() {
        return INSTANCE;
    }

    @Override
    protected void doDispose() {
        this.templateEnginesCache.clear();
        this.templateEnginesInitializerDiscoveryCache.clear();
    }

    public ITemplateEngine getTemplateEngine(TemplateEngineKind templateEngineKind, DocumentKind documentKind) {
        return this.getTemplateEngine(templateEngineKind.name(), documentKind != null ? documentKind.name() : null);
    }

    public ITemplateEngine getTemplateEngine(String templateEngineKind, String documentKind) {
        this.initializeIfNeeded();
        String key = this.getKey(templateEngineKind, documentKind);
        return this.templateEnginesCache.get(key);
    }

    public boolean exists(TemplateEngineKind templateEngineKind, DocumentKind documentKind) {
        return this.exists(templateEngineKind.name(), documentKind != null ? documentKind.name() : null);
    }

    public boolean exists(String templateEngineKind, String documentKind) {
        this.initializeIfNeeded();
        String key = this.getKey(templateEngineKind, documentKind);
        return this.templateEnginesCache.containsKey(key);
    }

    private String getKey(String templateEngineKind, String documentKind) {
        StringBuilder key = new StringBuilder(templateEngineKind);
        if (StringUtils.isNotEmpty(documentKind)) {
            key.append('_');
            key.append(documentKind);
        }
        return key.toString();
    }

    public ITemplateEngine getTemplateEngine(String templateEngineId) {
        this.initializeIfNeeded();
        String templateEngineKind = templateEngineId;
        String documentKind = null;
        int index = templateEngineId.lastIndexOf(95);
        if (index != -1) {
            templateEngineKind = templateEngineId.substring(0, index);
            documentKind = templateEngineId.substring(index + 1, templateEngineId.length());
        }
        return this.getTemplateEngine(templateEngineKind, documentKind);
    }

    public void register(ITemplateEngine templateEngine, DocumentKind documentKind) {
        this.register(templateEngine, documentKind.name());
    }

    private void register(ITemplateEngine templateEngine, String documentKind) {
        Collection<String> templateEngineKinds;
        String templateEngineKind = templateEngine.getKind();
        String key = this.getKey(templateEngineKind, documentKind);
        this.templateEnginesCache.put(key, templateEngine);
        ITemplateEngine defaultTemplateEngine = TemplateEngineRegistry.getRegistry().getDefaultTemplateEngine();
        if (defaultTemplateEngine == null) {
            defaultTemplateEngine = templateEngine;
        }
        if (!(templateEngineKinds = TemplateEngineRegistry.getRegistry().getTemplateEngineKinds()).contains(templateEngineKind)) {
            templateEngineKinds.add(templateEngineKind);
        }
    }

    @Override
    protected void onEndInitialization() {
        ArrayList<ITemplateEngineInitializerDiscovery> discoveriesForWholeTemplateEngine = new ArrayList<ITemplateEngineInitializerDiscovery>();
        Collection<ITemplateEngineInitializerDiscovery> discoveries = this.templateEnginesInitializerDiscoveryCache.values();
        String documentKind = null;
        for (ITemplateEngineInitializerDiscovery discovery : discoveries) {
            documentKind = discovery.getDocumentKind();
            if (StringUtils.isEmpty(documentKind)) {
                discoveriesForWholeTemplateEngine.add(discovery);
                continue;
            }
            Collection<String> kinds = TemplateEngineRegistry.getRegistry().getTemplateEngineKinds();
            Map<String, ITemplateEngineDiscovery> templateEnginesDiscoveryCache = TemplateEngineRegistry.getRegistry().getTemplateEnginesDiscoveryCache();
            for (String templateEngineKind : kinds) {
                ITemplateEngineDiscovery templateEngineDiscovery = templateEnginesDiscoveryCache.get(templateEngineKind);
                ITemplateEngine templateEngine = this.templateEnginesCache.get(templateEngineKind);
                if (templateEngine == null) {
                    templateEngine = templateEngineDiscovery.createTemplateEngine();
                    this.register(templateEngine, documentKind);
                }
                discovery.initialize(templateEngine);
            }
        }
        for (ITemplateEngineInitializerDiscovery discovery : discoveriesForWholeTemplateEngine) {
            Collection<ITemplateEngine> templateEngines = this.templateEnginesCache.values();
            for (ITemplateEngine templateEngine : templateEngines) {
                discovery.initialize(templateEngine);
            }
        }
    }
}

