/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.document.images.AbstractImageProvider;
import fr.opensagres.xdocreport.document.images.IImageInfo;
import fr.opensagres.xdocreport.document.images.SimpleImageInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractInputStreamImageProvider
extends AbstractImageProvider {
    private static final Logger LOGGER = LogUtils.getLogger(AbstractInputStreamImageProvider.class);

    public AbstractInputStreamImageProvider(boolean keepTemplateImageSize) {
        super(keepTemplateImageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = this.getInputStream();
            IOUtils.copy(inputStream, outputStream);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    protected abstract InputStream getInputStream() throws IOException;

    protected boolean doIsValid() {
        try {
            return this.getInputStream() != null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Error while getting the input stream of the image", e);
            }
            return false;
        }
    }

    protected IImageInfo loadImageInfo() throws IOException {
        SimpleImageInfo imageInfo = new SimpleImageInfo();
        imageInfo.setInput(this.getInputStream());
        if (!imageInfo.check()) {
            throw new IOException("Unable to read image info.");
        }
        return imageInfo;
    }
}

