/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.dump;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dump.DumpHelper;
import fr.opensagres.xdocreport.document.dump.DumperOptions;
import fr.opensagres.xdocreport.document.dump.IDumper;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.registry.TemplateEngineRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractDumper
implements IDumper {
    public void dump(IXDocReport report, IContext context, DumperOptions option, OutputStream out) throws IOException, XDocReportException {
        this.dump(report, null, context, option, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(IXDocReport report, InputStream documentIn, IContext context, DumperOptions option, OutputStream out) throws IOException, XDocReportException {
        try {
            ITemplateEngine templateEngine = TemplateEngineRegistry.getRegistry().getTemplateEngine(report.getTemplateEngine().getKind());
            if (documentIn == null) {
                documentIn = DumpHelper.getDocument(report);
            }
            this.doDump(report, documentIn, context, option, templateEngine, out);
        }
        finally {
            if (documentIn != null) {
                IOUtils.closeQuietly(documentIn);
            }
            if (out != null) {
                IOUtils.closeQuietly(out);
            }
        }
    }

    protected abstract void doDump(IXDocReport var1, InputStream var2, IContext var3, DumperOptions var4, ITemplateEngine var5, OutputStream var6) throws IOException, XDocReportException;
}

