/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocXBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.RBufferedRegion;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkInfo;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.InitialHyperlinkMap;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedAttribute;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import fr.opensagres.xdocreport.document.preprocessor.sax.ProcessRowResult;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class HyperlinkBufferedRegion
extends BufferedElement {
    private final DocXBufferedDocumentContentHandler handler;
    private List<RBufferedRegion> rBufferedRegions = new ArrayList<RBufferedRegion>();
    private BufferedAttribute idAttribute;

    public HyperlinkBufferedRegion(DocXBufferedDocumentContentHandler handler, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.handler = handler;
    }

    public void addRegion(ISavable region) {
        if (region instanceof RBufferedRegion) {
            this.rBufferedRegions.add((RBufferedRegion)region);
        } else {
            super.addRegion(region);
        }
    }

    public void process() {
        IDocumentFormatter formatter = this.handler.getFormatter();
        if (formatter == null) {
            return;
        }
        String content = this.getAllTContent();
        ProcessRowResult result = this.handler.getProcessRowResult(content, false);
        String newContent = result.getContent();
        if (newContent != null) {
            String relationId;
            HyperlinkInfo hyperlink;
            InitialHyperlinkMap hyperlinksMap;
            if (result.getFieldName() != null) {
                this.modifyTContents(newContent);
            } else if (formatter.containsInterpolation(newContent)) {
                this.modifyTContents(newContent);
            }
            if (this.handler.hasSharedContext() && (hyperlinksMap = HyperlinkUtils.getInitialHyperlinkMap(this.handler.getEntryName(), this.handler.getSharedContext())) != null && (hyperlink = (HyperlinkInfo)hyperlinksMap.get(relationId = this.idAttribute.getValue())) != null) {
                String target = StringUtils.decode(hyperlink.getTarget());
                String targetMode = hyperlink.getTargetMode();
                ProcessRowResult hyperlinkResult = this.handler.getProcessRowResult(target, false);
                boolean dynamicHyperlink = false;
                if (hyperlinkResult != null && hyperlinkResult.getFieldName() != null) {
                    target = hyperlinkResult.getContent();
                    dynamicHyperlink = true;
                } else if (formatter.containsInterpolation(target)) {
                    dynamicHyperlink = true;
                }
                if (dynamicHyperlink) {
                    String id = formatter.getFunctionDirective(HyperlinkUtils.getHyperlinkRegistryKey(this.handler.getEntryName()), "registerHyperlink", "\"" + target + "\"", "\"" + targetMode + "\"");
                    this.idAttribute.setValue(id);
                    hyperlinksMap.remove(hyperlink.getId());
                    if (StringUtils.isNotEmpty(this.handler.getStartNoParse())) {
                        this.setContentBeforeStartTagElement(this.handler.getEndNoParse());
                        this.setContentAfterEndTagElement(this.handler.getStartNoParse());
                    }
                }
            }
        }
    }

    private String getAllTContent() {
        StringBuilder t = new StringBuilder();
        for (RBufferedRegion r : this.rBufferedRegions) {
            String c = r.getTContent();
            if (c == null) continue;
            t.append(c);
        }
        return t.toString();
    }

    private void modifyTContents(String newContent) {
        for (int i = 0; i < this.rBufferedRegions.size(); ++i) {
            if (i == this.rBufferedRegions.size() - 1) {
                this.rBufferedRegions.get(i).setTContent(0, newContent);
                continue;
            }
            this.rBufferedRegions.get(i).setTContent(0, "");
        }
    }

    public void setId(String name, String value) {
        if (this.idAttribute == null) {
            this.idAttribute = super.setAttribute(name, value);
        }
        this.idAttribute.setValue(value);
    }
}

