/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax;

import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocxBufferedDocument;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.RBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class PBufferedRegion
extends BufferedElement {
    private static final String BEGIN = "begin";
    private static final String SEPARATE = "separate";
    private static final String END = "end";
    private List<RBufferedRegion> rBufferedRegions = new ArrayList<RBufferedRegion>();
    private final DocxBufferedDocument document;
    private boolean containsField;

    public PBufferedRegion(DocxBufferedDocument document, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.document = document;
        this.containsField = false;
    }

    public void addRegion(ISavable region) {
        if (region instanceof RBufferedRegion) {
            this.rBufferedRegions.add((RBufferedRegion)region);
        } else {
            super.addRegion(region);
        }
    }

    public void process() {
        ArrayList<BufferedElement> toRemove = new ArrayList<BufferedElement>();
        boolean remove = false;
        boolean fieldNameSetted = false;
        String fieldName = null;
        boolean rReseted = false;
        for (int i = 0; i < this.rBufferedRegions.size(); ++i) {
            RBufferedRegion rBufferedRegion = this.rBufferedRegions.get(i);
            if (BEGIN.equals(rBufferedRegion.getFldCharType())) {
                RBufferedRegion r;
                int nextIndexAfterBegin = i + 1;
                RBufferedRegion nextR = this.rBufferedRegions.get(nextIndexAfterBegin);
                rReseted = nextR.isReseted();
                if (rReseted) {
                    toRemove.add(rBufferedRegion);
                    toRemove.add(nextR);
                    remove = true;
                    continue;
                }
                ArrayList<RBufferedRegion> rMerged = new ArrayList<RBufferedRegion>();
                StringBuilder mergedInstrText = new StringBuilder();
                for (int j = nextIndexAfterBegin; j < this.rBufferedRegions.size() && (r = this.rBufferedRegions.get(j)).hasInstrText(); ++j) {
                    rMerged.add(r);
                    mergedInstrText.append(r.getOriginalInstrText());
                }
                if (rMerged.size() <= 0) continue;
                RBufferedRegion firstR = (RBufferedRegion)rMerged.get(0);
                firstR.setInstrText(mergedInstrText.toString(), firstR.getFieldAsTextStyling());
                fieldName = firstR.getFieldName();
                if (fieldName == null) continue;
                if (this.document.processScriptBeforeAfter(firstR)) {
                    rReseted = true;
                }
                for (RBufferedRegion r2 : rMerged) {
                    toRemove.add(r2);
                    ++i;
                }
                toRemove.add(rBufferedRegion);
                remove = true;
                continue;
            }
            if (SEPARATE.equals(rBufferedRegion.getFldCharType()) && remove) {
                toRemove.add(rBufferedRegion);
                continue;
            }
            if (END.equals(rBufferedRegion.getFldCharType()) && remove) {
                toRemove.add(rBufferedRegion);
                remove = false;
                fieldName = null;
                fieldNameSetted = false;
                rReseted = false;
                continue;
            }
            if (fieldName == null && !rReseted) continue;
            if (!fieldNameSetted && !rReseted) {
                rBufferedRegion.setTContent(0, fieldName);
                fieldNameSetted = true;
                this.containsField = true;
                continue;
            }
            if (rBufferedRegion.isContainsNote()) continue;
            toRemove.add(rBufferedRegion);
        }
        this.rBufferedRegions.removeAll(toRemove);
        super.removeAll(toRemove);
    }

    public boolean isContainsField() {
        return false;
    }
}

