/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.docx.DocxConstants;
import fr.opensagres.xdocreport.document.docx.images.DocxImageRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.DefaultStyle;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocxPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.contenttypes.DocxContentTypesPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.HyperlinkUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.hyperlinks.InitialHyperlinkMap;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.InitialNoteInfoMap;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.NoteRegistry;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.NoteUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.endnotes.DocxEndnotesPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.footnotes.DocxFootnotesPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.numbering.DocxNumberingPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.rels.DocxDocumentXMLRelsPreprocessor;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.styles.DocxStylesPreprocessor;
import fr.opensagres.xdocreport.document.docx.template.DocxContextHelper;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.template.IContext;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocxReport
extends AbstractXDocReport {
    private static final long serialVersionUID = -2323716817951928168L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"word/document.xml", "word/styles.xml", "word/header*.xml", "word/footer*.xml", "word/_rels/*.xml.rels", "word/footnotes.xml", "word/endnotes.xml", "word/numbering.xml"};
    private Set<String> allEntryNamesHyperlinks;
    private Set<String> modifiedEntryNamesHyperlinks;
    private DefaultStyle defaultStyle = new DefaultStyle();
    private InitialNoteInfoMap initialFootNoteInfoMap;
    private InitialNoteInfoMap initialEndNoteInfoMap;

    @Override
    public String getKind() {
        return DocumentKind.DOCX.name();
    }

    @Override
    protected void registerPreprocessors() {
        super.addPreprocessor("word/styles.xml", DocxStylesPreprocessor.INSTANCE);
        super.addPreprocessor("word/footnotes.xml", DocxFootnotesPreprocessor.INSTANCE);
        super.addPreprocessor("word/endnotes.xml", DocxEndnotesPreprocessor.INSTANCE);
        super.addPreprocessor("word/document.xml", DocxPreprocessor.INSTANCE);
        super.addPreprocessor("word/header*.xml", DocxPreprocessor.INSTANCE);
        super.addPreprocessor("word/footer*.xml", DocxPreprocessor.INSTANCE);
        super.addPreprocessor("[Content_Types].xml", DocxContentTypesPreprocessor.INSTANCE);
        super.addPreprocessor("word/_rels/*.xml.rels", DocxDocumentXMLRelsPreprocessor.INSTANCE);
        super.addPreprocessor("word/numbering.xml", DocxNumberingPreprocessor.INSTANCE);
    }

    @Override
    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    @Override
    public MimeMapping getMimeMapping() {
        return DocxConstants.MIME_MAPPING;
    }

    @Override
    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new DocxImageRegistry(readerProvider, writerProvider, outputStreamProvider, this.getFieldsMetadata());
    }

    @Override
    protected void onBeforePreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onBeforePreprocessing(sharedContext, preprocessedArchive);
        Set<String> xmlRelsEntryNames = preprocessedArchive.getEntryNames("word/_rels/*.xml.rels");
        this.allEntryNamesHyperlinks = new HashSet<String>();
        String entryName = null;
        for (String relsEntryName : xmlRelsEntryNames) {
            try {
                HyperlinkContentHandler contentHandler = new HyperlinkContentHandler();
                SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
                saxParser.parse(preprocessedArchive.getEntryInputStream(relsEntryName), (DefaultHandler)contentHandler);
                if (contentHandler.getHyperlinks() == null) continue;
                entryName = HyperlinkUtils.getEntryNameWithoutRels(relsEntryName);
                HyperlinkUtils.putInitialHyperlinkMap(entryName, sharedContext, contentHandler.getHyperlinks());
                this.allEntryNamesHyperlinks.add(entryName);
            }
            catch (SAXException e) {
                throw new XDocReportException(e);
            }
            catch (IOException e) {
                throw new XDocReportException(e);
            }
            catch (ParserConfigurationException e) {
                throw new XDocReportException(e);
            }
        }
        sharedContext.put("___DefaultStyle", this.defaultStyle);
    }

    @Override
    protected void onAfterPreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onAfterPreprocessing(sharedContext, preprocessedArchive);
        if (sharedContext != null) {
            InitialHyperlinkMap hyperlinkMap = null;
            this.modifiedEntryNamesHyperlinks = new HashSet<String>();
            for (String entryName : this.allEntryNamesHyperlinks) {
                hyperlinkMap = HyperlinkUtils.getInitialHyperlinkMap(entryName, sharedContext);
                if (hyperlinkMap == null || !hyperlinkMap.isModified()) continue;
                this.modifiedEntryNamesHyperlinks.add(entryName);
            }
            this.initialFootNoteInfoMap = NoteUtils.getInitialFootNoteInfoMap(sharedContext);
            this.initialEndNoteInfoMap = NoteUtils.getInitialEndNoteInfoMap(sharedContext);
        }
    }

    @Override
    protected void onBeforeProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onBeforeProcessTemplateEngine(context, outputArchive);
        for (String entryName : this.modifiedEntryNamesHyperlinks) {
            DocxContextHelper.putHyperlinkRegistry(context, entryName, new HyperlinkRegistry());
        }
        DocxContextHelper.putDefaultStyle(context, this.defaultStyle);
        DocxContextHelper.getStylesGenerator(context);
        if (this.initialFootNoteInfoMap != null) {
            DocxContextHelper.putFootnoteRegistry(context, new NoteRegistry());
        }
        if (this.initialEndNoteInfoMap != null) {
            DocxContextHelper.putEndnoteRegistry(context, new NoteRegistry());
        }
    }

    @Override
    protected void onAfterProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onAfterProcessTemplateEngine(context, outputArchive);
    }
}

