/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document;

import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.ProcessState;
import fr.opensagres.xdocreport.document.registry.TemplateEngineInitializerRegistry;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.registry.TemplateEngineRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Generator<In, Out> {
    public static final String REMOVE_DISPATCH = "remove";
    public static final String DOWNLOAD_DISPATCH = "download";
    public static final String VIEW_DISPATCH = "view";
    public static final String REPORT_ID_HTTP_PARAM = "reportId";
    public static final String TEMPLATE_ENGINE_KIND_HTTP_PARAM = "templateEngineKind";
    public static final String TEMPLATE_ENGINE_ID_HTTP_PARAM = "templateEngineId";
    public static final String ENTRY_NAME_HTTP_PARAM = "entryName";
    public static final String PROCESS_STATE_HTTP_PARAM = "processState";
    public static final String DISPATCH_HTTP_PARAM = "dispatch";
    public static final String CONVERTER_ID_HTTP_PARAM = "converter";
    private boolean cacheOriginalDocument;

    public void processRequest(In request, Out response) throws Exception {
        String dispatch = this.getDispatchParameter(request);
        if (REMOVE_DISPATCH.equals(dispatch)) {
            this.doRemoveReport(request, response);
        } else {
            String entryName = this.getEntryName(request);
            ProcessState processState = this.getProcessState(request);
            if (processState == null) {
                processState = StringUtils.isNotEmpty(entryName) ? ProcessState.PREPROCESSED : ProcessState.GENERATED;
            }
            switch (processState) {
                case ORIGINAL: 
                case PREPROCESSED: {
                    this.doDocumentArchive(processState, entryName, request, response);
                    break;
                }
                case GENERATED: {
                    this.doGenerateReport(entryName, request, response);
                }
            }
        }
    }

    protected void doRemoveReport(In request, Out response) throws IOException {
        String reportId = this.getReportId(request);
        if (StringUtils.isNotEmpty(reportId)) {
            this.getRegistry(request).unregisterReport(reportId);
        }
        this.doRedirectAfterRemoveReport(request, response);
    }

    protected void doRedirectAfterRemoveReport(In request, Out response) throws IOException {
    }

    protected void doDocumentArchive(ProcessState state, String entryName, In request, Out response) throws Exception {
        if (StringUtils.isEmpty(entryName)) {
            this.doSaveReport(state, request, response);
        } else {
            this.doSaveEntry(state, entryName, request, response);
        }
    }

    protected void doSaveReport(ProcessState processState, In request, Out response) throws Exception {
        IXDocReport report = this.getReport(request);
        if (report != null) {
            this.prepareHTTPResponse(report.getId(), report.getMimeMapping(), request, response);
            report.save(processState, this.getOutputStream(response));
        }
    }

    protected void doSaveEntry(ProcessState processState, String entryName, In request, Out response) throws IOException, Exception {
        IXDocReport report = this.getReport(request);
        if (report != null) {
            this.prepareHTTPResponse(report.getId(), entryName, request, response);
            report.saveEntry(entryName, processState, this.getOutputStream(response));
        }
    }

    protected boolean doGenerateReport(String entryName, In request, Out response) throws Exception, IOException {
        try {
            IXDocReport report = this.getReport(request);
            if (report == null) {
                throw new XDocReportException("Cannot get XDoc Report for the HTTP request");
            }
            Options options = this.getOptionsConverter(report, request);
            if (options == null) {
                this.doProcessReport(report, entryName, request, response);
            } else {
                this.doProcessReportWithConverter(report, options, request, response);
            }
            return true;
        }
        catch (Exception e) {
            this.error(request, response, e);
            return false;
        }
    }

    private void doProcessReport(IXDocReport report, String entryName, In request, Out response) throws XDocReportException, IOException {
        IContext context = report.createContext();
        this.populateContext(context, report.getId(), request);
        if (StringUtils.isEmpty(entryName)) {
            this.prepareHTTPResponse(report.getId(), report.getMimeMapping(), request, response);
            report.process(context, this.getOutputStream(response));
        } else {
            this.prepareHTTPResponse(report.getId(), entryName, request, response);
            report.process(context, entryName, this.getOutputStream(response));
        }
    }

    private void doProcessReportWithConverter(IXDocReport report, Options options, In request, Out response) throws XDocReportException, IOException, XDocConverterException {
        IContext context = null;
        ITemplateEngine templateEngine = report.getTemplateEngine();
        if (templateEngine != null) {
            context = report.createContext();
            this.populateContext(context, report.getId(), request);
        }
        IConverter converter = report.getConverter(options);
        this.prepareHTTPResponse(report.getId(), converter.getMimeMapping(), request, response);
        report.convert(context, options, this.getOutputStream(response));
    }

    protected IXDocReport getReport(In request) throws IOException, XDocReportException {
        IXDocReport report;
        XDocReportRegistry registry = this.getRegistry(request);
        String reportId = this.getReportId(request);
        if (StringUtils.isNotEmpty(reportId) && (report = registry.getReport(reportId)) != null) {
            return report;
        }
        return this.loadReport(reportId, registry, request);
    }

    protected IXDocReport loadReport(String reportId, XDocReportRegistry registry, In request) throws IOException, XDocReportException {
        InputStream sourceStream = this.getSourceStream(reportId, request);
        if (sourceStream == null) {
            throw new XDocReportException("Input stream is null with reportId=" + reportId);
        }
        IXDocReport report = null;
        ITemplateEngine templateEngine = null;
        String templateEngineKind = this.getTemplateEngineKind(reportId, request);
        if (StringUtils.isNotEmpty(templateEngineKind)) {
            report = registry.loadReport(sourceStream, reportId, templateEngineKind);
        } else {
            templateEngine = this.getTemplateEngine(reportId, request);
            report = registry.loadReport(sourceStream, reportId, templateEngine);
        }
        FieldsMetadata fieldsMetadata = this.getFieldsMetadata(reportId, request);
        report.setFieldsMetadata(fieldsMetadata);
        report.setCacheOriginalDocument(this.isCacheOriginalDocument(reportId, request));
        return report;
    }

    protected boolean isCacheOriginalDocument(String reportId, In request) {
        return this.cacheOriginalDocument;
    }

    protected FieldsMetadata getFieldsMetadata(String reportId, In request) {
        return null;
    }

    protected abstract void error(In var1, Out var2, Exception var3);

    protected String getConverterId(IXDocReport report, In request) {
        return this.getParameter(request, CONVERTER_ID_HTTP_PARAM);
    }

    protected Options getOptionsConverter(IXDocReport report, In request) {
        String converterId = this.getConverterId(report, request);
        if (StringUtils.isEmpty(converterId)) {
            return null;
        }
        Options options = null;
        int index = converterId.lastIndexOf(95);
        if (index != -1) {
            String to = converterId.substring(0, index);
            String via = converterId.substring(index + 1, converterId.length());
            options = Options.getTo(to).via(via);
        } else {
            options = Options.getTo(converterId);
        }
        this.prepareOptions(options, report, converterId, request);
        return options;
    }

    protected void prepareOptions(Options options, IXDocReport report, String converterId, In request) {
    }

    protected boolean isGenerateContentDisposition(String reportId, MimeMapping mimeMapping, In request) {
        return !VIEW_DISPATCH.equals(this.getDispatchParameter(request));
    }

    protected String getDispatchParameter(In request) {
        return this.getParameter(request, DISPATCH_HTTP_PARAM);
    }

    protected String getReportId(In request) {
        return this.getParameter(request, REPORT_ID_HTTP_PARAM);
    }

    protected ProcessState getProcessState(In request) {
        String state = this.getParameter(request, PROCESS_STATE_HTTP_PARAM);
        if (ProcessState.ORIGINAL.name().equalsIgnoreCase(state)) {
            return ProcessState.ORIGINAL;
        }
        if (ProcessState.PREPROCESSED.name().equalsIgnoreCase(state)) {
            return ProcessState.PREPROCESSED;
        }
        if (ProcessState.GENERATED.name().equalsIgnoreCase(state)) {
            return ProcessState.GENERATED;
        }
        return null;
    }

    protected String getEntryName(In request) {
        return this.getParameter(request, ENTRY_NAME_HTTP_PARAM);
    }

    protected String getTemplateEngineKind(String reportId, In request) {
        return this.getTemplateEngineKind(request);
    }

    protected String getTemplateEngineKind(In request) {
        return this.getParameter(request, TEMPLATE_ENGINE_KIND_HTTP_PARAM);
    }

    protected String getTemplateEngineId(In request) {
        return this.getParameter(request, TEMPLATE_ENGINE_ID_HTTP_PARAM);
    }

    protected ITemplateEngine getTemplateEngine(String reportId, In request) {
        return this.getTemplateEngine(request);
    }

    protected ITemplateEngine getTemplateEngine(IXDocReport report, In request) {
        String documentKind = report.getKind();
        String templateEngineKind = this.getTemplateEngineKind(request);
        ITemplateEngine templateEngine = TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineKind, documentKind);
        if (templateEngine == null) {
            templateEngine = TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineKind, null);
        }
        return templateEngine;
    }

    protected ITemplateEngine getTemplateEngine(In request) {
        String templateEngineId = this.getTemplateEngineId(request);
        if (StringUtils.isNotEmpty(templateEngineId)) {
            return TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineId);
        }
        return TemplateEngineRegistry.getRegistry().getDefaultTemplateEngine();
    }

    protected XDocReportRegistry getRegistry(In request) {
        return XDocReportRegistry.getRegistry();
    }

    protected abstract InputStream getSourceStream(String var1, In var2) throws IOException, XDocReportException;

    protected abstract void populateContext(IContext var1, String var2, In var3) throws IOException, XDocReportException;

    protected abstract OutputStream getOutputStream(Out var1) throws IOException;

    protected abstract String getParameter(In var1, String var2);

    protected abstract void prepareHTTPResponse(String var1, MimeMapping var2, In var3, Out var4);

    protected abstract void prepareHTTPResponse(String var1, String var2, In var3, Out var4);
}

