/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.utils;

import java.awt.Color;
import org.apache.poi.xwpf.converter.core.PageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSectionMark;

public class XWPFUtils {
    public static boolean isContinuousSection(CTSectPr sectPr) {
        if (sectPr == null) {
            return false;
        }
        CTSectType sectType = sectPr.getType();
        if (sectType == null) {
            return false;
        }
        return sectType.getVal() == STSectionMark.CONTINUOUS;
    }

    public static PageOrientation getPageOrientation(STPageOrientation.Enum orientation) {
        if (orientation != null) {
            if (STPageOrientation.LANDSCAPE.equals(orientation)) {
                return PageOrientation.Landscape;
            }
            return PageOrientation.Portrait;
        }
        return null;
    }

    public static String toHexString(Color color) {
        String hexaWith8Digits = Integer.toHexString(color.getRGB());
        return "#" + hexaWith8Digits.substring(2, hexaWith8Digits.length());
    }

    public static Color darken(int r, int g, int b, double percent) throws IllegalArgumentException {
        return new Color(Math.max((int)((double)r * (1.0 - percent)), 0), Math.max((int)((double)g * (1.0 - percent)), 0), Math.max((int)((double)b * (1.0 - percent)), 0));
    }

    public static Color lighten(int r, int g, int b, double percent) throws IllegalArgumentException {
        int r2 = r + (int)((double)(255 - r) * percent);
        int g2 = g + (int)((double)(255 - g) * percent);
        int b2 = b + (int)((double)(255 - b) * percent);
        return new Color(r2, g2, b2);
    }

    public static boolean isCTOnOff(CTOnOff onoff) {
        if (onoff == null) {
            return false;
        }
        if (!onoff.isSetVal()) {
            return true;
        }
        if (onoff.getVal() == STOnOff.ON) {
            return true;
        }
        return onoff.getVal() == STOnOff.TRUE;
    }
}

