/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.run;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.converter.core.styles.AbstractValueProvider;
import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.apache.poi.xwpf.converter.core.utils.StylesHelper;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblStylePr;

public abstract class AbstractRunValueProvider<Value>
extends AbstractValueProvider<Value, XWPFRun> {
    public CTRPr getRPr(XWPFRun run) {
        return run.getCTR().getRPr();
    }

    public CTRPr getRPr(CTStyle style) {
        return style.getRPr();
    }

    public CTRPr getRPr(CTDocDefaults docDefaults) {
        CTRPrDefault prDefault = docDefaults.getRPrDefault();
        if (prDefault == null) {
            return null;
        }
        return prDefault.getRPr();
    }

    public CTRPr getRPr(CTTblStylePr tblStylePr) {
        return tblStylePr.getRPr();
    }

    @Override
    public Value getValueFromElement(XWPFRun run) {
        return this.getValue(this.getRPr(run));
    }

    @Override
    protected Value getValueFromStyle(CTStyle style) {
        return this.getValue(this.getRPr(style));
    }

    @Override
    protected Value getValueFromTableStyle(CTTblStylePr tblStylePr) {
        return this.getValue(this.getRPr(tblStylePr));
    }

    @Override
    protected Value getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument stylesDocument) {
        return this.getValue(this.getRPr(docDefaults));
    }

    public abstract Value getValue(CTRPr var1);

    @Override
    protected String[] getStyleID(XWPFRun run) {
        CTString style;
        XWPFParagraph paragraph = run.getParagraph();
        List<String> styleIDs = StylesHelper.getStyleIDs(paragraph);
        CTRPr rPr = this.getRPr(run);
        if (rPr != null && (style = rPr.getRStyle()) != null) {
            if (styleIDs == null) {
                styleIDs = new ArrayList<String>();
            }
            styleIDs.add(0, style.getVal());
        }
        if (styleIDs != null) {
            return styleIDs.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        return null;
    }

    @Override
    protected CTStyle getDefaultStyle(XWPFRun element, XWPFStylesDocument styleManager) {
        return styleManager.getDefaultParagraphStyle();
    }

    @Override
    protected XWPFTableCell getParentTableCell(XWPFRun run) {
        return StylesHelper.getEmbeddedTableCell(run.getParagraph());
    }
}

