/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles;

import org.apache.poi.xwpf.converter.core.styles.IValueProvider;
import org.apache.poi.xwpf.converter.core.styles.TableCellInfo;
import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblStylePr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblStyleOverrideType;

public abstract class AbstractValueProvider<Value, XWPFElement>
implements IValueProvider<Value, XWPFElement> {
    @Override
    public Value getValue(XWPFElement element, XWPFStylesDocument stylesDocument) {
        Value value = this.internalGetValue(element, stylesDocument);
        return value;
    }

    public Value internalGetValue(XWPFElement element, XWPFStylesDocument stylesDocument) {
        Value value = this.getValueFromElement(element);
        if (value != null) {
            return value;
        }
        if (stylesDocument == null) {
            return null;
        }
        return this.getValueFromStyles(element, stylesDocument);
    }

    public Value getValueFromStyles(XWPFElement element, XWPFStylesDocument stylesDocument) {
        XWPFTable table;
        String tableStyleID;
        Object result;
        String key = this.getKey(element, stylesDocument, null, null);
        Object defaultValue = stylesDocument.getValue(key);
        if (defaultValue == null) {
            defaultValue = this.getDefaultValue(element, stylesDocument);
            if (defaultValue == null) {
                defaultValue = XWPFStylesDocument.EMPTY_VALUE;
            }
            this.updateValueCache(stylesDocument, key, defaultValue);
        }
        if ((result = this.getValueFromStyleIds(element, stylesDocument, defaultValue)) != null) {
            return this.getValueOrNull(result);
        }
        XWPFTableCell cell = this.getParentTableCell(element);
        if (cell != null && StringUtils.isNotEmpty(tableStyleID = (table = cell.getTableRow().getTable()).getStyleID())) {
            TableCellInfo cellInfo = stylesDocument.getTableCellInfo(cell);
            result = this.getValueFromTableStyleId(element, stylesDocument, tableStyleID, cellInfo);
            if (result != null) {
                return this.getValueOrNull(result);
            }
            result = this.getValueFromStyleId(element, stylesDocument, tableStyleID, defaultValue);
            if (result != null) {
                return this.getValueOrNull(result);
            }
        }
        this.updateValueCache(stylesDocument, key, defaultValue);
        return this.getValueOrNull(defaultValue);
    }

    private Object getValueFromTableStyleId(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID, TableCellInfo cellInfo) {
        Object result;
        if (StringUtils.isEmpty(tableStyleID)) {
            return null;
        }
        Object value = this.getValueFromTableStyleIdRow(element, stylesDocument, tableStyleID, cellInfo);
        if (value != null) {
            return value;
        }
        if (cellInfo.canApplyFirstCol()) {
            Object result2 = this.getValueFromTableStyleIdFirstCol(element, stylesDocument, tableStyleID);
            if (result2 != null) {
                return result2;
            }
        } else if (cellInfo.canApplyLastCol() && (result = this.getValueFromTableStyleIdLastCol(element, stylesDocument, tableStyleID)) != null) {
            return result;
        }
        return null;
    }

    private Object getValueFromTableStyleIdRow(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID, TableCellInfo cellInfo) {
        Object result;
        if (cellInfo.canApplyFirstRow()) {
            Object value = this.getValueFromTableStyleIdFirstRow(element, stylesDocument, tableStyleID);
            if (value != null) {
                return value;
            }
        } else if (cellInfo.canApplyLastRow() && (result = this.getValueFromTableStyleIdLastRow(element, stylesDocument, tableStyleID)) != null) {
            return result;
        }
        return null;
    }

    private Object getValueFromTableStyleIdFirstRow(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID) {
        return this.getValueFromTableStyleId(element, stylesDocument, tableStyleID, STTblStyleOverrideType.FIRST_ROW);
    }

    private Object getValueFromTableStyleIdLastRow(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID) {
        return this.getValueFromTableStyleId(element, stylesDocument, tableStyleID, STTblStyleOverrideType.LAST_ROW);
    }

    private Object getValueFromTableStyleIdFirstCol(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID) {
        return this.getValueFromTableStyleId(element, stylesDocument, tableStyleID, STTblStyleOverrideType.FIRST_COL);
    }

    private Object getValueFromTableStyleIdLastCol(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID) {
        return this.getValueFromTableStyleId(element, stylesDocument, tableStyleID, STTblStyleOverrideType.LAST_COL);
    }

    private Object getValueFromTableStyleId(XWPFElement element, XWPFStylesDocument stylesDocument, String tableStyleID, STTblStyleOverrideType.Enum type) {
        Object defaultValue = XWPFStylesDocument.EMPTY_VALUE;
        if (StringUtils.isEmpty(tableStyleID)) {
            return null;
        }
        String key = this.getKey(element, stylesDocument, tableStyleID, type);
        Object result = stylesDocument.getValue(key);
        if (result != null) {
            return this.getValueOrNull(result);
        }
        CTStyle style = stylesDocument.getStyle(tableStyleID);
        if (style == null) {
            stylesDocument.setValue(key, defaultValue);
            return null;
        }
        Object value = null;
        CTTblStylePr tblStylePr = stylesDocument.getTableStyle(tableStyleID, type);
        if (tblStylePr != null) {
            value = this.getValueFromTableStyle(tblStylePr);
            if (value != null) {
                stylesDocument.setValue(key, value);
                return value;
            }
            value = this.getValueFromTableStyleId(element, stylesDocument, this.getBasisStyleID(style), type);
        }
        value = value != null ? value : defaultValue;
        this.updateValueCache(stylesDocument, key, value);
        return this.getValueOrNull(value);
    }

    private Value getValueOrNull(Object result) {
        return (Value)(result.equals(XWPFStylesDocument.EMPTY_VALUE) ? null : result);
    }

    public Object getValueFromStyleIds(XWPFElement element, XWPFStylesDocument stylesDocument, Object defaultValue) {
        String[] styleIds = this.getStyleID(element);
        if (styleIds != null) {
            String styleId = null;
            for (int i = 0; i < styleIds.length; ++i) {
                styleId = styleIds[i];
                Object value = this.getValueFromStyleId(element, stylesDocument, styleId, defaultValue);
                if (value == null) continue;
                return this.getValueOrNull(value);
            }
        }
        return null;
    }

    public abstract Value getValueFromElement(XWPFElement var1);

    protected Value getDefaultValue(XWPFElement element, XWPFStylesDocument stylesDocument) {
        Value value = this.getValueFromDefaultStyle(element, stylesDocument);
        if (value != null) {
            return value;
        }
        value = this.getValueFromDocDefaultsStyle(element, stylesDocument);
        if (value != null) {
            return value;
        }
        return this.getStaticValue(element, stylesDocument);
    }

    protected Value getStaticValue(XWPFElement element, XWPFStylesDocument stylesDocument) {
        return null;
    }

    private Object getValueFromStyleId(XWPFElement element, XWPFStylesDocument stylesDocument, String styleId, Object defaultValue) {
        if (StringUtils.isEmpty(styleId)) {
            return null;
        }
        String key = this.getKey(element, stylesDocument, styleId, null);
        Object result = stylesDocument.getValue(key);
        if (result != null) {
            return result;
        }
        CTStyle style = stylesDocument.getStyle(styleId);
        if (style == null) {
            stylesDocument.setValue(key, defaultValue);
            return null;
        }
        Object value = this.getValueFromStyle(style);
        if (value != null) {
            stylesDocument.setValue(key, value);
            return value;
        }
        value = this.getValueFromStyleId(element, stylesDocument, this.getBasisStyleID(style), defaultValue);
        value = value != null ? value : defaultValue;
        this.updateValueCache(stylesDocument, key, value);
        return value;
    }

    private void updateValueCache(XWPFStylesDocument stylesDocument, String key, Object value) {
        if (value != null) {
            stylesDocument.setValue(key, value);
        } else {
            stylesDocument.setValue(key, XWPFStylesDocument.EMPTY_VALUE);
        }
    }

    protected String getKey(XWPFElement element, XWPFStylesDocument stylesDocument, String styleId, STTblStyleOverrideType.Enum type) {
        return this.getKeyBuffer(element, stylesDocument, styleId, type).toString();
    }

    protected StringBuilder getKeyBuffer(XWPFElement element, XWPFStylesDocument stylesDocument, String styleId, STTblStyleOverrideType.Enum type) {
        StringBuilder key = new StringBuilder(this.getClass().getName());
        if (StringUtils.isNotEmpty(styleId)) {
            key.append("_").append(styleId).toString();
        }
        if (type != null) {
            key.append("_table");
            key.append(type.intValue());
        }
        return key;
    }

    private String getBasisStyleID(CTStyle style) {
        if (style.getBasedOn() != null) {
            return style.getBasedOn().getVal();
        }
        return null;
    }

    protected abstract String[] getStyleID(XWPFElement var1);

    protected abstract Value getValueFromStyle(CTStyle var1);

    protected abstract Value getValueFromTableStyle(CTTblStylePr var1);

    protected Value getValueFromDefaultStyle(XWPFElement element, XWPFStylesDocument stylesDocument) {
        Value value = null;
        CTStyle style = this.getDefaultStyle(element, stylesDocument);
        if (style != null) {
            value = this.getValueFromStyle(style);
        }
        return value;
    }

    protected Value getValueFromDocDefaultsStyle(XWPFElement element, XWPFStylesDocument stylesDocument) {
        CTDocDefaults docDefaults = stylesDocument.getDocDefaults();
        if (docDefaults == null) {
            return null;
        }
        Value value = this.getValueFromDocDefaultsStyle(docDefaults, stylesDocument);
        if (value != null) {
            return value;
        }
        return null;
    }

    protected abstract Value getValueFromDocDefaultsStyle(CTDocDefaults var1, XWPFStylesDocument var2);

    protected abstract CTStyle getDefaultStyle(XWPFElement var1, XWPFStylesDocument var2);

    protected abstract XWPFTableCell getParentTableCell(XWPFElement var1);
}

