/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap.Server;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DList;
import opendap.dap.DSequence;
import opendap.dap.NoSuchVariableException;
import opendap.dap.PrimitiveVector;
import opendap.dap.Server.CEEvaluator;
import opendap.dap.Server.DAP2ServerSideException;
import opendap.dap.Server.InvalidOperatorException;
import opendap.dap.Server.RegExpException;
import opendap.dap.Server.RelOps;
import opendap.dap.Server.SBHException;
import opendap.dap.Server.ServerMethods;

public abstract class SDList
extends DList
implements ServerMethods,
RelOps {
    private static final boolean _Debug = false;
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDList() {
    }

    public SDList(String n) {
        super(n);
    }

    @Override
    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printDecl(os, space, print_semi, constrained);
    }

    @Override
    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.isProject()) {
            return;
        }
        PrimitiveVector pv = this.getPrimitiveVector();
        if (pv instanceof BaseTypePrimitiveVector) {
            ServerMethods sm;
            BaseTypePrimitiveVector vals = (BaseTypePrimitiveVector)pv;
            if (print_decl_p) {
                this.printDecl(os, space, false, true);
                os.print(" = ");
            }
            os.print("{ ");
            int len = vals.getLength();
            for (int i = 0; i < len - 1; ++i) {
                sm = (ServerMethods)((Object)vals.getValue(i));
                if (!sm.isProject()) continue;
                ((BaseType)((Object)sm)).printVal(os, "", false);
                os.print(", ");
            }
            if (len > 0 && (sm = (ServerMethods)((Object)vals.getValue(len - 1))).isProject()) {
                ((BaseType)((Object)sm)).printVal(os, "", false);
            }
            os.print("}");
            if (print_decl_p) {
                os.println(";");
            }
        } else {
            super.printVal(os, space, print_decl_p);
        }
    }

    @Override
    public void setProject(boolean state, boolean all) {
        this.setProjected(state);
        PrimitiveVector vals = this.getPrimitiveVector();
        ((ServerMethods)((Object)vals.getTemplate())).setProject(state, all);
    }

    @Override
    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDList!");
    }

    @Override
    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDList!");
    }

    @Override
    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDList!");
    }

    @Override
    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDList!");
    }

    @Override
    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDList!");
    }

    @Override
    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDList!");
    }

    @Override
    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDList!");
    }

    @Override
    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    @Override
    public boolean isSynthesized() {
        return this.Synthesized;
    }

    @Override
    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    @Override
    public boolean isRead() {
        return this.ReadMe;
    }

    @Override
    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    @Override
    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        PrimitiveVector vals = this.getPrimitiveVector();
        if (!this.isRead()) {
            this.read(dataset, specialO);
        }
        if (vals.getTemplate() instanceof DSequence || ce.evalClauses(specialO)) {
            int length = vals.getLength();
            sink.writeInt(length);
            if (vals instanceof BaseTypePrimitiveVector) {
                for (int i = 0; i < length; ++i) {
                    ServerMethods sm = (ServerMethods)((Object)((BaseTypePrimitiveVector)vals).getValue(i));
                    sm.serialize(dataset, sink, ce, specialO);
                }
            } else {
                sink.writeInt(length);
                vals.externalize(sink);
            }
        }
    }
}

