/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import opendap.dap.Alias;
import opendap.dap.Attribute;
import opendap.dap.AttributeExistsException;
import opendap.dap.AttributeTable;
import opendap.dap.BaseTypeFactory;
import opendap.dap.DAP2Exception;
import opendap.dap.DAPNode;
import opendap.dap.DDS;
import opendap.dap.DefaultFactory;
import opendap.dap.MalformedAliasException;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.UnresolvedAliasException;
import opendap.dap.parser.DapParser;
import opendap.dap.parser.ParseException;
import opendap.util.Debug;

public class DAS
extends AttributeTable {
    private AttributeTable currentAT = null;
    private Alias currentAlias = null;
    private BaseTypeFactory factory = new DefaultFactory();

    public DAS() {
        super("Attributes");
    }

    public boolean parse(InputStream stream) throws ParseException, DAP2Exception {
        DapParser parser = new DapParser(this.factory);
        int result = parser.dasparse(stream, this);
        if (result == 3) {
            throw parser.getERR();
        }
        return result == 1;
    }

    public final AttributeTable getAttributeTable(String name) throws NoSuchAttributeException {
        AttributeTable at = null;
        Attribute a = this.getAttribute(name);
        if (a != null && a.isContainer()) {
            at = a.getContainer();
        }
        return at;
    }

    public final AttributeTable getAttributeTableN(String name) {
        AttributeTable at = null;
        Attribute a = this.getAttribute(name);
        if (a != null && a.isContainer()) {
            at = a.getContainerN();
        }
        return at;
    }

    public void addAttributeTable(String name, AttributeTable a) throws AttributeExistsException {
        this.addContainer(name, a);
    }

    public void resolveAliases() throws MalformedAliasException, UnresolvedAliasException, NoSuchAttributeException {
        this.resolveAliases(this);
        Enumeration e = this.getNames();
        while (e.hasMoreElements()) {
            Attribute at;
            String aName = (String)e.nextElement();
            if (Debug.isSet("DAS")) {
                System.out.println("DAS.resolveAliases() - aName: " + aName);
            }
            if ((at = this.getAttribute(aName)) != null && at.isContainer()) continue;
            throw new MalformedAliasException("Aliases at the top-level of a DAS MUST reference a container (AttributeTable), not a simple Attribute");
        }
    }

    private void resolveAliases(AttributeTable at) throws MalformedAliasException, UnresolvedAliasException, NoSuchAttributeException {
        AttributeTable cacheAT = this.currentAT;
        this.currentAT = at;
        if (Debug.isSet("DAS")) {
            System.out.println("DAS.resolveAliases(at=" + at + ")");
        }
        Enumeration aNames = at.getNames();
        while (aNames.hasMoreElements()) {
            String aName = (String)aNames.nextElement();
            if (Debug.isSet("DAS")) {
                System.out.println("DAS.resolveAliases(at=" + at + ") - aName: " + aName);
            }
            Attribute thisA = this.currentAT.getAttribute(aName);
            if (Debug.isSet("DAS")) {
                System.out.println("thisA.getClass().getName(): " + thisA.getClass().getName());
            }
            if (thisA.isAlias()) {
                this.resolveAlias((Alias)thisA);
                if (!Debug.isSet("DAS")) continue;
                System.out.println("Resolved Alias: '" + thisA.getName() + "'\n");
                continue;
            }
            if (!thisA.isContainer()) continue;
            this.resolveAliases(thisA.getContainer());
        }
        this.currentAT = cacheAT;
    }

    private void resolveAlias(Alias alias) throws MalformedAliasException, UnresolvedAliasException {
        String name = alias.getClearName();
        String attribute = alias.getAliasedToAttributeFieldAsClearString();
        Enumeration e = null;
        this.currentAlias = alias;
        if (Debug.isSet("DAS")) {
            System.out.println("\n\nFound: Alias " + name + "  " + attribute);
        }
        if (attribute.equals("")) {
            throw new MalformedAliasException("The attribute 'attribute' in the Alias element must have a value other than an empty string.");
        }
        if (Debug.isSet("DAS")) {
            System.out.println("Attribute: `" + attribute + "'");
        }
        Vector aNames = DDS.tokenizeAliasField(attribute);
        if (Debug.isSet("DAS")) {
            System.out.println("Attribute name tokenized to " + aNames.size() + " elements");
            e = aNames.elements();
            while (e.hasMoreElements()) {
                String aname = (String)e.nextElement();
                System.out.println("name: " + aname);
            }
        }
        Attribute targetAT = null;
        boolean isAbsolutePath = aNames.get(0).equals(".");
        if (isAbsolutePath) {
            if (aNames.size() == 1) {
                throw new MalformedAliasException("Aliases must reference an Attribute. An attribute field of dot (.) references the entire DAS, which is not allowed.");
            }
        } else {
            throw new MalformedAliasException("In the Alias '" + name + "'" + " the attribute 'attribute' does not begin with the character dot (.). " + "The 'attribute' field must always be an absoulute path name from the " + "top level of the dataset, and thus must always begin with the dot (.) character.");
        }
        aNames.remove(0);
        targetAT = this.getAliasAttribute(this, aNames);
        alias.setMyAttribute(targetAT);
    }

    private Attribute getAliasAttribute(AttributeTable att, Vector aNames) throws MalformedAliasException, UnresolvedAliasException {
        String aName = (String)aNames.get(0);
        Enumeration e = att.getNames();
        while (e.hasMoreElements()) {
            String atName = (String)e.nextElement();
            Attribute a = att.getAttribute(atName);
            String normName = DDS.normalize(a.getName());
            if (!normName.equals(aName)) continue;
            if (a.isAlias()) {
                throw new MalformedAliasException("Aliases may NOT point to other aliases");
            }
            aNames.remove(0);
            if (aNames.size() == 0) {
                return a;
            }
            if (a.isContainer()) {
                try {
                    return this.getAliasAttribute(a.getContainer(), aNames);
                }
                catch (NoSuchAttributeException nsae) {
                    throw new MalformedAliasException("Attribute " + a.getName() + " is not an attribute container. (AttributeTable) " + " It may not contain the attribute: " + aName);
                }
            }
            throw new MalformedAliasException("Attribute " + a.getName() + " is not an attribute container. (AttributeTable) " + " It may not contain the attribute: " + aName);
        }
        throw new UnresolvedAliasException("The alias `" + this.currentAlias.getName() + "` references the attribute: `" + aName + "` which cannot be found.");
    }

    @Override
    public DAPNode cloneDAG(DAPNode.CloneMap map) throws CloneNotSupportedException {
        DAS das = (DAS)super.cloneDAG(map);
        return das;
    }
}

