/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.sigmet;

import java.io.IOException;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.nc2.iosp.sigmet.SigmetIOServiceProvider;
import ucar.unidata.io.RandomAccessFile;

public class Ray {
    private short bins;
    int dataRead;
    int offset;
    int offset1;
    private float range;
    private float step;
    private float az;
    private float elev;
    private short time;
    String varName;
    int nsweep;
    short datatype;

    public Ray(float range, float step, float az, float elev, short bins, short time, int offset, int dataRead, int offset1, int nsweep, String name, short datatype) {
        this.setRange(range);
        this.setStep(step);
        this.setAz(az);
        this.setElev(elev);
        this.setBins(bins);
        this.setTime(time);
        this.setOffset(offset);
        this.setDataRead(dataRead);
        this.setOffset1(offset1);
        this.setName(name);
        this.setNsweep(nsweep);
        this.setDataType(datatype);
    }

    public short getDataType() {
        return this.datatype;
    }

    public void setDataType(short datatype) {
        this.datatype = datatype;
    }

    public float getRange() {
        return this.range;
    }

    public void setRange(float range) {
        this.range = range;
    }

    public float getStep() {
        return this.step;
    }

    public void setStep(float step) {
        this.step = step;
    }

    public int getNsweep() {
        return this.nsweep;
    }

    public void setNsweep(int nsweep) {
        this.nsweep = nsweep;
    }

    public float getAz() {
        if (this.az < 0.0f & this.az > -361.0f) {
            this.az = 360.0f + this.az;
        }
        return this.az;
    }

    public void setAz(float az) {
        this.az = az;
    }

    public float getElev() {
        return this.elev;
    }

    public void setElev(float elev) {
        this.elev = elev;
    }

    public short getBins() {
        return this.bins;
    }

    public void setBins(short bins) {
        this.bins = bins;
    }

    public short getTime() {
        return this.time;
    }

    public void setTime(short time) {
        this.time = time;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getDataRead() {
        return this.dataRead;
    }

    public void setDataRead(int dataRead) {
        this.dataRead = dataRead;
    }

    public int getOffset1() {
        return this.offset1;
    }

    public void setOffset1(int offset1) {
        this.offset1 = offset1;
    }

    public void setName(String name) {
        this.varName = name;
    }

    public String getName() {
        return this.varName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Ray) {
            Ray oo = (Ray)o;
            return this.range == oo.range & this.step == oo.step & this.az == oo.az & this.elev == oo.elev & this.bins == oo.bins & this.time == oo.time;
        }
        return false;
    }

    public int hashCode() {
        return new Float(this.range).hashCode() + new Float(this.step).hashCode() + new Float(this.az).hashCode() + new Float(this.elev).hashCode() + new Short(this.bins).hashCode() + new Short(this.time).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Range=" + this.range);
        sb.append(" Step=" + this.step);
        if (this.az > -361.0f & this.az < 0.0f) {
            this.az = 360.0f + this.az;
        }
        sb.append(" Az=" + this.az);
        sb.append(" Elev=" + this.elev);
        sb.append(" Bins=" + this.bins);
        sb.append(" Time=" + this.time);
        return sb.toString();
    }

    public void readData(RandomAccessFile raf, Range gateRange, IndexIterator ii) throws IOException {
        byte d;
        int REC_SIZE = 6144;
        raf.seek((long)this.offset);
        byte[] data = new byte[this.bins];
        float[] dd = new float[this.bins];
        int nb = 0;
        if (this.dataRead > 0) {
            raf.seek((long)this.offset);
            for (int i = 0; i < this.dataRead; ++i) {
                d = raf.readByte();
                dd[i] = SigmetIOServiceProvider.calcData(SigmetIOServiceProvider.recHdr, this.getDataType(), d);
                ++nb;
            }
        }
        raf.seek((long)this.offset1);
        int cur_len = this.offset1;
        while (nb < this.bins) {
            int num_zero;
            int dataRead1;
            short a00 = raf.readShort();
            cur_len += 2;
            if (a00 == 1) {
                for (int uk = 0; uk < this.bins; ++uk) {
                    dd[uk] = -999.99f;
                }
                break;
            }
            if (a00 < 0) {
                int nwords = a00 & Short.MAX_VALUE;
                dataRead1 = nwords * 2;
                int pos = 0;
                if (cur_len % 6144 == 0) {
                    pos = 0;
                    break;
                }
                raf.seek((long)cur_len);
                for (int i = 0; i < dataRead1; ++i) {
                    d = raf.readByte();
                    dd[nb] = SigmetIOServiceProvider.calcData(SigmetIOServiceProvider.recHdr, this.getDataType(), d);
                    ++cur_len;
                    if (++nb % 6144 != 0) continue;
                    pos = i + 1;
                    break;
                }
                if (pos <= 0) continue;
                break;
            }
            if (!(a00 > 0 & a00 != 1)) continue;
            dataRead1 = num_zero = a00 * 2;
            for (int k = 0; k < dataRead1; ++k) {
                dd[nb + k] = SigmetIOServiceProvider.calcData(SigmetIOServiceProvider.recHdr, this.getDataType(), (byte)0);
            }
            nb += dataRead1;
            if (cur_len % 6144 != 0) continue;
            break;
        }
        for (int i = gateRange.first(); i <= gateRange.last(); i += gateRange.stride()) {
            if (i >= this.bins) {
                ii.setFloatNext(Float.NaN);
                continue;
            }
            ii.setFloatNext(dd[i]);
        }
    }
}

