/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.ErasureUtils;
import edu.stanford.nlp.util.HashableCoreMap;
import edu.stanford.nlp.util.IdentityHashSet;
import edu.stanford.nlp.util.TwoDimensionalMap;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.PrettyLogger;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ArrayCoreMap
implements CoreMap {
    public static Consumer<Class<? extends TypesafeMap.Key<?>>> listener;
    private static final int INITIAL_CAPACITY = 4;
    private Class<? extends TypesafeMap.Key<?>>[] keys;
    private Object[] values;
    private int size;
    private static final ThreadLocal<IdentityHashSet<CoreMap>> toStringCalled;
    private static final ConcurrentHashMap<Class, String> shortNames;
    private static final int SHORTER_STRING_CHARSTRING_START_SIZE = 64;
    private static final int SHORTER_STRING_MAX_SIZE_BEFORE_HASHING = 5;
    private static final ThreadLocal<TwoDimensionalMap<CoreMap, CoreMap, Boolean>> equalsCalled;
    private static final ThreadLocal<IdentityHashSet<CoreMap>> hashCodeCalled;
    private static final long serialVersionUID = 1L;

    public ArrayCoreMap() {
        this(4);
    }

    public ArrayCoreMap(int capacity) {
        this.keys = (Class[])ErasureUtils.uncheckedCast(new Class[capacity]);
        this.values = new Object[capacity];
    }

    public ArrayCoreMap(ArrayCoreMap other) {
        this.size = other.size;
        this.keys = Arrays.copyOf(other.keys, this.size);
        this.values = Arrays.copyOf(other.values, this.size);
    }

    public ArrayCoreMap(CoreMap other) {
        Set<Class<?>> otherKeys = other.keySet();
        this.size = otherKeys.size();
        this.keys = new Class[this.size];
        this.values = new Object[this.size];
        int i = 0;
        for (Class<?> key : otherKeys) {
            this.keys[i] = key;
            this.values[i] = other.get(key);
            ++i;
        }
    }

    @Override
    public <VALUE> VALUE get(Class<? extends TypesafeMap.Key<VALUE>> key) {
        for (int i = 0; i < this.size; ++i) {
            if (key != this.keys[i]) continue;
            if (listener != null) {
                listener.accept(key);
            }
            return (VALUE)this.values[i];
        }
        return null;
    }

    @Override
    public <VALUE> VALUE set(Class<? extends TypesafeMap.Key<VALUE>> key, VALUE value) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            Object rv = this.values[i];
            this.values[i] = value;
            return (VALUE)rv;
        }
        if (this.size >= this.keys.length) {
            int capacity = this.keys.length + (this.keys.length < 16 ? 4 : 8);
            Class[] newKeys = new Class[capacity];
            Object[] newValues = new Object[capacity];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.keys = newKeys;
            this.values = newValues;
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
        return null;
    }

    @Override
    public Set<Class<?>> keySet() {
        return new AbstractSet<Class<?>>(){

            @Override
            public Iterator<Class<?>> iterator() {
                return new Iterator<Class<?>>(){
                    private int i;

                    @Override
                    public boolean hasNext() {
                        return this.i < ArrayCoreMap.this.size;
                    }

                    @Override
                    public Class<?> next() {
                        try {
                            return ArrayCoreMap.this.keys[this.i++];
                        }
                        catch (ArrayIndexOutOfBoundsException aioobe) {
                            throw new NoSuchElementException("ArrayCoreMap keySet iterator exhausted");
                        }
                    }

                    @Override
                    public void remove() {
                        ArrayCoreMap.this.remove(ArrayCoreMap.this.keys[this.i]);
                    }
                };
            }

            @Override
            public int size() {
                return ArrayCoreMap.this.size;
            }
        };
    }

    public Set<Class<?>> keySetNotNull() {
        IdentityHashSet mapKeys = new IdentityHashSet();
        for (int i = 0; i < this.size(); ++i) {
            if (this.values[i] == null) continue;
            mapKeys.add(this.keys[i]);
        }
        return mapKeys;
    }

    @Override
    public <VALUE> VALUE remove(Class<? extends TypesafeMap.Key<VALUE>> key) {
        Object rv = null;
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            rv = this.values[i];
            if (i < this.size - 1) {
                System.arraycopy(this.keys, i + 1, this.keys, i, this.size - (i + 1));
                System.arraycopy(this.values, i + 1, this.values, i, this.size - (i + 1));
            }
            --this.size;
            break;
        }
        return (VALUE)rv;
    }

    @Override
    public <VALUE> boolean containsKey(Class<? extends TypesafeMap.Key<VALUE>> key) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != key) continue;
            return true;
        }
        return false;
    }

    public void compact() {
        if (this.keys.length > this.size) {
            Class[] newKeys = new Class[this.size];
            Object[] newValues = new Object[this.size];
            System.arraycopy(this.keys, 0, newKeys, 0, this.size);
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.keys = (Class[])ErasureUtils.uncheckedCast(newKeys);
            this.values = newValues;
        }
    }

    public void setCapacity(int newSize) {
        if (this.size > newSize) {
            throw new RuntimeException("You cannot set capacity to smaller than the current size.");
        }
        Class[] newKeys = new Class[newSize];
        Object[] newValues = new Object[newSize];
        System.arraycopy(this.keys, 0, newKeys, 0, this.size);
        System.arraycopy(this.values, 0, newValues, 0, this.size);
        this.keys = (Class[])ErasureUtils.uncheckedCast(newKeys);
        this.values = newValues;
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        IdentityHashSet<CoreMap> calledSet = toStringCalled.get();
        boolean createdCalledSet = calledSet.isEmpty();
        if (calledSet.contains(this)) {
            return "[...]";
        }
        calledSet.add(this);
        StringBuilder s = new StringBuilder("[");
        for (int i = 0; i < this.size; ++i) {
            s.append(this.keys[i].getSimpleName());
            s.append('=');
            s.append(this.values[i]);
            if (i >= this.size - 1) continue;
            s.append(' ');
        }
        s.append(']');
        if (createdCalledSet) {
            toStringCalled.remove();
        } else {
            calledSet.remove(this);
        }
        return s.toString();
    }

    @Override
    public String toShorterString(String ... what) {
        StringBuilder s = new StringBuilder(64);
        s.append('[');
        HashSet<String> whatSet = null;
        if (this.size > 5 && what.length > 5) {
            whatSet = new HashSet<String>(Arrays.asList(what));
        }
        for (int i = 0; i < this.size; ++i) {
            boolean include;
            Class<TypesafeMap.Key<?>> klass = this.keys[i];
            String name = shortNames.get(klass);
            if (name == null) {
                name = klass.getSimpleName();
                int annoIdx = name.lastIndexOf("Annotation");
                if (annoIdx >= 0) {
                    name = name.substring(0, annoIdx);
                }
                shortNames.put(klass, name);
            }
            if (what.length == 0) {
                include = true;
            } else if (whatSet != null) {
                include = whatSet.contains(name);
            } else {
                include = false;
                for (String item : what) {
                    if (!item.equals(name)) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            if (s.length() > 1) {
                s.append(' ');
            }
            s.append(name);
            s.append('=');
            s.append(this.values[i]);
        }
        s.append(']');
        return s.toString();
    }

    public String toShortString(String ... what) {
        return this.toShortString('/', what);
    }

    public String toShortString(char separator, String ... what) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.size; ++i) {
            boolean include;
            if (what.length > 0) {
                String name = this.keys[i].getSimpleName();
                int annoIdx = name.lastIndexOf("Annotation");
                if (annoIdx >= 0) {
                    name = name.substring(0, annoIdx);
                }
                include = false;
                for (String item : what) {
                    if (!item.equals(name)) continue;
                    include = true;
                    break;
                }
            } else {
                include = true;
            }
            if (!include) continue;
            if (s.length() > 0) {
                s.append(separator);
            }
            s.append(this.values[i]);
        }
        String answer = s.toString();
        if (answer.indexOf(32) < 0) {
            return answer;
        }
        return '{' + answer + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CoreMap)) {
            return false;
        }
        if (obj instanceof HashableCoreMap) {
            return obj.equals(this);
        }
        if (obj instanceof ArrayCoreMap) {
            return this.equals((ArrayCoreMap)obj);
        }
        CoreMap other = (CoreMap)obj;
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        for (Class<?> key : this.keySet()) {
            Object otherV;
            if (!other.containsKey(key)) {
                return false;
            }
            Object thisV = this.get(key);
            if (thisV == (otherV = other.get(key))) continue;
            if (thisV == null || otherV == null) {
                return false;
            }
            if (thisV.equals(otherV)) continue;
            return false;
        }
        return true;
    }

    private boolean equals(ArrayCoreMap other) {
        boolean createdCalledMap;
        TwoDimensionalMap<CoreMap, CoreMap, Boolean> calledMap = equalsCalled.get();
        boolean bl = createdCalledMap = calledMap == null;
        if (createdCalledMap) {
            calledMap = TwoDimensionalMap.identityHashMap();
            equalsCalled.set(calledMap);
        }
        if (calledMap.contains(this, other)) {
            return true;
        }
        boolean result = true;
        calledMap.put(this, other, true);
        calledMap.put(other, this, true);
        if (this.size != other.size) {
            result = false;
        } else {
            for (int i = 0; i < this.size; ++i) {
                boolean matched = false;
                for (int j = 0; j < other.size; ++j) {
                    if (this.keys[i] != other.keys[j]) continue;
                    if (this.values[i] == null && other.values[j] != null || this.values[i] != null && other.values[j] == null) {
                        matched = false;
                        break;
                    }
                    if ((this.values[i] != null || other.values[j] != null) && !this.values[i].equals(other.values[j])) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                result = false;
                break;
            }
        }
        if (createdCalledMap) {
            equalsCalled.set(null);
        }
        return result;
    }

    public int hashCode() {
        boolean createdCalledSet;
        IdentityHashSet<CoreMap> calledSet = hashCodeCalled.get();
        boolean bl = createdCalledSet = calledSet == null;
        if (createdCalledSet) {
            calledSet = new IdentityHashSet();
            hashCodeCalled.set(calledSet);
        }
        if (calledSet.contains(this)) {
            return 0;
        }
        calledSet.add(this);
        int keysCode = 0;
        int valuesCode = 0;
        for (int i = 0; i < this.size; ++i) {
            keysCode += i < this.keys.length && this.values[i] != null ? this.keys[i].hashCode() : 0;
            valuesCode += i < this.values.length && this.values[i] != null ? this.values[i].hashCode() : 0;
        }
        if (createdCalledSet) {
            hashCodeCalled.set(null);
        } else {
            calledSet.remove(this);
        }
        return keysCode * 37 + valuesCode;
    }

    private void writeObject(ObjectOutputStream out2) throws IOException {
        this.compact();
        out2.defaultWriteObject();
    }

    @Override
    public void prettyLog(Redwood.RedwoodChannels channels, String description) {
        Redwood.startTrack(description);
        ArrayList sortedKeys = new ArrayList(this.keySet());
        Collections.sort(sortedKeys, (a, b) -> a.getCanonicalName().compareTo(b.getCanonicalName()));
        for (Class clazz : sortedKeys) {
            String keyName = clazz.getCanonicalName().replace("class ", "");
            Object value = this.get(clazz);
            if (PrettyLogger.dispatchable(value)) {
                PrettyLogger.log(channels, keyName, value);
                continue;
            }
            channels.logf("%s = %s", keyName, value);
        }
        Redwood.endTrack(description);
    }

    static {
        toStringCalled = new ThreadLocal<IdentityHashSet<CoreMap>>(){

            @Override
            protected IdentityHashSet<CoreMap> initialValue() {
                return new IdentityHashSet<CoreMap>();
            }
        };
        shortNames = new ConcurrentHashMap(12, 0.75f, 1);
        equalsCalled = new ThreadLocal();
        hashCodeCalled = new ThreadLocal();
    }
}

