/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import java.util.NoSuchElementException;

public enum SentimentClass {
    VERY_POSITIVE,
    POSITIVE,
    NEUTRAL,
    NEGATIVE,
    VERY_NEGATIVE;


    public boolean isPositive() {
        return this == VERY_POSITIVE || this == POSITIVE;
    }

    public boolean isNegative() {
        return this == VERY_NEGATIVE || this == NEGATIVE;
    }

    public boolean isExtreme() {
        return this == VERY_NEGATIVE || this == VERY_POSITIVE;
    }

    public boolean isMild() {
        return !this.isExtreme();
    }

    public boolean isNeutral() {
        return this == NEUTRAL;
    }

    public static SentimentClass fromInt(int sentiment) {
        switch (sentiment) {
            case 0: {
                return VERY_NEGATIVE;
            }
            case 1: {
                return NEGATIVE;
            }
            case 2: {
                return NEUTRAL;
            }
            case 3: {
                return POSITIVE;
            }
            case 4: {
                return VERY_POSITIVE;
            }
        }
        throw new NoSuchElementException("No sentiment value for integer: " + sentiment);
    }
}

