/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SentenceAlgorithms {
    public final Sentence sentence;

    public SentenceAlgorithms(Sentence impl) {
        this.sentence = impl;
    }

    public List<Span> keyphraseSpans() {
        ArrayList<Span> spans = new ArrayList<Span>();
        int spanBegin = -1;
        HashSet expectNextTag = new HashSet();
        HashSet expectNextLemma = new HashSet();
        boolean inLookahead = false;
        Consumer<Character> updateExpectation = coarseTag -> {
            if (coarseTag.charValue() == 'N') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('N'));
                expectNextTag.add(Character.valueOf('X'));
                expectNextLemma.clear();
                expectNextLemma.add("of");
                expectNextLemma.add("'s");
            } else if (coarseTag.charValue() == 'G') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('N'));
                expectNextLemma.clear();
            } else if (coarseTag.charValue() == 'X') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('X'));
                expectNextLemma.clear();
            } else if (coarseTag.charValue() == 'J') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('N'));
                expectNextTag.add(Character.valueOf('X'));
                expectNextTag.add(Character.valueOf('J'));
                expectNextLemma.clear();
            } else if (coarseTag.charValue() == 'V') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('V'));
                expectNextLemma.clear();
            } else if (coarseTag.charValue() == 'Z') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('J'));
                expectNextTag.add(Character.valueOf('N'));
                expectNextLemma.clear();
            } else if (coarseTag.charValue() == 'I') {
                expectNextTag.clear();
                expectNextTag.add(Character.valueOf('N'));
                expectNextTag.add(Character.valueOf('X'));
                expectNextTag.add(Character.valueOf('J'));
                expectNextLemma.clear();
            } else {
                throw new IllegalStateException("Cannot update expected next token for POS tag: " + coarseTag);
            }
        };
        for (int i = 0; i < this.sentence.length(); ++i) {
            String tag = this.sentence.posTag(i);
            char coarseTag2 = Character.toUpperCase(tag.charAt(0));
            String lemma = this.sentence.lemma(i).toLowerCase();
            if (coarseTag2 == 'V' && lemma.equals("be")) {
                coarseTag2 = 'B';
            } else if (tag.startsWith("NNP")) {
                coarseTag2 = 'X';
            } else if (tag.startsWith("POS")) {
                coarseTag2 = 'Z';
            }
            if (coarseTag2 == 'N' && this.sentence.word(i).endsWith("ing")) {
                coarseTag2 = 'G';
            }
            if (!(spanBegin >= 0 || this.sentence.word(i).equals("%") || coarseTag2 != 'N' && coarseTag2 != 'V' && coarseTag2 != 'J' && coarseTag2 != 'X' && coarseTag2 != 'G')) {
                spanBegin = i;
                updateExpectation.accept(Character.valueOf(coarseTag2));
                inLookahead = false;
                continue;
            }
            if (spanBegin < 0) continue;
            if (expectNextTag.contains(Character.valueOf(coarseTag2))) {
                updateExpectation.accept(Character.valueOf(coarseTag2));
                inLookahead = false;
                continue;
            }
            if (expectNextLemma.contains(lemma)) {
                switch (lemma) {
                    case "of": {
                        updateExpectation.accept(Character.valueOf('I'));
                        inLookahead = true;
                        break;
                    }
                    case "'s": {
                        updateExpectation.accept(Character.valueOf('Z'));
                        inLookahead = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown special lemma: " + lemma);
                    }
                }
                continue;
            }
            if (inLookahead) {
                spans.add(Span.fromValues(spanBegin, i - 1));
            } else {
                spans.add(Span.fromValues(spanBegin, i));
            }
            if (coarseTag2 == 'N' || coarseTag2 == 'V' || coarseTag2 == 'J' || coarseTag2 == 'X' || coarseTag2 == 'G') {
                spanBegin = i;
                updateExpectation.accept(Character.valueOf(coarseTag2));
            } else {
                spanBegin = -1;
            }
            inLookahead = false;
        }
        if (spanBegin >= 0) {
            spans.add(Span.fromValues(spanBegin, inLookahead ? this.sentence.length() - 1 : this.sentence.length()));
        }
        return spans;
    }

    public List<String> keyphrases(Function<Sentence, List<String>> toString) {
        return this.keyphraseSpans().stream().map(x -> StringUtils.join(((List)toString.apply(this.sentence)).subList(x.start(), x.end()), " ")).collect(Collectors.toList());
    }

    public List<String> keyphrases() {
        return this.keyphrases(Sentence::words);
    }

    public int headOfSpan(Span tokenSpan) {
        Optional<Integer> parent;
        if (tokenSpan.size() == 0) {
            throw new IllegalArgumentException("Cannot find head word of empty span!");
        }
        List<Optional<Integer>> governors = this.sentence.governors();
        if (tokenSpan.start() >= governors.size()) {
            throw new IllegalArgumentException("Span is out of range: " + tokenSpan + "; sentence: " + this.sentence);
        }
        if (tokenSpan.end() > governors.size()) {
            throw new IllegalArgumentException("Span is out of range: " + tokenSpan + "; sentence: " + this.sentence);
        }
        int candidateStart = tokenSpan.end() - 1;
        while (!(parent = governors.get(candidateStart)).isPresent()) {
            if (--candidateStart >= tokenSpan.start()) continue;
            return tokenSpan.end() - 1;
        }
        int candidate = candidateStart;
        HashSet<Integer> seen = new HashSet<Integer>();
        while (parent.isPresent() && parent.get() >= tokenSpan.start() && parent.get() < tokenSpan.end()) {
            candidate = parent.get();
            if (seen.contains(candidate)) {
                return candidate;
            }
            seen.add(candidate);
            parent = governors.get(candidate);
        }
        return candidate;
    }

    public <E> Iterable<List<E>> allSpans(final Function<Sentence, List<E>> selector, final int maxLength) {
        return () -> new Iterator<List<E>>(){
            private int length;
            private int start;
            {
                this.length = maxLength > SentenceAlgorithms.this.sentence.length() ? SentenceAlgorithms.this.sentence.length() : maxLength;
                this.start = 0;
            }

            @Override
            public boolean hasNext() {
                return this.length > 0;
            }

            @Override
            public List<E> next() {
                List rtn = ((List)selector.apply(SentenceAlgorithms.this.sentence)).subList(this.start, this.start + this.length);
                ++this.start;
                if (this.start + this.length > SentenceAlgorithms.this.sentence.length()) {
                    --this.length;
                    this.start = 0;
                }
                return rtn;
            }
        };
    }

    public <E> Iterable<List<E>> allSpans(Function<Sentence, List<E>> selector) {
        return this.allSpans(selector, this.sentence.length());
    }

    public Iterable<List<String>> allSpans() {
        return this.allSpans(Sentence::words, this.sentence.length());
    }

    public <E> E modeInSpan(Span span, Function<Sentence, List<E>> selector) {
        if (!Span.fromValues(0, this.sentence.length()).contains(span)) {
            throw new IllegalArgumentException("Span must be entirely contained in the sentence: " + span + " (sentence length=" + this.sentence.length() + ")");
        }
        ClassicCounter<E> candidates = new ClassicCounter<E>();
        for (int i : span) {
            candidates.incrementCount(selector.apply(this.sentence).get(i));
        }
        candidates.remove(null);
        return Counters.argmax(candidates);
    }

    public List<String> dependencyPathBetween(int start, int end, Function<Sentence, List<String>> selector) {
        int i;
        LinkedList<Integer> rootToStart = new LinkedList<Integer>();
        LinkedList<Integer> rootToEnd = new LinkedList<Integer>();
        int startAncestor = start;
        List<Optional<Integer>> governors = this.sentence.governors();
        HashSet<Integer> seenVertices = new HashSet<Integer>();
        while (startAncestor >= 0 && governors.get(startAncestor).isPresent()) {
            if (seenVertices.contains(startAncestor)) {
                return Collections.EMPTY_LIST;
            }
            seenVertices.add(startAncestor);
            rootToStart.addFirst(startAncestor);
            startAncestor = governors.get(startAncestor).get();
        }
        if (startAncestor == -1) {
            rootToStart.addFirst(-1);
        }
        int endAncestor = end;
        seenVertices.clear();
        while (endAncestor >= 0 && governors.get(endAncestor).isPresent()) {
            if (seenVertices.contains(endAncestor)) {
                return Collections.EMPTY_LIST;
            }
            seenVertices.add(endAncestor);
            rootToEnd.addFirst(endAncestor);
            endAncestor = governors.get(endAncestor).get();
        }
        if (endAncestor == -1) {
            rootToEnd.addFirst(-1);
        }
        int leastCommonNodeIndex = rootToStart.size() == 0 || rootToEnd.size() == 0 || !((Integer)rootToStart.get(0)).equals(rootToEnd.get(0)) ? -1 : 0;
        for (int i2 = 1; i2 < Math.min(rootToStart.size(), rootToEnd.size()); ++i2) {
            if (!((Integer)rootToStart.get(i2)).equals(rootToEnd.get(i2))) continue;
            leastCommonNodeIndex = i2;
        }
        if (leastCommonNodeIndex < 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> path = new ArrayList<String>();
        for (i = rootToStart.size() - 1; i > leastCommonNodeIndex; --i) {
            path.add(selector.apply(this.sentence).get((Integer)rootToStart.get(i)));
            path.add("<-" + this.sentence.incomingDependencyLabel((Integer)rootToStart.get(i)).orElse("dep") + "-");
        }
        path.add(selector.apply(this.sentence).get((Integer)rootToStart.get(leastCommonNodeIndex)));
        for (i = leastCommonNodeIndex + 1; i < rootToEnd.size(); ++i) {
            path.add("-" + this.sentence.incomingDependencyLabel((Integer)rootToEnd.get(i)).orElse("dep") + "->");
            path.add(selector.apply(this.sentence).get((Integer)rootToEnd.get(i)));
        }
        return path;
    }

    public List<String> dependencyPathBetween(int start, int end) {
        return this.dependencyPathBetween(start, end, Sentence::words);
    }

    public void unescapeHTML() {
        for (int i = 0; i < this.sentence.length(); ++i) {
            CoreNLPProtos.Token.Builder token = this.sentence.rawToken(i);
            token.setWord(StringUtils.unescapeHtml3(token.getWord()));
            token.setLemma(StringUtils.unescapeHtml3(token.getLemma()));
        }
        CoreMap cm = (CoreMap)((List)this.sentence.document.asAnnotation().get(CoreAnnotations.SentencesAnnotation.class)).get(this.sentence.sentenceIndex());
        for (CoreLabel token : (List)cm.get(CoreAnnotations.TokensAnnotation.class)) {
            token.setWord(StringUtils.unescapeHtml3(token.word()));
            token.setLemma(StringUtils.unescapeHtml3(token.lemma()));
        }
    }
}

