/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.machinereading.structure.RelationMention;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.OpenIE;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class TextOutputter
extends AnnotationOutputter {
    @Override
    public void print(Annotation annotation, OutputStream stream, AnnotationOutputter.Options options) throws IOException {
        PrintWriter os = new PrintWriter(IOUtils.encodedOutputStreamWriter(stream, options.encoding));
        TextOutputter.print(annotation, os, options);
    }

    private static void print(Annotation annotation, PrintWriter pw, AnnotationOutputter.Options options) throws IOException {
        Map corefChains;
        String docSourceType;
        String docType;
        String docDate;
        String docTitle;
        double beam = options.beamPrintingOption;
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        String docId = (String)annotation.get(CoreAnnotations.DocIDAnnotation.class);
        if (docId != null) {
            List tokens = (List)annotation.get(CoreAnnotations.TokensAnnotation.class);
            int nSentences = sentences != null ? sentences.size() : 0;
            int nTokens = tokens != null ? tokens.size() : 0;
            pw.printf("Document: ID=%s (%d sentences, %d tokens)%n", docId, nSentences, nTokens);
        }
        if ((docTitle = (String)annotation.get(CoreAnnotations.DocTitleAnnotation.class)) != null) {
            pw.printf("Document Title: %s%n", docTitle);
        }
        if ((docDate = (String)annotation.get(CoreAnnotations.DocDateAnnotation.class)) != null) {
            pw.printf("Document Date: %s%n", docDate);
        }
        if ((docType = (String)annotation.get(CoreAnnotations.DocTypeAnnotation.class)) != null) {
            pw.printf("Document Type: %s%n", docType);
        }
        if ((docSourceType = (String)annotation.get(CoreAnnotations.DocSourceTypeAnnotation.class)) != null) {
            pw.printf("Document Source Type: %s%n", docSourceType);
        }
        if (sentences != null) {
            int sz = sentences.size();
            for (int i = 0; i < sz; ++i) {
                Collection kbpTriples;
                Collection openieTriples;
                List relations;
                List entities;
                CoreMap sentence = (CoreMap)sentences.get(i);
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                String sentiment = (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class);
                sentiment = sentiment == null ? "" : ", sentiment: " + sentiment;
                pw.printf("Sentence #%d (%d tokens%s):%n", i + 1, tokens.size(), sentiment);
                String text = (String)sentence.get(CoreAnnotations.TextAnnotation.class);
                pw.println(text);
                String[] tokenAnnotations = new String[]{"Text", "PartOfSpeech", "Lemma", "Answer", "NamedEntityTag", "CharacterOffsetBegin", "CharacterOffsetEnd", "NormalizedNamedEntityTag", "Timex", "TrueCase", "TrueCaseText", "SentimentClass", "WikipediaEntity"};
                for (CoreLabel token : tokens) {
                    pw.print(token.toShorterString(tokenAnnotations));
                    pw.println();
                }
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                if (tree != null) {
                    options.constituentTreePrinter.printTree(tree, pw);
                }
                if (sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class) != null) {
                    pw.print(((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)).toList());
                    pw.println();
                }
                if ((entities = (List)sentence.get(MachineReadingAnnotations.EntityMentionsAnnotation.class)) != null) {
                    pw.println("Extracted the following MachineReading entity mentions:");
                    for (Object e : entities) {
                        pw.print('\t');
                        pw.println(e);
                    }
                }
                if ((relations = (List)sentence.get(MachineReadingAnnotations.RelationMentionsAnnotation.class)) != null) {
                    Object e;
                    pw.println("Extracted the following MachineReading relation mentions:");
                    e = relations.iterator();
                    while (e.hasNext()) {
                        RelationMention r = (RelationMention)e.next();
                        if (!r.printableObject(beam)) continue;
                        pw.println(r);
                    }
                }
                if ((openieTriples = (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class)) != null && openieTriples.size() > 0) {
                    pw.println("Extracted the following Open IE triples:");
                    for (RelationTriple triple : openieTriples) {
                        pw.println(OpenIE.tripleToString(triple, docId, sentence));
                    }
                }
                if ((kbpTriples = (Collection)sentence.get(CoreAnnotations.KBPTriplesAnnotation.class)) == null || kbpTriples.size() <= 0) continue;
                pw.println("Extracted the following KBP triples:");
                for (RelationTriple triple : kbpTriples) {
                    pw.println(triple.toString());
                }
            }
        }
        if ((corefChains = (Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)) != null && sentences != null) {
            for (CorefChain chain : corefChains.values()) {
                CorefChain.CorefMention representative = chain.getRepresentativeMention();
                boolean outputHeading = false;
                for (CorefChain.CorefMention mention : chain.getMentionsInTextualOrder()) {
                    if (mention == representative) continue;
                    if (!outputHeading) {
                        outputHeading = true;
                        pw.println("Coreference set:");
                    }
                    pw.printf("\t(%d,%d,[%d,%d]) -> (%d,%d,[%d,%d]), that is: \"%s\" -> \"%s\"%n", mention.sentNum, mention.headIndex, mention.startIndex, mention.endIndex, representative.sentNum, representative.headIndex, representative.startIndex, representative.endIndex, mention.mentionSpan, representative.mentionSpan);
                }
            }
        }
        pw.flush();
    }

    public static void prettyPrint(Annotation annotation, OutputStream stream, StanfordCoreNLP pipeline) {
        TextOutputter.prettyPrint(annotation, new PrintWriter(stream), pipeline);
    }

    public static void prettyPrint(Annotation annotation, PrintWriter pw, StanfordCoreNLP pipeline) {
        try {
            TextOutputter.print(annotation, pw, TextOutputter.getOptions(pipeline));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

