/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.NERClassifierCombiner;
import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.types.Tags;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.SentenceAnnotator;
import edu.stanford.nlp.time.TimeAnnotations;
import edu.stanford.nlp.time.TimeExpression;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class NERCombinerAnnotator
extends SentenceAnnotator {
    private static final Redwood.RedwoodChannels log = Redwood.channels(NERCombinerAnnotator.class);
    private final NERClassifierCombiner ner;
    private final boolean VERBOSE;
    private final long maxTime;
    private final int nThreads;
    private final int maxSentenceLength;

    public NERCombinerAnnotator() throws IOException, ClassNotFoundException {
        this(true);
    }

    public NERCombinerAnnotator(boolean verbose) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(new Properties()), verbose);
    }

    public NERCombinerAnnotator(boolean verbose, String ... classifiers) throws IOException, ClassNotFoundException {
        this(new NERClassifierCombiner(classifiers), verbose);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose) {
        this(ner, verbose, 1, 0L, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime) {
        this(ner, verbose, nThreads, maxTime, Integer.MAX_VALUE);
    }

    public NERCombinerAnnotator(NERClassifierCombiner ner, boolean verbose, int nThreads, long maxTime, int maxSentenceLength) {
        this.VERBOSE = verbose;
        this.ner = ner;
        this.maxTime = maxTime;
        this.nThreads = nThreads;
        this.maxSentenceLength = maxSentenceLength;
    }

    public NERCombinerAnnotator(String name, Properties properties) {
        this(NERClassifierCombiner.createNERClassifierCombiner(name, properties), PropertiesUtils.getBool(properties, name + ".verbose", false), PropertiesUtils.getInt(properties, name + ".nthreads", PropertiesUtils.getInt(properties, "nthreads", 1)), PropertiesUtils.getLong(properties, name + ".maxtime", -1L), PropertiesUtils.getInt(properties, name + ".maxlen", Integer.MAX_VALUE));
    }

    @Override
    protected int nThreads() {
        return this.nThreads;
    }

    @Override
    protected long maxTime() {
        return this.maxTime;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            log.info("Adding NER Combiner annotation ... ");
        }
        super.annotate(annotation);
        this.ner.finalizeAnnotation(annotation);
        if (this.VERBOSE) {
            log.info("done.");
        }
    }

    @Override
    public void doOneSentence(Annotation annotation, CoreMap sentence) {
        List output;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        try {
            output = this.ner.classifySentenceWithGlobalInformation(tokens, annotation, sentence);
        }
        catch (RuntimeInterruptedException e) {
            output = null;
        }
        if (output == null) {
            this.doOneFailedSentence(annotation, sentence);
        } else {
            int sz = tokens.size();
            for (int i = 0; i < sz; ++i) {
                String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NamedEntityTagAnnotation.class);
                String normNeTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
                ((CoreLabel)tokens.get(i)).setNER(neTag);
                if (normNeTag != null) {
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, normNeTag);
                }
                NumberSequenceClassifier.transferAnnotations((CoreLabel)output.get(i), (CoreLabel)tokens.get(i));
            }
            if (this.VERBOSE) {
                boolean first = true;
                StringBuilder sb = new StringBuilder("NERCombinerAnnotator output: [");
                for (CoreLabel w : tokens) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(w.toShorterString("Text", "NamedEntityTag", "NormalizedNamedEntityTag"));
                }
                sb.append(']');
                log.info(sb);
            }
        }
    }

    @Override
    public void doOneFailedSentence(Annotation annotation, CoreMap sentence) {
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (CoreLabel token : tokens) {
            if (token.ner() != null) continue;
            token.setNER(this.ner.backgroundSymbol());
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        if (this.ner.usesSUTime() || this.ner.appliesNumericClassifiers()) {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class)));
        }
        return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.CharacterOffsetBeginAnnotation.class, CoreAnnotations.CharacterOffsetEndAnnotation.class, CoreAnnotations.BeforeAnnotation.class, CoreAnnotations.AfterAnnotation.class, CoreAnnotations.TokenBeginAnnotation.class, CoreAnnotations.TokenEndAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return new HashSet<Class<? extends CoreAnnotation>>(Arrays.asList(CoreAnnotations.NamedEntityTagAnnotation.class, CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, CoreAnnotations.ValueAnnotation.class, TimeExpression.Annotation.class, TimeExpression.TimeIndexAnnotation.class, CoreAnnotations.DistSimAnnotation.class, CoreAnnotations.NumericCompositeTypeAnnotation.class, TimeAnnotations.TimexAnnotation.class, CoreAnnotations.NumericValueAnnotation.class, TimeExpression.ChildrenAnnotation.class, CoreAnnotations.NumericTypeAnnotation.class, CoreAnnotations.ShapeAnnotation.class, Tags.TagsAnnotation.class, CoreAnnotations.NumerizedTokensAnnotation.class, CoreAnnotations.AnswerAnnotation.class, CoreAnnotations.NumericCompositeValueAnnotation.class));
    }
}

