/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.classify.Classifier;
import edu.stanford.nlp.classify.LinearClassifier;
import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.WordLists;
import edu.stanford.nlp.ie.KBPEnsembleExtractor;
import edu.stanford.nlp.ie.KBPRelationExtractor;
import edu.stanford.nlp.ie.KBPSemgrexExtractor;
import edu.stanford.nlp.ie.KBPStatisticalExtractor;
import edu.stanford.nlp.ie.KBPTokensregexExtractor;
import edu.stanford.nlp.ie.machinereading.structure.Span;
import edu.stanford.nlp.ie.util.RelationTriple;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.simple.Document;
import edu.stanford.nlp.util.AcronymMatcher;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.PropertiesUtils;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class KBPAnnotator
implements Annotator {
    private String NOT_PROVIDED = "none";
    private Properties kbpProperties;
    private static Redwood.RedwoodChannels log = Redwood.channels(KBPAnnotator.class);
    @ArgumentParser.Option(name="kbp.model", gloss="The path to the model, set to \"none\" for no model")
    private String model = "edu/stanford/nlp/models/kbp/tac-re-lr.ser.gz";
    @ArgumentParser.Option(name="kbp.semgrex", gloss="Semgrex patterns directory, set to \"none\" to not use semgrex")
    private String semgrexdir = "edu/stanford/nlp/models/kbp/semgrex";
    @ArgumentParser.Option(name="kbp.tokensregex", gloss="Tokensregex patterns directory, set to \"none\" to not use tokensregex")
    private String tokensregexdir = "edu/stanford/nlp/models/kbp/tokensregex";
    @ArgumentParser.Option(name="kbp.verbose", gloss="Print out KBP logging info")
    private boolean VERBOSE = false;
    public final KBPRelationExtractor extractor;
    private final ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer(false);
    private final EntityMentionsAnnotator entityMentionAnnotator;
    private final int maxLength;

    public KBPAnnotator(String name, Properties props) {
        ArgumentParser.fillOptions(this, name, props);
        this.kbpProperties = props;
        try {
            ArrayList<KBPRelationExtractor> extractors = new ArrayList<KBPRelationExtractor>();
            if (!this.tokensregexdir.equals(this.NOT_PROVIDED)) {
                extractors.add(new KBPTokensregexExtractor(this.tokensregexdir, this.VERBOSE));
            }
            if (!this.semgrexdir.equals(this.NOT_PROVIDED)) {
                extractors.add(new KBPSemgrexExtractor(this.semgrexdir, this.VERBOSE));
            }
            if (!this.model.equals(this.NOT_PROVIDED)) {
                KBPStatisticalExtractor statisticalExtractor;
                log.info("Loading KBP classifier from: " + this.model);
                Object object = IOUtils.readObjectFromURLOrClasspathOrFileSystem(this.model);
                if (object instanceof LinearClassifier) {
                    statisticalExtractor = new KBPStatisticalExtractor((Classifier)object);
                } else if (object instanceof KBPStatisticalExtractor) {
                    statisticalExtractor = (KBPStatisticalExtractor)object;
                } else {
                    throw new ClassCastException(object.getClass() + " cannot be cast into a " + KBPStatisticalExtractor.class);
                }
                extractors.add(statisticalExtractor);
            }
            this.extractor = new KBPEnsembleExtractor(extractors.toArray(new KBPRelationExtractor[extractors.size()]));
            this.maxLength = Integer.parseInt(props.getProperty("kbp.maxlen", "-1"));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeIOException(e);
        }
        this.entityMentionAnnotator = new EntityMentionsAnnotator("kbp.entitymention", PropertiesUtils.asProperties("kbp.entitymention.acronyms", "true", "acronyms", "true"));
    }

    public KBPAnnotator(Properties properties) {
        this("kbp", properties);
    }

    private static boolean kbpIsPronominalMention(CoreLabel word) {
        return WordLists.isKbpPronominalMention(word.word());
    }

    private static List<CoreMap> annotatePronominalMentions(Annotation ann) {
        ArrayList<CoreMap> pronouns = new ArrayList<CoreMap>();
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        for (int sentenceIndex = 0; sentenceIndex < sentences.size(); ++sentenceIndex) {
            CoreMap sentence = (CoreMap)sentences.get(sentenceIndex);
            Integer annoTokenBegin = (Integer)sentence.get(CoreAnnotations.TokenBeginAnnotation.class);
            if (annoTokenBegin == null) {
                annoTokenBegin = 0;
            }
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            for (int tokenIndex = 0; tokenIndex < tokens.size(); ++tokenIndex) {
                CoreLabel token = (CoreLabel)tokens.get(tokenIndex);
                if (!KBPAnnotator.kbpIsPronominalMention(token)) continue;
                Annotation pronoun = ChunkAnnotationUtils.getAnnotatedChunk(tokens, tokenIndex, tokenIndex + 1, annoTokenBegin, null, CoreAnnotations.TextAnnotation.class, null);
                pronoun.set(CoreAnnotations.SentenceIndexAnnotation.class, sentenceIndex);
                ((List)sentence.get(CoreAnnotations.MentionsAnnotation.class)).add(pronoun);
                pronouns.add(pronoun);
            }
        }
        return pronouns;
    }

    private static void acronymMatch(List<CoreMap> mentions, Map<CoreMap, Set<CoreMap>> mentionsMap) {
        String nerTag;
        int ticks = 0;
        HashMap textToMention = new HashMap();
        for (CoreMap mention : mentions) {
            List tokens;
            nerTag = (String)mention.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (nerTag == null || !nerTag.equals(KBPRelationExtractor.NERTag.ORGANIZATION.name) && !nerTag.equals(KBPRelationExtractor.NERTag.LOCATION.name) || (tokens = ((List)mention.get(CoreAnnotations.TokensAnnotation.class)).stream().map(CoreLabel::word).collect(Collectors.toList())).size() <= 1) continue;
            textToMention.put(tokens, mention);
        }
        for (CoreMap acronym : mentions) {
            String text;
            nerTag = (String)acronym.get(CoreAnnotations.NamedEntityTagAnnotation.class);
            if (nerTag == null || !nerTag.equals(KBPRelationExtractor.NERTag.ORGANIZATION.name) && !nerTag.equals(KBPRelationExtractor.NERTag.LOCATION.name) || (text = (String)acronym.get(CoreAnnotations.TextAnnotation.class)).contains(" ")) continue;
            Set<CoreMap> acronymCluster = mentionsMap.get(acronym);
            if (acronymCluster == null) {
                acronymCluster = new LinkedHashSet<CoreMap>();
                acronymCluster.add(acronym);
            }
            for (Map.Entry entry : textToMention.entrySet()) {
                if (++ticks > 1000) {
                    return;
                }
                if (!AcronymMatcher.isAcronym(text, (List)entry.getKey())) continue;
                CoreMap coreferent = (CoreMap)entry.getValue();
                Set<CoreMap> coreferentCluster = mentionsMap.get(coreferent);
                if (coreferentCluster == null) {
                    coreferentCluster = new LinkedHashSet<CoreMap>();
                    coreferentCluster.add(coreferent);
                }
                LinkedHashSet<CoreMap> newCluster = new LinkedHashSet<CoreMap>();
                newCluster.addAll(acronymCluster);
                newCluster.addAll(coreferentCluster);
                for (CoreMap key : newCluster) {
                    mentionsMap.put(key, newCluster);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void annotate(Annotation annotation) {
        void var10_40;
        void var10_37;
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        this.entityMentionAnnotator.annotate(annotation);
        Document doc = new Document(this.kbpProperties, this.serializer.toProto(annotation));
        ArrayList<CoreMap> mentions = new ArrayList<CoreMap>();
        for (CoreMap sentence : sentences) {
            mentions.addAll((Collection)sentence.get(CoreAnnotations.MentionsAnnotation.class));
        }
        List<CoreMap> pronounMentions = KBPAnnotator.annotatePronominalMentions(annotation);
        mentions.addAll(pronounMentions);
        HashMap<Pair<Integer, Integer>, CoreMap> mentionByStartIndex = new HashMap<Pair<Integer, Integer>, CoreMap>();
        for (CoreMap coreMap : mentions) {
            for (CoreLabel coreLabel : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                mentionByStartIndex.put(Pair.makePair(coreLabel.sentIndex(), coreLabel.index()), coreMap);
            }
        }
        HashMap<CoreMap, Set<CoreMap>> mentionsMap = new HashMap<CoreMap, Set<CoreMap>>();
        if (annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class) != null) {
            for (Map.Entry entry : ((Map)annotation.get(CorefCoreAnnotations.CorefChainAnnotation.class)).entrySet()) {
                Object var10_25 = null;
                for (CorefChain.CorefMention corefMention : ((CorefChain)entry.getValue()).getMentionsInTextualOrder()) {
                    void var10_26;
                    Object kbpMention = null;
                    for (int i = corefMention.startIndex; i < corefMention.endIndex; ++i) {
                        if (!mentionByStartIndex.containsKey(Pair.makePair(corefMention.sentNum - 1, i))) continue;
                        kbpMention = (CoreMap)mentionByStartIndex.get(Pair.makePair(corefMention.sentNum - 1, i));
                        break;
                    }
                    if (var10_26 == null) {
                        Iterator iterator = kbpMention;
                    }
                    if (kbpMention == null) continue;
                    if (!mentionsMap.containsKey(var10_26)) {
                        mentionsMap.put((CoreMap)var10_26, new LinkedHashSet());
                    }
                    ((Set)mentionsMap.get(var10_26)).add(kbpMention);
                }
            }
        }
        KBPAnnotator.acronymMatch(mentions, mentionsMap);
        for (CoreMap coreMap : new HashSet(mentionsMap.keySet())) {
            void var10_31;
            if (coreMap.get(CoreAnnotations.NamedEntityTagAnnotation.class) != null) continue;
            Object var10_29 = null;
            for (CoreMap coreMap2 : (Set)mentionsMap.get(coreMap)) {
                if (coreMap2.get(CoreAnnotations.NamedEntityTagAnnotation.class) == null) continue;
                CoreMap coreMap3 = coreMap2;
                break;
            }
            if (var10_31 != null) {
                mentionsMap.put((CoreMap)var10_31, (Set<CoreMap>)mentionsMap.remove(coreMap));
                continue;
            }
            mentionsMap.remove(coreMap);
        }
        for (Map.Entry entry : mentionsMap.entrySet()) {
            String string = (String)((CoreMap)entry.getKey()).get(CoreAnnotations.WikipediaEntityAnnotation.class);
            for (CoreMap coreMap : (Set)entry.getValue()) {
                for (CoreLabel token : (List)coreMap.get(CoreAnnotations.TokensAnnotation.class)) {
                    token.set(CoreAnnotations.WikipediaEntityAnnotation.class, string);
                }
            }
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : mentionsMap.entrySet()) {
            for (CoreMap coreMap : (Set)entry.getValue()) {
                coreMap.set(CoreAnnotations.NamedEntityTagAnnotation.class, ((CoreMap)entry.getKey()).get(CoreAnnotations.NamedEntityTagAnnotation.class));
                coreMap.set(CoreAnnotations.WikipediaEntityAnnotation.class, ((CoreMap)entry.getKey()).get(CoreAnnotations.WikipediaEntityAnnotation.class));
                hashMap.put(coreMap, entry.getKey());
            }
        }
        mentions.stream().filter(mention -> mentionToCanonicalMention.get(mention) == null).forEach(mention -> mentionToCanonicalMention.put((Serializable)mention, mention));
        List[] listArray = new List[((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).size()];
        boolean bl = false;
        while (var10_37 < listArray.length) {
            listArray[var10_37] = new ArrayList();
            ++var10_37;
        }
        for (CoreMap mention4 : hashMap.keySet()) {
            listArray[(Integer)mention4.get(CoreAnnotations.SentenceIndexAnnotation.class)].add(mention4);
        }
        boolean bl2 = false;
        while (var10_40 < listArray.length) {
            ArrayList<RelationTriple.WithLink> triples = new ArrayList<RelationTriple.WithLink>();
            List list = listArray[var10_40];
            int sentenceLength = ((List)((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get((int)var10_40)).get(CoreAnnotations.TokensAnnotation.class)).size();
            if (this.maxLength != -1 && sentenceLength > this.maxLength) {
                ((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get((int)var10_40)).set(CoreAnnotations.KBPTriplesAnnotation.class, triples);
            } else {
                for (int subjI = 0; subjI < list.size(); ++subjI) {
                    CoreMap subj = (CoreMap)list.get(subjI);
                    int subjBegin = ((CoreLabel)((List)subj.get(CoreAnnotations.TokensAnnotation.class)).get(0)).index() - 1;
                    int subjEnd = ((CoreLabel)((List)subj.get(CoreAnnotations.TokensAnnotation.class)).get(((List)subj.get(CoreAnnotations.TokensAnnotation.class)).size() - 1)).index();
                    Optional<KBPRelationExtractor.NERTag> subjNER = KBPRelationExtractor.NERTag.fromString((String)subj.get(CoreAnnotations.NamedEntityTagAnnotation.class));
                    if (!subjNER.isPresent()) continue;
                    for (int objI = 0; objI < list.size(); ++objI) {
                        if (subjI == objI) continue;
                        if (Thread.interrupted()) {
                            throw new RuntimeInterruptedException();
                        }
                        CoreMap obj = (CoreMap)list.get(objI);
                        int objBegin = ((CoreLabel)((List)obj.get(CoreAnnotations.TokensAnnotation.class)).get(0)).index() - 1;
                        int objEnd = ((CoreLabel)((List)obj.get(CoreAnnotations.TokensAnnotation.class)).get(((List)obj.get(CoreAnnotations.TokensAnnotation.class)).size() - 1)).index();
                        Optional<KBPRelationExtractor.NERTag> objNER = KBPRelationExtractor.NERTag.fromString((String)obj.get(CoreAnnotations.NamedEntityTagAnnotation.class));
                        if (!objNER.isPresent() || !KBPRelationExtractor.RelationType.plausiblyHasRelation(subjNER.get(), objNER.get())) continue;
                        KBPRelationExtractor.KBPInput input = new KBPRelationExtractor.KBPInput(new Span(subjBegin, subjEnd), new Span(objBegin, objEnd), subjNER.get(), objNER.get(), doc.sentence((int)var10_40));
                        Pair<String, Double> prediction = this.extractor.classify(input);
                        if ("no_relation".equals(prediction.first)) continue;
                        RelationTriple.WithLink triple = new RelationTriple.WithLink((List)subj.get(CoreAnnotations.TokensAnnotation.class), (List)((CoreMap)hashMap.get(subj)).get(CoreAnnotations.TokensAnnotation.class), Collections.singletonList(new CoreLabel(new Word((String)prediction.first))), (List)obj.get(CoreAnnotations.TokensAnnotation.class), (List)((CoreMap)hashMap.get(obj)).get(CoreAnnotations.TokensAnnotation.class), (Double)prediction.second, (SemanticGraph)((CoreMap)sentences.get((int)var10_40)).get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class), (String)subj.get(CoreAnnotations.WikipediaEntityAnnotation.class), (String)obj.get(CoreAnnotations.WikipediaEntityAnnotation.class));
                        triples.add(triple);
                    }
                }
                ((CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get((int)var10_40)).set(CoreAnnotations.KBPTriplesAnnotation.class, triples);
            }
            ++var10_40;
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.MentionsAnnotation.class, CoreAnnotations.KBPTriplesAnnotation.class));
        return Collections.unmodifiableSet(requirements);
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        HashSet<Class> requirements = new HashSet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.IndexAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.SentenceIndexAnnotation.class, CoreAnnotations.PartOfSpeechAnnotation.class, CoreAnnotations.LemmaAnnotation.class, SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, CoreAnnotations.OriginalTextAnnotation.class));
        return Collections.unmodifiableSet(requirements);
    }

    public static void main(String[] args) throws IOException {
        Properties props = StringUtils.argsToProperties(args);
        props.setProperty("annotators", "tokenize,ssplit,pos,lemma,ner,regexner,parse,mention,coref,kbp");
        props.setProperty("regexner.mapping", "ignorecase=true,validpospattern=^(NN|JJ).*,edu/stanford/nlp/models/kbp/regexner_caseless.tab;edu/stanford/nlp/models/kbp/regexner_cased.tab");
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        IOUtils.console("sentence> ", line -> {
            Annotation ann = new Annotation((String)line);
            pipeline.annotate(ann);
            for (CoreMap sentence : (List)ann.get(CoreAnnotations.SentencesAnnotation.class)) {
                ((List)sentence.get(CoreAnnotations.KBPTriplesAnnotation.class)).forEach(System.err::println);
            }
        });
    }
}

