/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.machinereading.structure.MachineReadingAnnotations;
import edu.stanford.nlp.ie.regexp.RegexNERSequenceClassifier;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.ArraySet;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class GenderAnnotator
implements Annotator {
    private static Redwood.RedwoodChannels log = Redwood.channels(GenderAnnotator.class);
    private final RegexNERSequenceClassifier classifier;
    private final boolean verbose;

    public GenderAnnotator() {
        this(false, "edu/stanford/nlp/models/gender/first_name_map_small");
    }

    public GenderAnnotator(boolean verbose, String mapping) {
        this.classifier = new RegexNERSequenceClassifier(mapping, true, true);
        this.verbose = verbose;
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.verbose) {
            log.info("Adding gender annotation...");
        }
        if (!annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            throw new RuntimeException("Unable to find sentences in " + annotation);
        }
        List sentences = (List)annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sentence : sentences) {
            List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
            this.classifier.classify(tokens);
            for (CoreLabel token : tokens) {
                token.set(MachineReadingAnnotations.GenderAnnotation.class, token.get(CoreAnnotations.AnswerAnnotation.class));
            }
        }
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requires() {
        return Collections.unmodifiableSet(new ArraySet<Class>(Arrays.asList(CoreAnnotations.TextAnnotation.class, CoreAnnotations.TokensAnnotation.class, CoreAnnotations.SentencesAnnotation.class, CoreAnnotations.NamedEntityTagAnnotation.class)));
    }

    @Override
    public Set<Class<? extends CoreAnnotation>> requirementsSatisfied() {
        return Collections.singleton(MachineReadingAnnotations.GenderAnnotation.class);
    }
}

