/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationSerializer;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CustomAnnotationSerializer
extends AnnotationSerializer {
    private static Redwood.RedwoodChannels log = Redwood.channels(CustomAnnotationSerializer.class);
    private final boolean compress;
    private final boolean haveExplicitAntecedent;
    private static final String SPACE_HOLDER = "##";

    public CustomAnnotationSerializer() {
        this(true, false);
    }

    public CustomAnnotationSerializer(boolean compress, boolean haveAnte) {
        this.compress = compress;
        this.haveExplicitAntecedent = haveAnte;
    }

    private static AnnotationSerializer.IntermediateSemanticGraph loadDependencyGraph(BufferedReader reader) throws IOException {
        String[] bbits;
        String[] bits;
        AnnotationSerializer.IntermediateSemanticGraph graph = new AnnotationSerializer.IntermediateSemanticGraph();
        String line = reader.readLine().trim();
        if (line.length() > 0) {
            bits = line.split("\t");
            if (bits.length < 3) {
                throw new RuntimeException("ERROR: Invalid dependency node line: " + line);
            }
            String docId = bits[0];
            if (docId.equals("-")) {
                docId = "";
            }
            int sentIndex = Integer.valueOf(bits[1]);
            for (int i = 2; i < bits.length; ++i) {
                String bit = bits[i];
                bbits = bit.split("-");
                int copyAnnotation = -1;
                boolean isRoot = false;
                if (bbits.length > 3) {
                    throw new RuntimeException("ERROR: Invalid format for dependency graph: " + line);
                }
                if (bbits.length == 2) {
                    copyAnnotation = Integer.valueOf(bbits[1]);
                } else if (bbits.length == 3) {
                    copyAnnotation = Integer.valueOf(bbits[1]);
                    isRoot = bbits[2].equals("R");
                }
                int index = Integer.valueOf(bbits[0]);
                graph.nodes.add(new AnnotationSerializer.IntermediateNode(docId, sentIndex, index, copyAnnotation, isRoot));
            }
        }
        if ((line = reader.readLine().trim()).length() > 0) {
            for (String bit : bits = line.split("\t")) {
                bbits = bit.split(" ");
                if (bbits.length < 3 || bbits.length > 6) {
                    throw new RuntimeException("ERROR: Invalid format for dependency graph: " + line);
                }
                String dep = bbits[0];
                int source = Integer.valueOf(bbits[1]);
                int target = Integer.valueOf(bbits[2]);
                boolean isExtra = bbits.length == 4 ? Boolean.valueOf(bbits[3]) : false;
                int sourceCopy = bbits.length > 4 ? Integer.valueOf(bbits[4]) : 0;
                int targetCopy = bbits.length > 5 ? Integer.valueOf(bbits[5]) : 0;
                graph.edges.add(new AnnotationSerializer.IntermediateEdge(dep, source, sourceCopy, target, targetCopy, isExtra));
            }
        }
        return graph;
    }

    private static void saveDependencyGraph(SemanticGraph graph, PrintWriter pw) {
        if (graph == null) {
            pw.println();
            pw.println();
            return;
        }
        boolean outputHeader = false;
        for (IndexedWord node : graph.vertexSet()) {
            if (!outputHeader) {
                String docId = (String)node.get(CoreAnnotations.DocIDAnnotation.class);
                if (docId != null && docId.length() > 0) {
                    pw.print(docId);
                } else {
                    pw.print("-");
                }
                pw.print("\t");
                pw.print(node.get(CoreAnnotations.SentenceIndexAnnotation.class));
                outputHeader = true;
            }
            pw.print("\t");
            pw.print(node.index());
            if (node.copyCount() > 0) {
                pw.print("-");
                pw.print(node.copyCount());
            }
            if (!graph.getRoots().contains(node)) continue;
            if (node.copyCount() > 0) {
                pw.print("-R");
                continue;
            }
            pw.print("-0-R");
        }
        pw.println();
        boolean first = true;
        for (SemanticGraphEdge edge : graph.edgeIterable()) {
            if (!first) {
                pw.print("\t");
            }
            String rel = edge.getRelation().toString();
            rel = rel.replaceAll("\\s+", "");
            pw.print(rel);
            pw.print(" ");
            pw.print(edge.getSource().index());
            pw.print(" ");
            pw.print(edge.getTarget().index());
            if (edge.isExtra() || edge.getSource().copyCount() > 0 || edge.getTarget().copyCount() > 0) {
                pw.print(" ");
                pw.print(edge.isExtra());
                pw.print(" ");
                pw.print(edge.getSource().copyCount());
                pw.print(" ");
                pw.print(edge.getTarget().copyCount());
            }
            first = false;
        }
        pw.println();
    }

    private static void saveCorefChains(Map<Integer, CorefChain> chains, PrintWriter pw) {
        if (chains == null) {
            pw.println();
            return;
        }
        pw.println(chains.size());
        for (Map.Entry<Integer, CorefChain> integerCorefChainEntry : chains.entrySet()) {
            CustomAnnotationSerializer.saveCorefChain(pw, integerCorefChainEntry.getKey(), integerCorefChainEntry.getValue());
        }
        pw.println();
    }

    private static int countMentions(CorefChain cluster) {
        int count = 0;
        for (IntPair mid : cluster.getMentionMap().keySet()) {
            count += cluster.getMentionMap().get(mid).size();
        }
        return count;
    }

    public static void saveCorefChain(PrintWriter pw, int cid, CorefChain cluster) {
        pw.println(cid + " " + CustomAnnotationSerializer.countMentions(cluster));
        Map<IntPair, Set<CorefChain.CorefMention>> mentionMap = cluster.getMentionMap();
        for (Map.Entry<IntPair, Set<CorefChain.CorefMention>> intPairSetEntry : mentionMap.entrySet()) {
            IntPair mentionIndices = intPairSetEntry.getKey();
            Set<CorefChain.CorefMention> mentions = intPairSetEntry.getValue();
            for (CorefChain.CorefMention mention : mentions) {
                pw.print(mentionIndices.getSource() + " " + mentionIndices.getTarget());
                if (mention == cluster.getRepresentativeMention()) {
                    pw.print(" 1");
                } else {
                    pw.print(" 0");
                }
                pw.print(" " + (Object)((Object)mention.mentionType));
                pw.print(" " + (Object)((Object)mention.number));
                pw.print(" " + (Object)((Object)mention.gender));
                pw.print(" " + (Object)((Object)mention.animacy));
                pw.print(" " + mention.startIndex);
                pw.print(" " + mention.endIndex);
                pw.print(" " + mention.headIndex);
                pw.print(" " + mention.corefClusterID);
                pw.print(" " + mention.mentionID);
                pw.print(" " + mention.sentNum);
                pw.print(" " + mention.position.length());
                for (int i = 0; i < mention.position.length(); ++i) {
                    pw.print(" " + mention.position.get(i));
                }
                pw.print(" " + CustomAnnotationSerializer.escapeSpace(mention.mentionSpan));
                pw.println();
            }
        }
    }

    private static String escapeSpace(String s) {
        return s.replaceAll("\\s", SPACE_HOLDER);
    }

    private static String unescapeSpace(String s) {
        return s.replaceAll(SPACE_HOLDER, " ");
    }

    private static Dictionaries.MentionType parseMentionType(String s) {
        return Dictionaries.MentionType.valueOf(s);
    }

    private static Dictionaries.Number parseNumber(String s) {
        return Dictionaries.Number.valueOf(s);
    }

    private static Dictionaries.Gender parseGender(String s) {
        return Dictionaries.Gender.valueOf(s);
    }

    private static Dictionaries.Animacy parseAnimacy(String s) {
        return Dictionaries.Animacy.valueOf(s);
    }

    private static Map<Integer, CorefChain> loadCorefChains(BufferedReader reader) throws IOException {
        String line = reader.readLine().trim();
        if (line.isEmpty()) {
            return null;
        }
        int clusterCount = Integer.valueOf(line);
        Map<Integer, CorefChain> chains = Generics.newHashMap();
        for (int c = 0; c < clusterCount; ++c) {
            line = reader.readLine().trim();
            String[] bits = line.split("\\s");
            int cid = Integer.valueOf(bits[0]);
            int mentionCount = Integer.valueOf(bits[1]);
            Map<IntPair, Set<CorefChain.CorefMention>> mentionMap = Generics.newHashMap();
            CorefChain.CorefMention representative = null;
            for (int m = 0; m < mentionCount; ++m) {
                line = reader.readLine();
                bits = line.split("\\s");
                IntPair key = new IntPair(Integer.valueOf(bits[0]), Integer.valueOf(bits[1]));
                boolean rep = bits[2].equals("1");
                Dictionaries.MentionType mentionType = CustomAnnotationSerializer.parseMentionType(bits[3]);
                Dictionaries.Number number = CustomAnnotationSerializer.parseNumber(bits[4]);
                Dictionaries.Gender gender = CustomAnnotationSerializer.parseGender(bits[5]);
                Dictionaries.Animacy animacy = CustomAnnotationSerializer.parseAnimacy(bits[6]);
                int startIndex = Integer.valueOf(bits[7]);
                int endIndex = Integer.valueOf(bits[8]);
                int headIndex = Integer.valueOf(bits[9]);
                int clusterID = Integer.valueOf(bits[10]);
                int mentionID = Integer.valueOf(bits[11]);
                int sentNum = Integer.valueOf(bits[12]);
                int posLen = Integer.valueOf(bits[13]);
                int[] posElems = new int[posLen];
                for (int i = 0; i < posLen; ++i) {
                    posElems[i] = Integer.valueOf(bits[14 + i]);
                }
                IntTuple position = new IntTuple(posElems);
                String span = CustomAnnotationSerializer.unescapeSpace(bits[14 + posLen]);
                CorefChain.CorefMention mention = new CorefChain.CorefMention(mentionType, number, gender, animacy, startIndex, endIndex, headIndex, clusterID, mentionID, sentNum, position, span);
                Set<CorefChain.CorefMention> mentionsWithThisHead = mentionMap.get(key);
                if (mentionsWithThisHead == null) {
                    mentionsWithThisHead = Generics.newHashSet();
                    mentionMap.put(key, mentionsWithThisHead);
                }
                mentionsWithThisHead.add(mention);
                if (!rep) continue;
                representative = mention;
            }
            CorefChain chain = new CorefChain(cid, mentionMap, representative);
            chains.put(cid, chain);
        }
        reader.readLine();
        return chains;
    }

    @Override
    public OutputStream write(Annotation corpus, OutputStream os) throws IOException {
        if (!(os instanceof GZIPOutputStream) && this.compress) {
            os = new GZIPOutputStream(os);
        }
        PrintWriter pw = new PrintWriter(os);
        Map chains = (Map)corpus.get(CorefCoreAnnotations.CorefChainAnnotation.class);
        CustomAnnotationSerializer.saveCorefChains(chains, pw);
        List corefGraph = (List)corpus.get(CorefCoreAnnotations.CorefGraphAnnotation.class);
        if (corefGraph != null) {
            boolean first = true;
            for (Pair arc : corefGraph) {
                if (!first) {
                    pw.print(" ");
                }
                pw.printf("%d %d %d %d", ((IntTuple)arc.first).get(0), ((IntTuple)arc.first).get(1), ((IntTuple)arc.second).get(0), ((IntTuple)arc.second).get(1));
                first = false;
            }
        }
        pw.println();
        List sentences = (List)corpus.get(CoreAnnotations.SentencesAnnotation.class);
        for (CoreMap sent : sentences) {
            Tree tree = (Tree)sent.get(TreeCoreAnnotations.TreeAnnotation.class);
            if (tree != null) {
                String treeString = tree.toString();
                treeString = treeString.replaceAll("\n", " ");
                pw.println(treeString);
            } else {
                pw.println();
            }
            SemanticGraph collapsedDeps = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class);
            CustomAnnotationSerializer.saveDependencyGraph(collapsedDeps, pw);
            SemanticGraph uncollapsedDeps = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
            CustomAnnotationSerializer.saveDependencyGraph(uncollapsedDeps, pw);
            SemanticGraph ccDeps = (SemanticGraph)sent.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            CustomAnnotationSerializer.saveDependencyGraph(ccDeps, pw);
            List tokens = (List)sent.get(CoreAnnotations.TokensAnnotation.class);
            if (tokens != null) {
                for (CoreLabel token : tokens) {
                    CustomAnnotationSerializer.saveToken(token, this.haveExplicitAntecedent, pw);
                    pw.println();
                }
            }
            pw.println();
        }
        pw.flush();
        return os;
    }

    @Override
    public Pair<Annotation, InputStream> read(InputStream is) throws IOException {
        String line;
        if (this.compress && !(is instanceof GZIPInputStream)) {
            is = new GZIPInputStream(is);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        Annotation doc = new Annotation("");
        Map<Integer, CorefChain> chains = CustomAnnotationSerializer.loadCorefChains(reader);
        if (chains != null) {
            doc.set(CorefCoreAnnotations.CorefChainAnnotation.class, chains);
        }
        if ((line = reader.readLine().trim()).length() > 0) {
            String[] bits = line.split(" ");
            if (bits.length % 4 != 0) {
                throw new RuntimeIOException("ERROR: Incorrect format for the serialized coref graph: " + line);
            }
            ArrayList<Pair<IntTuple, IntTuple>> corefGraph = new ArrayList<Pair<IntTuple, IntTuple>>();
            for (int i = 0; i < bits.length; i += 4) {
                IntTuple src = new IntTuple(2);
                IntTuple dst = new IntTuple(2);
                src.set(0, Integer.parseInt(bits[i]));
                src.set(1, Integer.parseInt(bits[i + 1]));
                dst.set(0, Integer.parseInt(bits[i + 2]));
                dst.set(1, Integer.parseInt(bits[i + 3]));
                corefGraph.add(new Pair<IntTuple, IntTuple>(src, dst));
            }
            doc.set(CorefCoreAnnotations.CorefGraphAnnotation.class, corefGraph);
        }
        ArrayList<Annotation> sentences = new ArrayList<Annotation>();
        while ((line = reader.readLine()) != null) {
            Annotation sentence = new Annotation("");
            Tree tree = new PennTreeReader(new StringReader(line), new LabeledScoredTreeFactory(CoreLabel.factory())).readTree();
            sentence.set(TreeCoreAnnotations.TreeAnnotation.class, tree);
            AnnotationSerializer.IntermediateSemanticGraph intermCollapsedDeps = CustomAnnotationSerializer.loadDependencyGraph(reader);
            AnnotationSerializer.IntermediateSemanticGraph intermUncollapsedDeps = CustomAnnotationSerializer.loadDependencyGraph(reader);
            AnnotationSerializer.IntermediateSemanticGraph intermCcDeps = CustomAnnotationSerializer.loadDependencyGraph(reader);
            ArrayList<CoreLabel> tokens = new ArrayList<CoreLabel>();
            while ((line = reader.readLine()) != null && line.length() != 0) {
                CoreLabel token = CustomAnnotationSerializer.loadToken(line, this.haveExplicitAntecedent);
                tokens.add(token);
            }
            sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
            SemanticGraph collapsedDeps = intermCollapsedDeps.convertIntermediateGraph(tokens);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, collapsedDeps);
            SemanticGraph uncollapsedDeps = intermUncollapsedDeps.convertIntermediateGraph(tokens);
            sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
            SemanticGraph ccDeps = intermCcDeps.convertIntermediateGraph(tokens);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
            sentences.add(sentence);
        }
        doc.set(CoreAnnotations.SentencesAnnotation.class, sentences);
        return Pair.makePair(doc, is);
    }

    private static CoreLabel loadToken(String line, boolean haveExplicitAntecedent) {
        String aa;
        CoreLabel token = new CoreLabel();
        String[] bits = line.split("\t", -1);
        if (bits.length < 7) {
            throw new RuntimeIOException("ERROR: Invalid format token for serialized token (only " + bits.length + " tokens): " + line);
        }
        String word = bits[0].replaceAll(SPACE_HOLDER, " ");
        token.set(CoreAnnotations.TextAnnotation.class, word);
        token.set(CoreAnnotations.ValueAnnotation.class, word);
        if (bits[1].length() > 0 || bits[0].length() == 0) {
            String lemma = bits[1].replaceAll(SPACE_HOLDER, " ");
            token.set(CoreAnnotations.LemmaAnnotation.class, lemma);
        }
        if (bits[2].length() > 0) {
            token.set(CoreAnnotations.PartOfSpeechAnnotation.class, bits[2]);
        }
        if (bits[3].length() > 0) {
            token.set(CoreAnnotations.NamedEntityTagAnnotation.class, bits[3]);
        }
        if (bits[4].length() > 0) {
            token.set(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class, bits[4]);
        }
        if (bits[5].length() > 0) {
            token.set(CoreAnnotations.CharacterOffsetBeginAnnotation.class, Integer.parseInt(bits[5]));
        }
        if (bits[6].length() > 0) {
            token.set(CoreAnnotations.CharacterOffsetEndAnnotation.class, Integer.parseInt(bits[6]));
        }
        if (haveExplicitAntecedent && bits.length > 7 && (aa = bits[7].replaceAll(SPACE_HOLDER, " ")).length() > 0) {
            token.set(CoreAnnotations.AntecedentAnnotation.class, aa);
        }
        return token;
    }

    private static void saveToken(CoreLabel token, boolean haveExplicitAntecedent, PrintWriter pw) {
        String aa;
        String word = (String)token.get(CoreAnnotations.TextAnnotation.class);
        if (word == null) {
            word = (String)token.get(CoreAnnotations.ValueAnnotation.class);
        }
        if (word != null) {
            word = word.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(word);
        }
        pw.print("\t");
        String lemma = (String)token.get(CoreAnnotations.LemmaAnnotation.class);
        if (lemma != null) {
            lemma = lemma.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(lemma);
        }
        pw.print("\t");
        String pos = (String)token.get(CoreAnnotations.PartOfSpeechAnnotation.class);
        if (pos != null) {
            pw.print(pos);
        }
        pw.print("\t");
        String ner = (String)token.get(CoreAnnotations.NamedEntityTagAnnotation.class);
        if (ner != null) {
            pw.print(ner);
        }
        pw.print("\t");
        String normNer = (String)token.get(CoreAnnotations.NormalizedNamedEntityTagAnnotation.class);
        if (normNer != null) {
            pw.print(normNer);
        }
        pw.print("\t");
        Integer charBegin = (Integer)token.get(CoreAnnotations.CharacterOffsetBeginAnnotation.class);
        if (charBegin != null) {
            pw.print(charBegin);
        }
        pw.print("\t");
        Integer charEnd = (Integer)token.get(CoreAnnotations.CharacterOffsetEndAnnotation.class);
        if (charEnd != null) {
            pw.print(charEnd);
        }
        if (haveExplicitAntecedent && (aa = (String)token.get(CoreAnnotations.AntecedentAnnotation.class)) != null) {
            pw.print("\t");
            aa = aa.replaceAll("\\s+", SPACE_HOLDER);
            pw.print(aa);
        }
    }

    public static void main(String[] args) throws Exception {
        Properties props = StringUtils.argsToProperties(args);
        StanfordCoreNLP pipeline = new StanfordCoreNLP(props);
        String file = props.getProperty("file");
        String loadFile = props.getProperty("loadFile");
        if (loadFile != null && !loadFile.isEmpty()) {
            CustomAnnotationSerializer ser = new CustomAnnotationSerializer(false, false);
            FileInputStream is = new FileInputStream(loadFile);
            Pair<Annotation, InputStream> pair = ser.read(is);
            ((InputStream)pair.second).close();
            Annotation anno = (Annotation)pair.first;
            System.out.println(anno.toShorterString(StringUtils.EMPTY_STRING_ARRAY));
            ((InputStream)is).close();
        } else if (file != null && !file.equals("")) {
            String text = IOUtils.slurpFile(file);
            Annotation doc = new Annotation(text);
            pipeline.annotate(doc);
            CustomAnnotationSerializer ser = new CustomAnnotationSerializer(false, false);
            PrintStream os = new PrintStream(new FileOutputStream(file + ".ser"));
            ser.write(doc, os).close();
            log.info("Serialized annotation saved in " + file + ".ser");
        } else {
            log.info("usage: CustomAnnotationSerializer [-file file] [-loadFile file]");
        }
    }
}

