/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.lang.ref.SoftReference;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;

public class AnnotatorPool {
    private static Redwood.RedwoodChannels log = Redwood.channels(AnnotatorPool.class);
    private static final Map<Pair<String, String>, SoftReference<Annotator>> cache = Generics.newHashMap();
    private static final IdentityHashMap<Annotator, Long> annotatorsForcedAlive = new IdentityHashMap();
    private static final Timer gc = new Timer(true){
        {
            this.scheduleAtFixedRate(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Iterator iter;
                    int actionsTaken = 0;
                    long initialMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
                    Map map = annotatorsForcedAlive;
                    synchronized (map) {
                        iter = annotatorsForcedAlive.entrySet().iterator();
                        while (iter.hasNext()) {
                            if ((Long)iter.next().getValue() >= System.currentTimeMillis() - 600000L) continue;
                            ++actionsTaken;
                            iter.remove();
                        }
                    }
                    map = cache;
                    synchronized (map) {
                        iter = cache.entrySet().iterator();
                        while (iter.hasNext()) {
                            Map.Entry entry = iter.next();
                            if (((SoftReference)entry.getValue()).get() != null) continue;
                            ++actionsTaken;
                            iter.remove();
                        }
                    }
                    long finalMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
                    if (actionsTaken > 0) {
                        Runtime.getRuntime().gc();
                        log.info("Annotator GC run. References cleaned=" + actionsTaken + "; Memory: " + initialMemory + " MB  ->  " + finalMemory + " MB");
                        Map map2 = cache;
                        synchronized (map2) {
                            log.info("Annotators in cache: " + cache.size());
                        }
                        map2 = annotatorsForcedAlive;
                        synchronized (map2) {
                            log.info("Annotators forced alive: " + annotatorsForcedAlive.size());
                        }
                    }
                }
            }, 0L, 30000L);
        }
    };
    private final Map<String, AnnotatorFactory> factories = Generics.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean register(String name, AnnotatorFactory factory) {
        boolean newAnnotator = false;
        Map<String, AnnotatorFactory> map = this.factories;
        synchronized (map) {
            if (this.factories.containsKey(name)) {
                String newSig;
                AnnotatorFactory oldFactory = this.factories.get(name);
                String oldSig = oldFactory.signature();
                if (!oldSig.equals(newSig = factory.signature())) {
                    log.info("Replacing old annotator \"" + name + "\" with signature [" + oldSig + "] with new annotator with signature [" + newSig + "]");
                    this.factories.put(name, factory);
                    newAnnotator = true;
                }
            } else {
                this.factories.put(name, factory);
            }
        }
        return newAnnotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Annotator get(String name) {
        Optional<Object> annotator;
        AnnotatorFactory factory;
        Map<String, AnnotatorFactory> map = this.factories;
        synchronized (map) {
            factory = this.factories.get(name);
        }
        if (factory == null) {
            throw new IllegalArgumentException("No annotator named " + name);
        }
        Pair<String, String> key = Pair.makePair(name, factory.signature());
        Map<Pair<String, String>, SoftReference<Annotator>> map2 = cache;
        synchronized (map2) {
            annotator = Optional.ofNullable(cache.get(key)).flatMap(x -> Optional.ofNullable(x.get()));
        }
        if (!annotator.isPresent()) {
            annotator = Optional.of(factory.create());
        }
        map2 = cache;
        synchronized (map2) {
            cache.put(key, new SoftReference<Object>(annotator.orElse(null)));
        }
        if (annotator.isPresent()) {
            return (Annotator)annotator.get();
        }
        throw new IllegalStateException("Logic error in AnnotatorPool#get()");
    }
}

