/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.Factory;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.Properties;

public abstract class AnnotatorFactory
implements Factory<Annotator> {
    private static final long serialVersionUID = -1554647325549869340L;
    private final String name;
    private final String type;
    protected final Properties properties;

    protected AnnotatorFactory(String name, String type, Properties properties) {
        this.name = name;
        this.type = type;
        this.properties = new Properties();
        for (String key : properties.stringPropertyNames()) {
            this.properties.setProperty(key, properties.getProperty(key));
        }
    }

    protected AnnotatorFactory(String name, Class<? extends Annotator> type, Properties properties) {
        this(name, type.getName(), properties);
    }

    @Override
    public abstract Annotator create();

    protected String additionalSignature() {
        return "";
    }

    public String signature() {
        return this.type + '#' + PropertiesUtils.getSignature(this.name, this.properties) + "#" + this.additionalSignature();
    }

    static String baseSignature(Properties props, String name) {
        String prefix = name + '.';
        StringBuilder signature = new StringBuilder();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            signature.append(key).append('=').append(props.getProperty(key)).append('\n');
        }
        return signature.toString();
    }
}

