/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotator;
import edu.stanford.nlp.naturalli.OpenIE;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.ColumnDataClassifierAnnotator;
import edu.stanford.nlp.pipeline.CorefAnnotator;
import edu.stanford.nlp.pipeline.DependencyParseAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.GenderAnnotator;
import edu.stanford.nlp.pipeline.KBPAnnotator;
import edu.stanford.nlp.pipeline.MentionAnnotator;
import edu.stanford.nlp.pipeline.MorphaAnnotator;
import edu.stanford.nlp.pipeline.NERCombinerAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.QuoteAnnotator;
import edu.stanford.nlp.pipeline.RegexNERAnnotator;
import edu.stanford.nlp.pipeline.RelationExtractorAnnotator;
import edu.stanford.nlp.pipeline.SentimentAnnotator;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.TokenizerAnnotator;
import edu.stanford.nlp.pipeline.TrueCaseAnnotator;
import edu.stanford.nlp.pipeline.UDFeatureAnnotator;
import edu.stanford.nlp.pipeline.WikidictAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class AnnotatorFactories {
    private AnnotatorFactories() {
    }

    public static AnnotatorFactory tokenize(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("tokenize", TokenizerAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String nlsbString;
                WordToSentenceProcessor.NewlineIsSentenceBreak nlsb;
                String extraOptions = null;
                boolean keepNewline = Boolean.valueOf(this.properties.getProperty("ssplit.eolonly", "false"));
                String hasSsplit = this.properties.getProperty("annotators");
                if (hasSsplit != null && hasSsplit.contains("ssplit") && !Boolean.parseBoolean(this.properties.getProperty("ssplit.isOneSentence")) && (nlsb = WordToSentenceProcessor.stringToNewlineIsSentenceBreak(nlsbString = this.properties.getProperty("ssplit.newlineIsSentenceBreak", "never"))) != WordToSentenceProcessor.NewlineIsSentenceBreak.NEVER) {
                    keepNewline = true;
                }
                if (keepNewline) {
                    extraOptions = "tokenizeNLs,";
                }
                return annotatorImplementation.tokenizer(this.properties, false, extraOptions);
            }

            @Override
            public String additionalSignature() {
                StringBuilder os = new StringBuilder();
                if (Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    os.append("ssplit.eolonly:");
                    os.append(this.properties.getProperty("ssplit.eolonly", "false"));
                } else {
                    os.append("ssplit.eolonly:");
                    os.append(this.properties.getProperty("ssplit.eolonly", "false"));
                    os.append("ssplit.isOneSentence:");
                    os.append(this.properties.getProperty("ssplit.isOneSentence", "false"));
                    os.append("ssplit.newlineIsSentenceBreak:");
                    os.append(this.properties.getProperty("ssplit.newlineIsSentenceBreak", "never"));
                }
                return os.toString();
            }
        };
    }

    public static AnnotatorFactory cleanXML(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("cleanxml", CleanXmlAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String xmlTags = this.properties.getProperty("clean.xmltags", ".*");
                String sentenceEndingTags = this.properties.getProperty("clean.sentenceendingtags", "");
                String singleSentenceTags = this.properties.getProperty("clean.singlesentencetags", CleanXmlAnnotator.DEFAULT_SINGLE_SENTENCE_TAGS);
                String allowFlawedString = this.properties.getProperty("clean.allowflawedxml");
                boolean allowFlawed = true;
                if (allowFlawedString != null) {
                    allowFlawed = Boolean.valueOf(allowFlawedString);
                }
                String dateTags = this.properties.getProperty("clean.datetags", "datetime|date");
                String docIdTags = this.properties.getProperty("clean.docIdtags", "docid");
                String docTypeTags = this.properties.getProperty("clean.docTypetags", "doctype");
                String utteranceTurnTags = this.properties.getProperty("clean.turntags", "turn");
                String speakerTags = this.properties.getProperty("clean.speakertags", "speaker");
                String docAnnotations = this.properties.getProperty("clean.docAnnotations", "docID=doc[id],doctype=doc[type],docsourcetype=doctype[source]");
                String tokenAnnotations = this.properties.getProperty("clean.tokenAnnotations", CleanXmlAnnotator.DEFAULT_TOKEN_ANNOTATIONS_PATTERNS);
                String sectionTags = this.properties.getProperty("clean.sectiontags", CleanXmlAnnotator.DEFAULT_SECTION_TAGS);
                String sectionAnnotations = this.properties.getProperty("clean.sectionAnnotations", CleanXmlAnnotator.DEFAULT_SECTION_ANNOTATIONS_PATTERNS);
                String ssplitDiscardTokens = this.properties.getProperty("clean.ssplitDiscardTokens");
                CleanXmlAnnotator annotator = annotatorImplementation.cleanXML(this.properties, xmlTags, sentenceEndingTags, dateTags, allowFlawed);
                annotator.setSingleSentenceTagMatcher(singleSentenceTags);
                annotator.setDocIdTagMatcher(docIdTags);
                annotator.setDocTypeTagMatcher(docTypeTags);
                annotator.setDiscourseTags(utteranceTurnTags, speakerTags);
                annotator.setDocAnnotationPatterns(docAnnotations);
                annotator.setTokenAnnotationPatterns(tokenAnnotations);
                annotator.setSectionTagMatcher(sectionTags);
                annotator.setSectionAnnotationPatterns(sectionAnnotations);
                annotator.setSsplitDiscardTokensMatcher(ssplitDiscardTokens);
                return annotator;
            }
        };
    }

    public static AnnotatorFactory sentenceSplit(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("ssplit", WordsToSentencesAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                boolean nlSplitting = Boolean.valueOf(this.properties.getProperty("ssplit.eolonly", "false"));
                if (nlSplitting) {
                    boolean whitespaceTokenization = Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false"));
                    if (whitespaceTokenization) {
                        if (System.lineSeparator().equals("\n")) {
                            return WordsToSentencesAnnotator.newlineSplitter("\n");
                        }
                        return WordsToSentencesAnnotator.newlineSplitter(System.lineSeparator(), "\n");
                    }
                    return WordsToSentencesAnnotator.newlineSplitter(PTBTokenizer.getNewlineToken());
                }
                String isOneSentence = this.properties.getProperty("ssplit.isOneSentence");
                if (Boolean.parseBoolean(isOneSentence)) {
                    return WordsToSentencesAnnotator.nonSplitter();
                }
                String boundaryMultiTokenRegex = this.properties.getProperty("ssplit.boundaryMultiTokenRegex");
                String tokenPatternsToDiscardProp = this.properties.getProperty("ssplit.tokenPatternsToDiscard");
                Set<String> tokenRegexesToDiscard = null;
                if (tokenPatternsToDiscardProp != null) {
                    String[] toks = tokenPatternsToDiscardProp.split(",");
                    tokenRegexesToDiscard = Generics.newHashSet(Arrays.asList(toks));
                }
                String boundaryTokenRegex = this.properties.getProperty("ssplit.boundaryTokenRegex");
                Set<String> boundariesToDiscard = null;
                String bounds = this.properties.getProperty("ssplit.boundariesToDiscard");
                if (bounds != null) {
                    String[] toks = bounds.split(",");
                    boundariesToDiscard = Generics.newHashSet(Arrays.asList(toks));
                }
                Set<String> htmlElementsToDiscard = null;
                bounds = this.properties.getProperty("ssplit.htmlBoundariesToDiscard");
                if (bounds != null) {
                    String[] elements = bounds.split(",");
                    htmlElementsToDiscard = Generics.newHashSet(Arrays.asList(elements));
                }
                String nlsb = this.properties.getProperty("ssplit.newlineIsSentenceBreak", "never");
                return annotatorImplementation.wordToSentences(this.properties, false, boundaryTokenRegex, boundariesToDiscard, htmlElementsToDiscard, nlsb, boundaryMultiTokenRegex, tokenRegexesToDiscard);
            }

            @Override
            public String additionalSignature() {
                StringBuilder os = new StringBuilder();
                if (Boolean.valueOf(this.properties.getProperty("ssplit.eolonly", "false")).booleanValue()) {
                    os.append("ssplit.eolonly=").append(this.properties.getProperty("ssplit.eolonly", "false")).append('\n');
                    os.append("tokenize.whitespace=").append(this.properties.getProperty("tokenize.whitespace", "false")).append('\n');
                } else {
                    os.append(3.baseSignature(this.properties, "ssplit"));
                }
                return os.toString();
            }
        };
    }

    public static AnnotatorFactory posTag(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("pos", POSTaggerAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    return annotatorImplementation.posTagger(this.properties);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static AnnotatorFactory lemma(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("lemma", MorphaAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.morpha(this.properties, false);
            }
        };
    }

    public static AnnotatorFactory nerTag(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("ner", NERCombinerAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    return annotatorImplementation.ner(this.properties);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }

            @Override
            public String additionalSignature() {
                String sutimeSig;
                boolean useSUTime = Boolean.parseBoolean(this.properties.getProperty("ner.useSUTime", Boolean.toString(NumberSequenceClassifier.USE_SUTIME_DEFAULT)));
                String nerSig = "";
                if (useSUTime && !(sutimeSig = PropertiesUtils.getSignature("sutime", this.properties)).isEmpty()) {
                    nerSig = nerSig + sutimeSig;
                }
                return nerSig;
            }
        };
    }

    public static AnnotatorFactory regexNER(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("regexner", RegexNERAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.tokensRegexNER(this.properties, "regexner");
            }
        };
    }

    public static AnnotatorFactory entityMentions(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("entitymentions", EntityMentionsAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.mentions(this.properties, "entitymentions");
            }
        };
    }

    public static AnnotatorFactory gender(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("gender", GenderAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.gender(this.properties, false);
            }
        };
    }

    public static AnnotatorFactory truecase(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("truecase", TrueCaseAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.trueCase(this.properties);
            }
        };
    }

    public static AnnotatorFactory parse(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("parse", ParserAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.parse(this.properties);
            }

            @Override
            public String additionalSignature() {
                if (StanfordCoreNLP.usesBinaryTrees(this.properties) || PropertiesUtils.getBool(this.properties, "parse.binaryTrees", false)) {
                    return "parse.binaryTrees=true";
                }
                return "";
            }
        };
    }

    public static AnnotatorFactory mention(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("mention", MentionAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.mention(this.properties);
            }

            @Override
            public String additionalSignature() {
                return "coref.md:" + this.properties.getProperty("coref.md.type", "rule") + ";" + "coref.language:" + this.properties.getProperty("coref.language", "en");
            }
        };
    }

    public static AnnotatorFactory coref(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("coref", CorefAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.coref(this.properties);
            }
        };
    }

    public static AnnotatorFactory dcoref(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("dcoref", DeterministicCorefAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.dcoref(this.properties);
            }
        };
    }

    public static AnnotatorFactory relation(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("relation", RelationExtractorAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.relations(this.properties);
            }

            @Override
            public String additionalSignature() {
                return "sup.relation.verbose:" + this.properties.getProperty("sup.relation.verbose", "false") + this.properties.getProperty("sup.relation.model", "edu/stanford/nlp/models/supervised_relation_extractor/roth_relation_model_pipelineNER.ser");
            }
        };
    }

    public static AnnotatorFactory sentiment(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory("sentiment", SentimentAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.sentiment(this.properties, "sentiment");
            }
        };
    }

    public static AnnotatorFactory columnDataClassifier(Properties properties, AnnotatorImplementations annotatorImpls) {
        return new AnnotatorFactory("cdc", ColumnDataClassifierAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                if (this.properties.containsKey("classify.loadClassifier")) {
                    this.properties.setProperty("loadClassifier", this.properties.getProperty("classify.loadClassifier"));
                }
                if (!this.properties.containsKey("loadClassifier")) {
                    throw new RuntimeException("Must load a classifier when creating a column data classifier annotator");
                }
                return new ColumnDataClassifierAnnotator(this.properties);
            }

            @Override
            protected String additionalSignature() {
                return "classifier=" + this.properties.getProperty("loadClassifier=" + this.properties.getProperty("loadClassifier"));
            }
        };
    }

    public static AnnotatorFactory dependencies(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory("depparse", DependencyParseAnnotator.class, properties){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImpl.dependencies(this.properties);
            }
        };
    }

    public static AnnotatorFactory natlog(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory("natlog", NaturalLogicAnnotator.class, properties){
            private static final long serialVersionUID = 4825870963088507811L;

            @Override
            public Annotator create() {
                return annotatorImpl.natlog(this.properties);
            }
        };
    }

    public static AnnotatorFactory openie(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory("openie", OpenIE.class, properties){
            private static final long serialVersionUID = -2525567112379296672L;

            @Override
            public Annotator create() {
                return annotatorImpl.openie(this.properties);
            }
        };
    }

    public static AnnotatorFactory quote(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory("quote", QuoteAnnotator.class, properties){
            private static final long serialVersionUID = -2525567112379296672L;

            @Override
            public Annotator create() {
                return annotatorImpl.quote(this.properties);
            }
        };
    }

    public static AnnotatorFactory udfeats(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory("udfeats", UDFeatureAnnotator.class, properties){
            private static final long serialVersionUID = -2525567112379296672L;

            @Override
            public Annotator create() {
                return annotatorImpl.udfeats(this.properties);
            }
        };
    }

    public static AnnotatorFactory kbp(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory("kbp", KBPAnnotator.class, properties){
            private static final long serialVersionUID = -2525567112379296672L;

            @Override
            public Annotator create() {
                return annotatorImpl.kbp(this.properties);
            }
        };
    }

    public static AnnotatorFactory link(Properties properties, final AnnotatorImplementations annotatorImplementations) {
        return new AnnotatorFactory("entitylink", WikidictAnnotator.class, properties){
            private static final long serialVersionUID = 42L;

            @Override
            public Annotator create() {
                return annotatorImplementations.link(this.properties);
            }
        };
    }
}

