/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.ConstantsAndVariables;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.Pattern;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PhraseScorer;
import edu.stanford.nlp.patterns.ScorePhrasesAverageFeatures;
import edu.stanford.nlp.patterns.dep.ApplyDepPatterns;
import edu.stanford.nlp.patterns.surface.ApplyPatterns;
import edu.stanford.nlp.patterns.surface.PatternsForEachToken;
import edu.stanford.nlp.semgraph.semgrex.Env;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.stats.TwoDimensionalCounter;
import edu.stanford.nlp.stats.TwoDimensionalCounterInterface;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class ScorePhrases<E extends Pattern> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ScorePhrases.class);
    Map<String, Boolean> writtenInJustification = new HashMap<String, Boolean>();
    ConstantsAndVariables constVars = null;
    @ArgumentParser.Option(name="phraseScorerClass")
    Class<? extends PhraseScorer> phraseScorerClass = ScorePhrasesAverageFeatures.class;
    PhraseScorer phraseScorer = null;

    public ScorePhrases(Properties props, ConstantsAndVariables cv) {
        ArgumentParser.fillOptions((Object)this, props);
        this.constVars = cv;
        try {
            this.phraseScorer = this.phraseScorerClass.getConstructor(ConstantsAndVariables.class).newInstance(this.constVars);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ArgumentParser.fillOptions((Object)this.phraseScorer, props);
    }

    public Counter<CandidatePhrase> chooseTopWords(Counter<CandidatePhrase> newdt, TwoDimensionalCounter<CandidatePhrase, E> terms, Counter<CandidatePhrase> useThresholdNumPatternsForTheseWords, Set<CandidatePhrase> ignoreWords, double thresholdWordExtract) {
        Iterator termIter = Counters.toPriorityQueue(newdt).iterator();
        ClassicCounter<CandidatePhrase> finalwords = new ClassicCounter<CandidatePhrase>();
        while (termIter.hasNext() && finalwords.size() < this.constVars.numWordsToAdd) {
            CandidatePhrase w = (CandidatePhrase)termIter.next();
            if (newdt.getCount(w) < thresholdWordExtract) {
                Redwood.log(ConstantsAndVariables.extremedebug, "not adding word " + w + " and any later words because the score " + newdt.getCount(w) + " is less than the threshold of  " + thresholdWordExtract);
                break;
            }
            assert (newdt.getCount(w) != Double.POSITIVE_INFINITY);
            if (useThresholdNumPatternsForTheseWords.containsKey(w) && this.numNonRedundantPatterns(terms, w) < this.constVars.thresholdNumPatternsApplied) {
                Redwood.log("extremePatDebug", "Not adding " + w + " because the number of non redundant patterns are below threshold of " + this.constVars.thresholdNumPatternsApplied + ":" + ((ClassicCounter)terms.getCounter((Object)w)).keySet());
                continue;
            }
            CandidatePhrase matchedFuzzy = null;
            if (this.constVars.minLen4FuzzyForPattern > 0 && ignoreWords != null) {
                matchedFuzzy = ConstantsAndVariables.containsFuzzy(ignoreWords, w, this.constVars.minLen4FuzzyForPattern);
            }
            if (matchedFuzzy == null) {
                Redwood.log("extremePatDebug", "adding word " + w);
                finalwords.setCount(w, newdt.getCount(w));
                continue;
            }
            Redwood.log("extremePatDebug", "not adding " + w + " because it matched " + matchedFuzzy + " in common English word");
            ignoreWords.add(w);
        }
        String nextTen = "";
        int n = 0;
        while (termIter.hasNext() && ++n <= 10) {
            CandidatePhrase w = (CandidatePhrase)termIter.next();
            nextTen = nextTen + ";\t" + w + ":" + newdt.getCount(w);
        }
        Redwood.log(new Object[]{Redwood.DBG, "Next ten phrases were " + nextTen});
        return finalwords;
    }

    public static <E, F> void removeKeys(TwoDimensionalCounter<E, F> counter, Collection<E> removeKeysCollection) {
        for (E key : removeKeysCollection) {
            counter.remove(key);
        }
    }

    private double numNonRedundantPatterns(TwoDimensionalCounter<CandidatePhrase, E> terms, CandidatePhrase w) {
        Object[] pats = ((ClassicCounter)terms.getCounter((Object)w)).keySet().toArray();
        int numPat = 0;
        for (int i = 0; i < pats.length; ++i) {
            String pati = pats[i].toString();
            boolean contains = false;
            for (int j = i + 1; j < pats.length; ++j) {
                String patj = pats[j].toString();
                if (!patj.contains(pati) && !pati.contains(patj)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            ++numPat;
        }
        return numPat;
    }

    public Counter<CandidatePhrase> learnNewPhrases(String label, PatternsForEachToken patternsForEachToken, Counter<E> patternsLearnedThisIter, Counter<E> allSelectedPatterns, CollectionValuedMap<E, Triple<String, Integer, Integer>> tokensMatchedPatterns, Counter<CandidatePhrase> scoreForAllWordsThisIteration, TwoDimensionalCounter<CandidatePhrase, E> terms, TwoDimensionalCounter<CandidatePhrase, E> wordsPatExtracted, TwoDimensionalCounter<E, CandidatePhrase> patternsAndWords4Label, String identifier, Set<CandidatePhrase> ignoreWords) throws IOException, ClassNotFoundException {
        boolean computeProcDataFreq = false;
        if (Data.processedDataFreq == null) {
            computeProcDataFreq = true;
            Data.processedDataFreq = new ClassicCounter<CandidatePhrase>();
            assert (Data.rawFreq != null);
        }
        HashSet<CandidatePhrase> alreadyIdentifiedWords = new HashSet<CandidatePhrase>(this.constVars.getLearnedWords(label).keySet());
        alreadyIdentifiedWords.addAll((Collection<CandidatePhrase>)this.constVars.getSeedLabelDictionary().get(label));
        Counter<CandidatePhrase> words = this.learnNewPhrasesPrivate(label, patternsForEachToken, patternsLearnedThisIter, allSelectedPatterns, alreadyIdentifiedWords, tokensMatchedPatterns, scoreForAllWordsThisIteration, terms, wordsPatExtracted, patternsAndWords4Label, identifier, ignoreWords, computeProcDataFreq);
        return words;
    }

    /*
     * WARNING - void declaration
     */
    void runParallelApplyPats(Map<String, DataInstance> sents, String label, E pattern, TwoDimensionalCounter<CandidatePhrase, E> wordsandLemmaPatExtracted, CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat, Set<CandidatePhrase> alreadyLabeledWords) {
        Redwood.log(new Object[]{Redwood.DBG, "Applying pattern " + pattern + " to a total of " + sents.size() + " sentences "});
        ArrayList<String> notAllowedClasses = new ArrayList<String>();
        List<String> sentids = CollectionUtils.toList(sents.keySet());
        if (this.constVars.doNotExtractPhraseAnyWordLabeledOtherClass) {
            for (String l : this.constVars.getAnswerClass().keySet()) {
                if (l.equals(label)) continue;
                notAllowedClasses.add(l);
            }
            notAllowedClasses.add("OTHERSEM");
        }
        HashMap<TokenSequencePattern, E> surfacePatternsLearnedThisIterConverted = null;
        HashMap<SemgrexPattern, E> depPatternsLearnedThisIterConverted = null;
        if (this.constVars.patternType.equals((Object)PatternFactory.PatternType.SURFACE)) {
            surfacePatternsLearnedThisIterConverted = new HashMap<TokenSequencePattern, E>();
            String patternStr = null;
            try {
                patternStr = ((Pattern)pattern).toString(notAllowedClasses);
                TokenSequencePattern pat = TokenSequencePattern.compile(this.constVars.env.get(label), patternStr);
                surfacePatternsLearnedThisIterConverted.put(pat, pattern);
            }
            catch (Exception e) {
                log.info("Error applying patterrn " + patternStr + ". Probably an ill formed pattern (can be because of special symbols in label names). Contact the software developer.");
                throw e;
            }
        } else if (this.constVars.patternType.equals((Object)PatternFactory.PatternType.DEP)) {
            depPatternsLearnedThisIterConverted = new HashMap<SemgrexPattern, E>();
            SemgrexPattern pat = SemgrexPattern.compile(((Pattern)pattern).toString(notAllowedClasses), new Env(this.constVars.env.get(label).getVariables()));
            depPatternsLearnedThisIterConverted.put(pat, pattern);
        } else {
            throw new UnsupportedOperationException();
        }
        int numThreads = this.constVars.numThreads;
        if (sents.size() < 50) {
            numThreads = 1;
        }
        int num = numThreads == 1 ? sents.size() : sents.size() / (numThreads - 1);
        ExecutorService executor = Executors.newFixedThreadPool(this.constVars.numThreads);
        ArrayList list = new ArrayList();
        for (int i = 0; i < numThreads; ++i) {
            void var16_20;
            Object var16_21 = null;
            if (((Pattern)pattern).type.equals((Object)PatternFactory.PatternType.SURFACE)) {
                ApplyPatterns applyPatterns = new ApplyPatterns(sents, num == sents.size() ? sentids : sentids.subList(i * num, Math.min(sentids.size(), (i + 1) * num)), surfacePatternsLearnedThisIterConverted, label, this.constVars.removeStopWordsFromSelectedPhrases, this.constVars.removePhrasesWithStopWords, this.constVars);
            } else {
                ApplyDepPatterns applyDepPatterns = new ApplyDepPatterns(sents, num == sents.size() ? sentids : sentids.subList(i * num, Math.min(sentids.size(), (i + 1) * num)), depPatternsLearnedThisIterConverted, label, this.constVars.removeStopWordsFromSelectedPhrases, this.constVars.removePhrasesWithStopWords, this.constVars);
            }
            Future submit = executor.submit(var16_20);
            list.add(submit);
        }
        for (Future future : list) {
            try {
                Triple result = (Triple)future.get();
                Redwood.log(ConstantsAndVariables.extremedebug, "Pattern " + pattern + " extracted phrases " + result.first());
                wordsandLemmaPatExtracted.addAll((TwoDimensionalCounterInterface)result.first());
                matchedTokensByPat.addAll((CollectionValuedMap)result.second());
                alreadyLabeledWords.addAll((Collection)result.third());
            }
            catch (Exception e) {
                executor.shutdownNow();
                throw new RuntimeException(e);
            }
        }
        executor.shutdown();
    }

    protected Map<E, Map<String, DataInstance>> getSentences(Map<E, Set<String>> sentids) {
        try {
            HashSet<File> files = new HashSet<File>();
            HashMap sentsAll = new HashMap();
            CollectionValuedMap<String, E> sentIds2Pats = new CollectionValuedMap<String, E>();
            for (Map.Entry<E, Set<String>> entry : sentids.entrySet()) {
                if (!sentsAll.containsKey(entry.getKey())) {
                    sentsAll.put(entry.getKey(), new HashMap());
                }
                for (String string : entry.getValue()) {
                    sentIds2Pats.add(string, entry.getKey());
                    if (!this.constVars.batchProcessSents) continue;
                    File file = Data.sentId2File.get(string);
                    assert (file != null) : "How come no file for sentence " + string;
                    files.add(file);
                }
            }
            if (this.constVars.batchProcessSents) {
                for (File file : files) {
                    Map sentsf = (Map)IOUtils.readObjectFromFile(file);
                    for (Map.Entry entry : sentsf.entrySet()) {
                        Iterator iterator = sentIds2Pats.get(entry.getKey()).iterator();
                        while (iterator.hasNext()) {
                            Pattern pat = (Pattern)iterator.next();
                            ((Map)sentsAll.get(pat)).put(entry.getKey(), entry.getValue());
                        }
                    }
                }
            } else {
                for (Map.Entry<Object, Object> entry : Data.sents.entrySet()) {
                    Iterator<String> iterator = sentIds2Pats.get(entry.getKey()).iterator();
                    while (iterator.hasNext()) {
                        Pattern pattern = (Pattern)((Object)iterator.next());
                        ((Map)sentsAll.get(pattern)).put(entry.getKey(), entry.getValue());
                    }
                }
            }
            return sentsAll;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
    }

    public void applyPats(Counter<E> patterns, String label, TwoDimensionalCounter<CandidatePhrase, E> wordsandLemmaPatExtracted, CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat, Set<CandidatePhrase> alreadyLabeledWords) {
        for (Map.Entry<String, edu.stanford.nlp.ling.tokensregex.Env> en : this.constVars.env.entrySet()) {
            en.getValue().getVariables().putAll(ConstantsAndVariables.globalEnv.getVariables());
        }
        Map<E, Map<String, DataInstance>> sentencesForPatterns = this.getSentences(this.constVars.invertedIndex.queryIndex(patterns.keySet()));
        for (Map.Entry<E, Map<String, DataInstance>> en : sentencesForPatterns.entrySet()) {
            this.runParallelApplyPats(en.getValue(), label, (Pattern)en.getKey(), wordsandLemmaPatExtracted, matchedTokensByPat, alreadyLabeledWords);
        }
        Redwood.log(new Object[]{Redwood.DBG, "# words/lemma and pattern pairs are " + wordsandLemmaPatExtracted.size()});
    }

    private void statsWithoutApplyingPatterns(Map<String, DataInstance> sents, PatternsForEachToken patternsForEachToken, Counter<E> patternsLearnedThisIter, TwoDimensionalCounter<CandidatePhrase, E> wordsandLemmaPatExtracted) {
        for (Map.Entry<String, DataInstance> sentEn : sents.entrySet()) {
            Map pat4Sent = patternsForEachToken.getPatternsForAllTokens(sentEn.getKey());
            if (pat4Sent == null) {
                throw new RuntimeException("How come there are no patterns for " + sentEn.getKey());
            }
            for (Map.Entry en : pat4Sent.entrySet()) {
                CoreLabel token = null;
                Set p1 = en.getValue();
                for (Pattern index : patternsLearnedThisIter.keySet()) {
                    if (!p1.contains(index)) continue;
                    if (token == null) {
                        token = sentEn.getValue().getTokens().get(en.getKey());
                    }
                    wordsandLemmaPatExtracted.incrementCount(CandidatePhrase.createOrGet(token.word(), token.lemma()), index);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Counter<CandidatePhrase> learnNewPhrasesPrivate(String label, PatternsForEachToken patternsForEachToken, Counter<E> patternsLearnedThisIter, Counter<E> allSelectedPatterns, Set<CandidatePhrase> alreadyIdentifiedWords, CollectionValuedMap<E, Triple<String, Integer, Integer>> matchedTokensByPat, Counter<CandidatePhrase> scoreForAllWordsThisIteration, TwoDimensionalCounter<CandidatePhrase, E> terms, TwoDimensionalCounter<CandidatePhrase, E> wordsPatExtracted, TwoDimensionalCounter<E, CandidatePhrase> patternsAndWords4Label, String identifier, Set<CandidatePhrase> ignoreWords, boolean computeProcDataFreq) throws IOException, ClassNotFoundException {
        HashSet<CandidatePhrase> alreadyLabeledWords = new HashSet<CandidatePhrase>();
        if (this.constVars.doNotApplyPatterns) {
            Iterator<Pair<Map<String, DataInstance>, File>> sentsIter = new ConstantsAndVariables.DataSentsIterator(this.constVars.batchProcessSents);
            while (((ConstantsAndVariables.DataSentsIterator)sentsIter).hasNext()) {
                Object object = ((ConstantsAndVariables.DataSentsIterator)sentsIter).next();
                this.statsWithoutApplyingPatterns((Map)((Pair)object).first(), patternsForEachToken, patternsLearnedThisIter, wordsPatExtracted);
            }
        } else if (patternsLearnedThisIter.size() > 0) {
            this.applyPats(patternsLearnedThisIter, label, wordsPatExtracted, matchedTokensByPat, alreadyLabeledWords);
        }
        if (computeProcDataFreq) {
            if (!this.phraseScorer.wordFreqNorm.equals((Object)PhraseScorer.Normalization.NONE)) {
                Redwood.log(new Object[]{Redwood.DBG, "computing processed freq"});
                for (Map.Entry entry : Data.rawFreq.entrySet()) {
                    Double in = (Double)entry.getValue();
                    if (this.phraseScorer.wordFreqNorm.equals((Object)PhraseScorer.Normalization.SQRT)) {
                        in = Math.sqrt(in);
                    } else if (this.phraseScorer.wordFreqNorm.equals((Object)PhraseScorer.Normalization.LOG)) {
                        in = 1.0 + Math.log(in);
                    } else {
                        throw new RuntimeException("can't understand the normalization");
                    }
                    assert (!in.isNaN()) : "Why is processed freq nan when rawfreq is " + in;
                    Data.processedDataFreq.setCount((CandidatePhrase)entry.getKey(), in);
                }
            } else {
                Data.processedDataFreq = Data.rawFreq;
            }
        }
        if (this.constVars.wordScoring.equals((Object)GetPatternsFromDataMultiClass.WordScoring.WEIGHTEDNORM)) {
            void var16_23;
            for (CandidatePhrase candidatePhrase : wordsPatExtracted.firstKeySet()) {
                if (this.constVars.getOtherSemanticClassesWords().contains(candidatePhrase) || candidatePhrase.getPhraseLemma() != null && this.constVars.getOtherSemanticClassesWords().contains(CandidatePhrase.createOrGet(candidatePhrase.getPhraseLemma())) || alreadyLabeledWords.contains(candidatePhrase)) continue;
                terms.addAll(candidatePhrase, wordsPatExtracted.getCounter((Object)candidatePhrase));
            }
            ScorePhrases scorePhrases = this;
            ScorePhrases.removeKeys(terms, scorePhrases.constVars.getStopWords());
            Counter<CandidatePhrase> phraseScores = this.phraseScorer.scorePhrases(label, terms, wordsPatExtracted, allSelectedPatterns, alreadyIdentifiedWords, false);
            System.out.println("count for word U.S. is " + phraseScores.getCount(CandidatePhrase.createOrGet("U.S.")));
            if (ignoreWords != null && !ignoreWords.isEmpty()) {
                Set<CandidatePhrase> set = CollectionUtils.unionAsSet(ignoreWords, this.constVars.getOtherSemanticClassesWords());
            } else {
                HashSet<CandidatePhrase> hashSet = new HashSet<CandidatePhrase>(this.constVars.getOtherSemanticClassesWords());
            }
            var16_23.addAll((Collection)this.constVars.getSeedLabelDictionary().get(label));
            var16_23.addAll(this.constVars.getLearnedWords(label).keySet());
            System.out.println("ignoreWordsAll contains word U.S. is " + var16_23.contains(CandidatePhrase.createOrGet("U.S.")));
            Counter<CandidatePhrase> finalwords = this.chooseTopWords(phraseScores, terms, phraseScores, (Set<CandidatePhrase>)var16_23, this.constVars.thresholdWordExtract);
            this.phraseScorer.printReasonForChoosing(finalwords);
            scoreForAllWordsThisIteration.clear();
            Counters.addInPlace(scoreForAllWordsThisIteration, phraseScores);
            Redwood.log(ConstantsAndVariables.minimaldebug, "\n\n## Selected Words for " + label + " : " + Counters.toSortedString(finalwords, finalwords.size(), "%1$s:%2$.2f", "\t"));
            if (this.constVars.goldEntities != null) {
                Map<String, Boolean> goldEntities4Label = this.constVars.goldEntities.get(label);
                if (goldEntities4Label != null) {
                    StringBuffer s = new StringBuffer();
                    finalwords.keySet().stream().forEach(x -> s.append(x.getPhrase() + (goldEntities4Label.containsKey(x.getPhrase()) ? ":" + goldEntities4Label.get(x.getPhrase()) : ":UKNOWN") + "\n"));
                    Redwood.log(ConstantsAndVariables.minimaldebug, "\n\n## Gold labels for selected words for label " + label + " : " + s.toString());
                } else {
                    Redwood.log(new Object[]{Redwood.DBG, "No gold entities provided for label " + label});
                }
            }
            if (this.constVars.outDir != null && !this.constVars.outDir.isEmpty()) {
                String outputdir = this.constVars.outDir + "/" + identifier + "/" + label;
                IOUtils.ensureDir(new File(outputdir));
                TwoDimensionalCounter<CandidatePhrase, CandidatePhrase> reasonForWords = new TwoDimensionalCounter<CandidatePhrase, CandidatePhrase>();
                for (CandidatePhrase word : finalwords.keySet()) {
                    for (Pattern l : ((ClassicCounter)wordsPatExtracted.getCounter((Object)word)).keySet()) {
                        Iterator iterator = ((ClassicCounter)patternsAndWords4Label.getCounter(l)).iterator();
                        while (iterator.hasNext()) {
                            CandidatePhrase w2 = (CandidatePhrase)iterator.next();
                            reasonForWords.incrementCount(word, w2);
                        }
                    }
                }
                Redwood.log(ConstantsAndVariables.minimaldebug, "Saving output in " + (String)outputdir);
                String filename = (String)outputdir + "/words.json";
                JsonArrayBuilder obj = Json.createArrayBuilder();
                if (this.writtenInJustification.containsKey(label) && this.writtenInJustification.get(label).booleanValue()) {
                    JsonReader jsonReader = Json.createReader((InputStream)new BufferedInputStream(new FileInputStream(filename)));
                    JsonArray objarr = jsonReader.readArray();
                    for (JsonValue o : objarr) {
                        obj.add(o);
                    }
                    jsonReader.close();
                }
                JsonArrayBuilder objThisIter = Json.createArrayBuilder();
                for (CandidatePhrase w : reasonForWords.firstKeySet()) {
                    JsonObjectBuilder objinner = Json.createObjectBuilder();
                    JsonArrayBuilder l = Json.createArrayBuilder();
                    for (CandidatePhrase w2 : ((ClassicCounter)reasonForWords.getCounter((Object)w)).keySet()) {
                        l.add(w2.getPhrase());
                    }
                    JsonArrayBuilder pats = Json.createArrayBuilder();
                    Iterator iterator = ((ClassicCounter)wordsPatExtracted.getCounter((Object)w)).iterator();
                    while (iterator.hasNext()) {
                        Pattern p = (Pattern)iterator.next();
                        pats.add(p.toStringSimple());
                    }
                    objinner.add("reasonwords", l);
                    objinner.add("patterns", pats);
                    objinner.add("score", finalwords.getCount(w));
                    objinner.add("entity", w.getPhrase());
                    objThisIter.add((JsonValue)objinner.build());
                }
                obj.add(objThisIter);
                IOUtils.writeStringToFile(StringUtils.normalize(StringUtils.toAscii(obj.build().toString())), filename, "ASCII");
                this.writtenInJustification.put(label, true);
            }
            if (this.constVars.justify) {
                Redwood.log(new Object[]{Redwood.DBG, "\nJustification for phrases:\n"});
                for (CandidatePhrase word : finalwords.keySet()) {
                    Redwood.log(new Object[]{Redwood.DBG, "Phrase " + word + " extracted because of patterns: \t" + Counters.toSortedString(wordsPatExtracted.getCounter((Object)word), ((ClassicCounter)wordsPatExtracted.getCounter((Object)word)).size(), "%1$s:%2$f", "\n")});
                }
            }
            return finalwords;
        }
        if (this.constVars.wordScoring.equals((Object)GetPatternsFromDataMultiClass.WordScoring.BPB)) {
            Counters.addInPlace(terms, wordsPatExtracted);
            ClassicCounter<CandidatePhrase> maxPatWeightTerms = new ClassicCounter<CandidatePhrase>();
            HashMap hashMap = new HashMap();
            for (Map.Entry<CandidatePhrase, ClassicCounter<E>> en : terms.entrySet()) {
                ClassicCounter<Pattern> weights = new ClassicCounter<Pattern>();
                for (Pattern k : en.getValue().keySet()) {
                    weights.setCount(k, patternsLearnedThisIter.getCount(k));
                }
                maxPatWeightTerms.setCount(en.getKey(), Counters.max(weights));
                hashMap.put(en.getKey(), Counters.argmax(weights));
            }
            Counters.removeKeys(maxPatWeightTerms, alreadyIdentifiedWords);
            double maxvalue = Counters.max(maxPatWeightTerms);
            Set<CandidatePhrase> words = Counters.keysAbove(maxPatWeightTerms, maxvalue - 1.0E-10);
            CandidatePhrase bestw = null;
            if (words.size() > 1) {
                double max = Double.NEGATIVE_INFINITY;
                for (CandidatePhrase w : words) {
                    if (!(terms.getCount(w, hashMap.get(w)) > max)) continue;
                    max = terms.getCount(w, hashMap.get(w));
                    bestw = w;
                }
            } else if (words.size() == 1) {
                bestw = words.iterator().next();
            } else {
                return new ClassicCounter<CandidatePhrase>();
            }
            Redwood.log(ConstantsAndVariables.minimaldebug, "Selected Words: " + bestw);
            return Counters.asCounter(Arrays.asList(bestw));
        }
        throw new RuntimeException("wordscoring " + (Object)((Object)this.constVars.wordScoring) + " not identified");
    }

    Counter<String> getLearnedScores() {
        return this.phraseScorer.getLearnedScores();
    }
}

