/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.ling.tokensregex.TokenSequencePattern;
import edu.stanford.nlp.patterns.CandidatePhrase;
import edu.stanford.nlp.patterns.Data;
import edu.stanford.nlp.patterns.DataInstance;
import edu.stanford.nlp.patterns.EditDistanceDamerauLevenshteinLike;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.InvertedIndexByTokens;
import edu.stanford.nlp.patterns.PatternFactory;
import edu.stanford.nlp.patterns.PatternsAnnotations;
import edu.stanford.nlp.patterns.SentenceIndex;
import edu.stanford.nlp.patterns.dep.DepPatternFactory;
import edu.stanford.nlp.patterns.surface.SurfacePatternFactory;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.util.ArgumentParser;
import edu.stanford.nlp.util.EditDistance;
import edu.stanford.nlp.util.GoogleNGramsSQLBacked;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.TypesafeMap;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;

public class ConstantsAndVariables
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ArgumentParser.Option(name="numIterationsForPatterns")
    public Integer numIterationsForPatterns = 10;
    @ArgumentParser.Option(name="numPatterns")
    public int numPatterns = 10;
    @ArgumentParser.Option(name="outDir")
    public String outDir = null;
    @ArgumentParser.Option(name="allPatternsDir")
    public String allPatternsDir = null;
    @ArgumentParser.Option(name="computeAllPatterns")
    public boolean computeAllPatterns = true;
    @ArgumentParser.Option(name="patternScoring")
    public GetPatternsFromDataMultiClass.PatternScoring patternScoring = GetPatternsFromDataMultiClass.PatternScoring.PosNegUnlabOdds;
    @ArgumentParser.Option(name="thresholdSelectPattern")
    public double thresholdSelectPattern = 1.0;
    @ArgumentParser.Option(name="restrictToMatched")
    public boolean restrictToMatched = false;
    @ArgumentParser.Option(name="usePatternResultAsLabel")
    public boolean usePatternResultAsLabel = true;
    @ArgumentParser.Option(name="debug")
    public int debug = 1;
    @ArgumentParser.Option(name="identifier")
    public String identifier = "getpatterns";
    @ArgumentParser.Option(name="useMatchingPhrase")
    public boolean useMatchingPhrase = true;
    @ArgumentParser.Option(name="tuneThresholdKeepRunning")
    public boolean tuneThresholdKeepRunning = false;
    @ArgumentParser.Option(name="maxExtractNumWords")
    public int maxExtractNumWords = Integer.MAX_VALUE;
    @ArgumentParser.Option(name="useOtherLabelsWordsasNegative")
    public boolean useOtherLabelsWordsasNegative = true;
    @ArgumentParser.Option(name="markedOutputTextFile")
    String markedOutputTextFile = null;
    @ArgumentParser.Option(name="columnOutputFile")
    String columnOutputFile = null;
    @ArgumentParser.Option(name="matchLowerCaseContext")
    public static boolean matchLowerCaseContext = true;
    @ArgumentParser.Option(name="targetAllowedTagsInitialsStr")
    public String targetAllowedTagsInitialsStr = null;
    public Map<String, Set<String>> allowedTagsInitials = null;
    @ArgumentParser.Option(name="targetAllowedNERs")
    public String targetAllowedNERs = null;
    public Map<String, Set<String>> allowedNERsforLabels = null;
    @ArgumentParser.Option(name="numWordsToAdd")
    public int numWordsToAdd = 10;
    @ArgumentParser.Option(name="thresholdNumPatternsApplied")
    public double thresholdNumPatternsApplied = 2.0;
    @ArgumentParser.Option(name="wordScoring")
    public GetPatternsFromDataMultiClass.WordScoring wordScoring = GetPatternsFromDataMultiClass.WordScoring.WEIGHTEDNORM;
    @ArgumentParser.Option(name="thresholdWordExtract")
    public double thresholdWordExtract = 0.2;
    public boolean justify = false;
    @ArgumentParser.Option(name="LRSigma")
    public double LRSigma = 1.0;
    @ArgumentParser.Option(name="englishWordsFiles")
    public String englishWordsFiles = null;
    private Set<String> englishWords = new HashSet<String>();
    @ArgumentParser.Option(name="commonWordsPatternFiles")
    public String commonWordsPatternFiles = null;
    private Set<String> commonEngWords = null;
    @ArgumentParser.Option(name="otherSemanticClassesFiles")
    public String otherSemanticClassesFiles = null;
    private Set<CandidatePhrase> otherSemanticClassesWords = null;
    private Map<String, Set<CandidatePhrase>> seedLabelDictionary = new HashMap<String, Set<CandidatePhrase>>();
    private Set<String> labels = new HashSet<String>();
    private Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass = null;
    private Map<String, Map<Class, Object>> ignoreWordswithClassesDuringSelection = null;
    private static Map<String, Class> generalizeClasses = new HashMap<String, Class>();
    @ArgumentParser.Option(name="minLen4FuzzyForPattern")
    public int minLen4FuzzyForPattern = 6;
    @ArgumentParser.Option(name="wordIgnoreRegex")
    public String wordIgnoreRegex = "[^a-zA-Z]*";
    @ArgumentParser.Option(name="numThreads")
    public int numThreads = 1;
    @ArgumentParser.Option(name="stopWordsPatternFiles", gloss="stop words")
    public String stopWordsPatternFiles = null;
    private static Set<CandidatePhrase> stopWords = null;
    public Map<String, Env> env = new HashMap<String, Env>();
    public static Env globalEnv = TokenSequencePattern.getNewEnv();
    @ArgumentParser.Option(name="removeStopWordsFromSelectedPhrases")
    public boolean removeStopWordsFromSelectedPhrases = false;
    @ArgumentParser.Option(name="removePhrasesWithStopWords")
    public boolean removePhrasesWithStopWords = false;
    private boolean alreadySetUp = false;
    @ArgumentParser.Option(name="wordClassClusterFile")
    String wordClassClusterFile = null;
    private Map<String, Integer> wordClassClusters = new HashMap<String, Integer>();
    @ArgumentParser.Option(name="generalWordClassClusterFile")
    String generalWordClassClusterFile = null;
    private Map<String, Integer> generalWordClassClusters = null;
    @ArgumentParser.Option(name="externalFeatureWeightsFile")
    public String externalFeatureWeightsDir = null;
    @ArgumentParser.Option(name="doNotApplyPatterns")
    public boolean doNotApplyPatterns = false;
    @ArgumentParser.Option(name="sqrtPatScore")
    public boolean sqrtPatScore = false;
    @ArgumentParser.Option(name="minUnlabPhraseSupportForPat")
    public int minUnlabPhraseSupportForPat = 0;
    @ArgumentParser.Option(name="minPosPhraseSupportForPat")
    public int minPosPhraseSupportForPat = 1;
    @ArgumentParser.Option(name="addIndvWordsFromPhrasesExceptLastAsNeg")
    public boolean addIndvWordsFromPhrasesExceptLastAsNeg = false;
    private ConcurrentHashMap<String, Double> editDistanceFromEnglishWords = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> editDistanceFromEnglishWordsMatches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Double> editDistanceFromOtherSemanticClasses = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> editDistanceFromOtherSemanticClassesMatches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Double> editDistanceFromThisClass = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> editDistanceFromThisClassMatches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Counter<String>> wordShapesForLabels = new ConcurrentHashMap();
    String channelNameLogger = "settingUp";
    public Map<String, Counter<Integer>> distSimWeights = new HashMap<String, Counter<Integer>>();
    public Map<String, Counter<CandidatePhrase>> dictOddsWeights = new HashMap<String, Counter<CandidatePhrase>>();
    @ArgumentParser.Option(name="invertedIndexClass", gloss="another option is Lucene backed, which is not included in the CoreNLP release. Contact us to get a copy (distributed under Apache License).")
    public Class<? extends SentenceIndex> invertedIndexClass = InvertedIndexByTokens.class;
    @ArgumentParser.Option(name="invertedIndexDirectory")
    public String invertedIndexDirectory;
    @ArgumentParser.Option(name="clubNeighboringLabeledWords")
    public boolean clubNeighboringLabeledWords = false;
    @ArgumentParser.Option(name="patternType")
    public PatternFactory.PatternType patternType = PatternFactory.PatternType.SURFACE;
    @ArgumentParser.Option(name="subsampleUnkAsNegUsingSim", gloss="When learning a classifier, remove phrases from unknown phrases that are too close to the positive phrases")
    public boolean subsampleUnkAsNegUsingSim = false;
    @ArgumentParser.Option(name="expandPositivesWhenSampling", gloss="when sampling for learning feature wts for learning phrases, expand the positives")
    public boolean expandPositivesWhenSampling = false;
    @ArgumentParser.Option(name="expandNegativesWhenSampling", gloss="when sampling for learning feature wts for learning phrases, expand the negatives")
    public boolean expandNegativesWhenSampling = false;
    @ArgumentParser.Option(name="similarityThresholdHighPrecision", gloss="used for expanding positives")
    public double similarityThresholdHighPrecision = 0.7;
    @ArgumentParser.Option(name="positiveSimilarityThresholdLowPrecision", gloss="used for not choosing close unknowns as positives")
    public double positiveSimilarityThresholdLowPrecision = 0.5;
    @ArgumentParser.Option(name="wordVectorFile", gloss="if using word vectors for computing similarities")
    public String wordVectorFile = null;
    @ArgumentParser.Option(name="useWordVectorsToComputeSim", gloss="use vectors directly instead of word classes for computing similarity")
    public boolean useWordVectorsToComputeSim;
    @ArgumentParser.Option(name="logFileVectorSimilarity", gloss="To store vectors for selected/almost-selected positive and negative words")
    String logFileVectorSimilarity = null;
    @ArgumentParser.Option(name="goldEntitiesEvalFiles", gloss="label1,gold_list_of_entities_file;label2,...")
    public String goldEntitiesEvalFiles = null;
    @ArgumentParser.Option(name="evaluate")
    public boolean evaluate = false;
    Map<String, Map<String, Boolean>> goldEntities = new HashMap<String, Map<String, Boolean>>();
    @ArgumentParser.Option(name="featureCountThreshold")
    public int featureCountThreshold = 1;
    @ArgumentParser.Option(name="expandPhrasesNumTopSimilar", gloss="k in kNN")
    public int expandPhrasesNumTopSimilar = 1;
    @ArgumentParser.Option(name="fuzzyMatch")
    public boolean fuzzyMatch = false;
    @ArgumentParser.Option(name="ignoreCaseSeedMatch")
    public Map<String, String> ignoreCaseSeedMatch = new HashMap<String, String>();
    @ArgumentParser.Option(name="sentsOutFile")
    public String sentsOutFile = null;
    @ArgumentParser.Option(name="savePatternsWordsDir")
    public boolean savePatternsWordsDir = true;
    @ArgumentParser.Option(name="learn")
    public boolean learn = true;
    @ArgumentParser.Option(name="removeOverLappingLabelsFromSeed")
    public boolean removeOverLappingLabelsFromSeed = false;
    @ArgumentParser.Option(name="usePhraseEvalWordClass")
    public boolean usePhraseEvalWordClass = false;
    @ArgumentParser.Option(name="usePhraseEvalWordVector")
    public boolean usePhraseEvalWordVector = false;
    @ArgumentParser.Option(name="usePhraseEvalGoogleNgram")
    public boolean usePhraseEvalGoogleNgram = false;
    @ArgumentParser.Option(name="usePhraseEvalDomainNgram")
    public boolean usePhraseEvalDomainNgram = false;
    @ArgumentParser.Option(name="usePhraseEvalPatWtByFreq")
    public boolean usePhraseEvalPatWtByFreq = true;
    @ArgumentParser.Option(name="usePhraseEvalSemanticOdds")
    public boolean usePhraseEvalSemanticOdds = false;
    @ArgumentParser.Option(name="usePhraseEvalEditDistSame")
    public boolean usePhraseEvalEditDistSame = false;
    @ArgumentParser.Option(name="usePhraseEvalEditDistOther")
    public boolean usePhraseEvalEditDistOther = false;
    @ArgumentParser.Option(name="usePhraseEvalWordShape", gloss="% of phrases of that label that have the same word shape")
    public boolean usePhraseEvalWordShape = false;
    @ArgumentParser.Option(name="usePhraseEvalWordShapeStr", gloss="uses the word shape str as a feature")
    public boolean usePhraseEvalWordShapeStr = false;
    @ArgumentParser.Option(name="usePhraseEvalFirstCapital", gloss="words starts with a capital letter")
    public boolean usePhraseEvalFirstCapital;
    @ArgumentParser.Option(name="usePhraseEvalBOW")
    public boolean usePhraseEvalBOW = false;
    @ArgumentParser.Option(name="usePatternEvalWordClass")
    public boolean usePatternEvalWordClass = false;
    @ArgumentParser.Option(name="usePatternEvalWordShape")
    public boolean usePatternEvalWordShape = false;
    @ArgumentParser.Option(name="usePatternEvalWordShapeStr", gloss="uses the word shape str as a feature")
    public boolean usePatternEvalWordShapeStr = false;
    @ArgumentParser.Option(name="usePatternEvalFirstCapital", gloss="words starts with a capital letter")
    public boolean usePatternEvalFirstCapital;
    @ArgumentParser.Option(name="usePatternEvalGoogleNgram")
    public boolean usePatternEvalGoogleNgram = false;
    @ArgumentParser.Option(name="usePatternEvalDomainNgram")
    public boolean usePatternEvalDomainNgram = false;
    @ArgumentParser.Option(name="usePatternEvalSemanticOdds")
    public boolean usePatternEvalSemanticOdds = false;
    @ArgumentParser.Option(name="usePatternEvalEditDistSame")
    public boolean usePatternEvalEditDistSame = false;
    @ArgumentParser.Option(name="usePatternEvalEditDistOther")
    public boolean usePatternEvalEditDistOther = false;
    @ArgumentParser.Option(name="usePatternEvalBOW")
    public boolean usePatternEvalBOW = false;
    @ArgumentParser.Option(name="perSelectRand")
    public double perSelectRand = 0.01;
    @ArgumentParser.Option(name="perSelectNeg")
    public double perSelectNeg = 1.0;
    @ArgumentParser.Option(name="doNotExtractPhraseAnyWordLabeledOtherClass")
    public boolean doNotExtractPhraseAnyWordLabeledOtherClass = true;
    @ArgumentParser.Option(name="saveInvertedIndex")
    public boolean saveInvertedIndex = false;
    @ArgumentParser.Option(name="loadInvertedIndex")
    public boolean loadInvertedIndex = false;
    @ArgumentParser.Option(name="storePatsForEachToken", gloss="used for storing patterns in PSQL/MEMORY/LUCENE")
    public PatternForEachTokenWay storePatsForEachToken = PatternForEachTokenWay.MEMORY;
    @ArgumentParser.Option(name="sampleSentencesForSufficientStats", gloss="% sentences to use for learning pattterns")
    double sampleSentencesForSufficientStats = 1.0;
    public static String backgroundSymbol = "O";
    int wordShaper = 8;
    private ConcurrentHashMap<String, String> wordShapeCache = new ConcurrentHashMap();
    public SentenceIndex invertedIndex;
    public static String extremedebug = "extremePatDebug";
    public static String minimaldebug = "minimaldebug";
    Properties props;
    public List<String> functionWords = Arrays.asList("a", "an", "the", "of", "at", "on", "in", "he", "she", "him", "her", "they", "them", "and", "no", "not", "nor", "as", "do");
    Map<String, TreeMap<Integer, Counter<CandidatePhrase>>> learnedWordsEachIter = new HashMap<String, TreeMap<Integer, Counter<CandidatePhrase>>>();
    final double editDistMax = 1000.0;
    @ArgumentParser.Option(name="batchProcessSents")
    public boolean batchProcessSents = false;
    @ArgumentParser.Option(name="writeMatchedTokensFiles")
    public boolean writeMatchedTokensFiles = false;
    @ArgumentParser.Option(name="writeMatchedTokensIdsForEachPhrase")
    public boolean writeMatchedTokensIdsForEachPhrase = false;

    public Set<String> getLabels() {
        return this.labels;
    }

    public Map<String, String> getAllOptions() {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.props != null) {
            this.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(x, y) -> values.put(x.toString(), y == null ? "null" : y.toString())));
        }
        try {
            Field[] aClassFields;
            Class<?> thisClass = Class.forName(this.getClass().getName());
            for (Field f : aClassFields = thisClass.getDeclaredFields()) {
                if (!f.getType().getClass().isPrimitive() && Arrays.binarySearch(GetPatternsFromDataMultiClass.printOptionClass, f.getType()) < 0) continue;
                String fName = f.getName();
                Object fvalue = f.get(this);
                values.put(fName, fvalue == null ? "null" : fvalue.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return values;
    }

    public boolean hasSeedWordOrOtherSem(CandidatePhrase p) {
        for (Map.Entry<String, Set<CandidatePhrase>> seeds : this.seedLabelDictionary.entrySet()) {
            if (!seeds.getValue().contains(p)) continue;
            return true;
        }
        return this.otherSemanticClassesWords.contains(p);
    }

    public TreeMap<Integer, Counter<CandidatePhrase>> getLearnedWordsEachIter(String label) {
        return this.learnedWordsEachIter.get(label);
    }

    public Map<String, TreeMap<Integer, Counter<CandidatePhrase>>> getLearnedWordsEachIter() {
        return this.learnedWordsEachIter;
    }

    public void setLearnedWordsEachIter(TreeMap<Integer, Counter<CandidatePhrase>> words, String label) {
        this.learnedWordsEachIter.put(label, words);
    }

    public ConstantsAndVariables(Properties props, Set<String> labels, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException {
        this.labels = labels;
        for (String label : labels) {
            this.seedLabelDictionary.put(label, new HashSet());
        }
        this.answerClass = answerClass;
        ConstantsAndVariables.generalizeClasses = generalizeClasses;
        if (ConstantsAndVariables.generalizeClasses == null) {
            ConstantsAndVariables.generalizeClasses = new HashMap<String, Class>();
        }
        ConstantsAndVariables.generalizeClasses.putAll(answerClass);
        this.ignoreWordswithClassesDuringSelection = ignoreClasses;
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, Map<String, Set<CandidatePhrase>> labelDictionary, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses, Map<String, Map<Class, Object>> ignoreClasses) throws IOException {
        for (Map.Entry<String, Set<CandidatePhrase>> en2 : labelDictionary.entrySet()) {
            this.seedLabelDictionary.put(en2.getKey(), Collections.unmodifiableSet(en2.getValue()));
        }
        this.labels = labelDictionary.keySet();
        this.answerClass = answerClass;
        ConstantsAndVariables.generalizeClasses = generalizeClasses;
        if (ConstantsAndVariables.generalizeClasses == null) {
            ConstantsAndVariables.generalizeClasses = new HashMap<String, Class>();
        }
        ConstantsAndVariables.generalizeClasses.putAll(answerClass);
        this.ignoreWordswithClassesDuringSelection = ignoreClasses;
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, Set<String> labels, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass) throws IOException {
        this.labels = labels;
        for (String label : labels) {
            this.seedLabelDictionary.put(label, new HashSet());
        }
        this.answerClass = answerClass;
        generalizeClasses = new HashMap<String, Class>();
        generalizeClasses.putAll(answerClass);
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, String label, Class<? extends TypesafeMap.Key<String>> answerClass) throws IOException {
        this.labels = new HashSet<String>();
        this.labels.add(label);
        this.seedLabelDictionary.put(label, new HashSet());
        this.answerClass = new HashMap<String, Class<? extends TypesafeMap.Key<String>>>();
        this.answerClass.put(label, answerClass);
        generalizeClasses = new HashMap<String, Class>();
        generalizeClasses.putAll(this.answerClass);
        this.setUp(props);
    }

    public ConstantsAndVariables(Properties props, Set<String> labels, Map<String, Class<? extends TypesafeMap.Key<String>>> answerClass, Map<String, Class> generalizeClasses) throws IOException {
        this.labels = labels;
        for (String label : labels) {
            this.seedLabelDictionary.put(label, new HashSet());
        }
        this.answerClass = answerClass;
        ConstantsAndVariables.generalizeClasses = generalizeClasses;
        if (ConstantsAndVariables.generalizeClasses == null) {
            ConstantsAndVariables.generalizeClasses = new HashMap<String, Class>();
        }
        ConstantsAndVariables.generalizeClasses.putAll(answerClass);
        this.setUp(props);
    }

    public void setUp(Properties props) throws IOException {
        HashSet<String> st;
        String[] t;
        if (this.alreadySetUp) {
            return;
        }
        Redwood.log(new Object[]{Redwood.DBG, "Setting up ConstantsAndVariables"});
        ArgumentParser.fillOptions((Object)this, props);
        ArgumentParser.fillOptions(PatternFactory.class, props);
        ArgumentParser.fillOptions(SurfacePatternFactory.class, props);
        ArgumentParser.fillOptions(DepPatternFactory.class, props);
        if (this.wordIgnoreRegex != null && !this.wordIgnoreRegex.isEmpty()) {
            Redwood.log(new Object[]{Redwood.DBG, "Ignore word regex is " + this.wordIgnoreRegex});
            PatternFactory.ignoreWordRegex = Pattern.compile(this.wordIgnoreRegex);
        }
        for (String label : this.labels) {
            this.env.put(label, TokenSequencePattern.getNewEnv());
            for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> entry : this.answerClass.entrySet()) {
                this.env.get(label).bind(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Class<? extends TypesafeMap.Key<String>>> entry : generalizeClasses.entrySet()) {
                this.env.get(label).bind(entry.getKey(), entry.getValue());
            }
        }
        Redwood.log(new Object[]{Redwood.DBG, this.channelNameLogger, "Running with debug output"});
        stopWords = new HashSet<CandidatePhrase>();
        if (this.stopWordsPatternFiles != null) {
            Redwood.log(minimaldebug, this.channelNameLogger, "Reading stop words from " + this.stopWordsPatternFiles);
            for (String string : this.stopWordsPatternFiles.split("[;,]")) {
                for (String string2 : IOUtils.readLines(string)) {
                    if (string2.trim().isEmpty()) continue;
                    stopWords.add(CandidatePhrase.createOrGet(string2.trim()));
                }
            }
        }
        this.englishWords = new HashSet<String>();
        if (this.englishWordsFiles != null) {
            System.out.println("Reading english words from " + this.englishWordsFiles);
            for (String string : this.englishWordsFiles.split("[;,]")) {
                this.englishWords.addAll(IOUtils.linesFromFile(string));
            }
        }
        if (this.commonWordsPatternFiles != null) {
            this.commonEngWords = Collections.synchronizedSet(new HashSet());
            for (String string : this.commonWordsPatternFiles.split("[;,]")) {
                this.commonEngWords.addAll(IOUtils.linesFromFile(string));
            }
        }
        if (this.otherSemanticClassesFiles != null) {
            if (this.otherSemanticClassesWords == null) {
                this.otherSemanticClassesWords = Collections.synchronizedSet(new HashSet());
            }
            for (String string : this.otherSemanticClassesFiles.split("[;,]")) {
                for (File file : ConstantsAndVariables.listFileIncludingItself(string)) {
                    for (String w : IOUtils.readLines(file)) {
                        String[] t3 = w.split("\\s+");
                        if (t3.length > PatternFactory.numWordsCompoundMax) continue;
                        this.otherSemanticClassesWords.add(CandidatePhrase.createOrGet(w));
                    }
                }
            }
            System.out.println("Size of othersemantic class variables is " + this.otherSemanticClassesWords.size());
        } else {
            this.otherSemanticClassesWords = Collections.synchronizedSet(new HashSet());
            System.out.println("Size of othersemantic class variables is 0");
        }
        String stopStr = "/";
        int i = 0;
        for (CandidatePhrase candidatePhrase : stopWords) {
            if (i > 0) {
                stopStr = stopStr + "|";
            }
            stopStr = stopStr + Pattern.quote(candidatePhrase.getPhrase().replaceAll("\\\\", "\\\\\\\\"));
            ++i;
        }
        stopStr = stopStr + "/";
        for (String string : this.labels) {
            this.env.get(string).bind("$FILLER", "/" + StringUtils.join(PatternFactory.fillerWords, "|") + "/");
            this.env.get(string).bind("$STOPWORD", stopStr);
            this.env.get(string).bind("$MOD", "[{tag:/JJ.*/}]");
            if (matchLowerCaseContext) {
                this.env.get(string).setDefaultStringMatchFlags(2);
                this.env.get(string).setDefaultStringPatternFlags(2);
            }
            this.env.get(string).bind("OTHERSEM", PatternsAnnotations.OtherSemanticLabel.class);
            this.env.get(string).bind("grandparentparsetag", CoreAnnotations.GrandparentAnnotation.class);
        }
        if (this.wordClassClusterFile != null) {
            this.wordClassClusters = new HashMap<String, Integer>();
            for (String string : IOUtils.readLines(this.wordClassClusterFile)) {
                String[] t2 = string.split("\t");
                this.wordClassClusters.put(t2[0], Integer.parseInt(t2[1]));
            }
        }
        if (this.generalWordClassClusterFile != null) {
            this.setGeneralWordClassClusters(new HashMap<String, Integer>());
            for (String string : IOUtils.readLines(this.generalWordClassClusterFile)) {
                String[] t2 = string.split("\t");
                this.getGeneralWordClassClusters().put(t2[0], Integer.parseInt(t2[1]));
            }
        }
        if (this.targetAllowedTagsInitialsStr != null) {
            this.allowedTagsInitials = new HashMap<String, Set<String>>();
            for (Iterator<Object> iterator : this.targetAllowedTagsInitialsStr.split(";")) {
                t = ((String)((Object)iterator)).split(",");
                st = new HashSet<String>();
                for (int j = 1; j < t.length; ++j) {
                    st.add(t[j]);
                }
                this.allowedTagsInitials.put(t[0], st);
            }
        }
        if (PatternFactory.useTargetNERRestriction && this.targetAllowedNERs != null) {
            this.allowedNERsforLabels = new HashMap<String, Set<String>>();
            for (Iterator<Object> iterator : this.targetAllowedNERs.split(";")) {
                t = ((String)((Object)iterator)).split(",");
                st = new HashSet();
                for (int j = 1; j < t.length; ++j) {
                    st.add(t[j]);
                }
                this.allowedNERsforLabels.put(t[0], st);
            }
        }
        for (String string : this.labels) {
            this.learnedWordsEachIter.put(string, new TreeMap());
        }
        if (this.usePhraseEvalGoogleNgram || this.usePatternEvalDomainNgram) {
            Data.usingGoogleNgram = true;
            ArgumentParser.fillOptions(GoogleNGramsSQLBacked.class, props);
        }
        if (this.goldEntitiesEvalFiles != null && this.evaluate) {
            this.goldEntities = ConstantsAndVariables.readGoldEntities(this.goldEntitiesEvalFiles);
        }
        this.alreadySetUp = true;
    }

    public static Iterable<File> listFileIncludingItself(String file) {
        File f = new File(file);
        if (!f.isDirectory()) {
            return Arrays.asList(f);
        }
        return IOUtils.iterFilesRecursive(f);
    }

    static Map<String, Map<String, Boolean>> readGoldEntities(String goldEntitiesEvalFiles) {
        HashMap<String, Map<String, Boolean>> goldWords = new HashMap<String, Map<String, Boolean>>();
        if (goldEntitiesEvalFiles != null) {
            for (String gfile : goldEntitiesEvalFiles.split(";")) {
                String[] t = gfile.split(",");
                String label = t[0];
                String goldfile = t[1];
                HashMap<String, Boolean> goldWords4Label = new HashMap<String, Boolean>();
                for (String line : IOUtils.readLines(goldfile)) {
                    if ((line = line.trim()).isEmpty()) continue;
                    if (line.endsWith("#")) {
                        goldWords4Label.put(line.substring(0, line.length() - 1), false);
                        continue;
                    }
                    goldWords4Label.put(line, true);
                }
                goldWords.put(label, goldWords4Label);
            }
        }
        return goldWords;
    }

    public Map<String, Counter<String>> getWordShapesForLabels() {
        return this.wordShapesForLabels;
    }

    public static Map<String, Class> getGeneralizeClasses() {
        return generalizeClasses;
    }

    public static Set<CandidatePhrase> getStopWords() {
        return stopWords;
    }

    public void addWordShapes(String label, Set<CandidatePhrase> words) {
        if (!this.wordShapesForLabels.containsKey(label)) {
            this.wordShapesForLabels.put(label, new ClassicCounter());
        }
        for (CandidatePhrase wc : words) {
            String w = wc.getPhrase();
            String ws = null;
            if (this.wordShapeCache.containsKey(w)) {
                ws = this.wordShapeCache.get(w);
            } else {
                ws = WordShapeClassifier.wordShape(w, this.wordShaper);
                this.wordShapeCache.put(w, ws);
            }
            this.wordShapesForLabels.get(label).incrementCount(ws);
        }
    }

    public Map<String, Set<CandidatePhrase>> getSeedLabelDictionary() {
        return this.seedLabelDictionary;
    }

    public Counter<CandidatePhrase> getLearnedWords(String label) {
        Counter<CandidatePhrase> learned = Counters.flatten((Map)this.learnedWordsEachIter.get(label));
        if (learned == null) {
            learned = new ClassicCounter<CandidatePhrase>();
            this.learnedWordsEachIter.put(label, new TreeMap());
        }
        return learned;
    }

    public String getLearnedWordsAsJson() {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        for (String label : this.getLabels()) {
            Counter<CandidatePhrase> learnedWords = this.getLearnedWords(label);
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (CandidatePhrase k : learnedWords.keySet()) {
                arr.add(k.getPhrase());
            }
            obj.add(label, arr);
        }
        return obj.build().toString();
    }

    public String getLearnedWordsAsJsonLastIteration() {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        for (String label : this.getLabels()) {
            Counter<CandidatePhrase> learnedWords = this.getLearnedWordsEachIter(label).lastEntry().getValue();
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (CandidatePhrase k : learnedWords.keySet()) {
                arr.add(k.getPhrase());
            }
            obj.add(label, arr);
        }
        return obj.build().toString();
    }

    public String getSetWordsAsJson(Map<String, Counter<CandidatePhrase>> words) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        for (String label : this.getLabels()) {
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (CandidatePhrase k : words.get(label).keySet()) {
                arr.add(k.getPhrase());
            }
            obj.add(label, arr);
        }
        return obj.build().toString();
    }

    public Set<String> getEnglishWords() {
        return this.englishWords;
    }

    public Set<String> getCommonEngWords() {
        return this.commonEngWords;
    }

    public Set<CandidatePhrase> getOtherSemanticClassesWords() {
        return this.otherSemanticClassesWords;
    }

    public void setOtherSemanticClassesWords(Set<CandidatePhrase> other) {
        this.otherSemanticClassesWords = other;
    }

    public Map<String, Integer> getWordClassClusters() {
        return this.wordClassClusters;
    }

    private Pair<String, Double> getEditDist(Collection<CandidatePhrase> words, String ph) {
        double minD = 1000.0;
        String minPh = ph;
        for (CandidatePhrase ec : words) {
            String e = ec.getPhrase();
            if (e.equals(ph)) {
                return new Pair<String, Double>(ph, 0.0);
            }
            double d = EditDistanceDamerauLevenshteinLike.editDistance(e, ph, 3);
            if (d == 1.0) {
                return new Pair<String, Double>(e, d);
            }
            if (d == -1.0) {
                d = 1000.0;
            }
            if (!(d < minD)) continue;
            minD = d;
            minPh = e;
        }
        return new Pair<String, Double>(minPh, minD);
    }

    public Pair<String, Double> getEditDistanceFromThisClass(String label, String ph, int minLen) {
        if (ph.length() < minLen) {
            return new Pair<String, Double>(ph, 1000.0);
        }
        HashSet<CandidatePhrase> words = new HashSet<CandidatePhrase>((Collection)this.seedLabelDictionary.get(label));
        words.addAll(this.getLearnedWords(label).keySet());
        Pair<String, Double> minD = this.getEditDist(words, ph);
        double minDtotal = minD.second();
        String minPh = minD.first();
        assert (!minPh.isEmpty());
        return new Pair<String, Double>(minPh, minDtotal);
    }

    public Pair<String, Double> getEditDistanceFromOtherClasses(String label, String ph, int minLen) {
        if (ph.length() < minLen) {
            return new Pair<String, Double>(ph, 1000.0);
        }
        Pair<String, Double> minD = this.getEditDist(this.otherSemanticClassesWords, ph);
        String minPh = minD.first();
        double minDfinal = minD.second();
        for (String l : this.labels) {
            Pair<String, Double> editMatch;
            if (l.equals(label) || !((editMatch = this.getEditDistanceFromThisClass(l, ph, minLen)).second() < minDfinal)) continue;
            minDfinal = editMatch.second();
            minPh = editMatch.first();
        }
        assert (!minPh.isEmpty());
        return new Pair<String, Double>(minPh, minDfinal);
    }

    public ConcurrentHashMap<String, Double> getEditDistanceFromEnglishWords() {
        return this.editDistanceFromEnglishWords;
    }

    public ConcurrentHashMap<String, String> getEditDistanceFromEnglishWordsMatches() {
        return this.editDistanceFromEnglishWordsMatches;
    }

    public double getEditDistanceScoresOtherClass(String label, String g) {
        Pair<String, Double> editMatch = this.getEditDistanceFromOtherClasses(label, g, 4);
        double editDist = editMatch.second();
        String editDistPh = editMatch.first();
        assert (!editDistPh.isEmpty());
        return editDist == 1000.0 ? 1.0 : editDist / (double)Math.max(g.length(), editDistPh.length());
    }

    public double getEditDistanceScoresOtherClassThreshold(String label, String g) {
        double editDistRatio = this.getEditDistanceScoresOtherClass(label, g);
        if (editDistRatio < 0.2) {
            return 1.0;
        }
        return 0.0;
    }

    public double getEditDistanceScoresThisClassThreshold(String label, String g) {
        double editDistRatio = this.getEditDistanceScoresThisClass(label, g);
        if (editDistRatio < 0.2) {
            return 1.0;
        }
        return 0.0;
    }

    public double getEditDistanceScoresThisClass(String label, String g) {
        Pair<String, Double> editMatch = this.getEditDistanceFromThisClass(label, g, 4);
        double editDist = editMatch.second();
        String editDistPh = editMatch.first();
        assert (!editDistPh.isEmpty());
        return editDist == 1000.0 ? 1.0 : editDist / (double)Math.max(g.length(), editDistPh.length());
    }

    public static boolean isFuzzyMatch(String w1, String w2, int minLen4Fuzzy) {
        double d;
        EditDistance editDistance = new EditDistance(true);
        if (w1.equals(w2)) {
            return true;
        }
        return w2.length() > minLen4Fuzzy && (d = editDistance.score(w1, w2)) == 1.0;
    }

    public static CandidatePhrase containsFuzzy(Set<CandidatePhrase> words, CandidatePhrase w, int minLen4Fuzzy) {
        for (CandidatePhrase w1 : words) {
            if (!ConstantsAndVariables.isFuzzyMatch(w1.getPhrase(), w.getPhrase(), minLen4Fuzzy)) continue;
            return w1;
        }
        return null;
    }

    public Map<String, Integer> getGeneralWordClassClusters() {
        return this.generalWordClassClusters;
    }

    public void setGeneralWordClassClusters(Map<String, Integer> generalWordClassClusters) {
        this.generalWordClassClusters = generalWordClassClusters;
    }

    public Map<String, String> getWordShapeCache() {
        return this.wordShapeCache;
    }

    public Map<String, Class<? extends TypesafeMap.Key<String>>> getAnswerClass() {
        return this.answerClass;
    }

    public Map<String, Map<Class, Object>> getIgnoreWordswithClassesDuringSelection() {
        return this.ignoreWordswithClassesDuringSelection;
    }

    public void addSeedWords(String label, Collection<CandidatePhrase> seeds) throws Exception {
        if (!this.seedLabelDictionary.containsKey(label)) {
            throw new Exception("label not present in the model");
        }
        HashSet<CandidatePhrase> seedWords = new HashSet<CandidatePhrase>((Collection)this.seedLabelDictionary.get(label));
        seedWords.addAll(seeds);
        this.seedLabelDictionary.put(label, Collections.unmodifiableSet(seedWords));
    }

    public static class DataSentsIterator
    implements Iterator<Pair<Map<String, DataInstance>, File>> {
        boolean readInMemory = false;
        Iterator<File> sentfilesIter = null;
        boolean batchProcessSents;

        public DataSentsIterator(boolean batchProcessSents) {
            this.batchProcessSents = batchProcessSents;
            if (batchProcessSents) {
                this.sentfilesIter = Data.sentsFiles.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.batchProcessSents) {
                return this.sentfilesIter.hasNext();
            }
            return !this.readInMemory;
        }

        @Override
        public Pair<Map<String, DataInstance>, File> next() {
            if (this.batchProcessSents) {
                try {
                    File f = this.sentfilesIter.next();
                    return new Pair<Map<String, DataInstance>, File>((Map<String, DataInstance>)IOUtils.readObjectFromFile(f), f);
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            this.readInMemory = true;
            return new Pair<Map<String, DataInstance>, File>(Data.sents, new File(Data.inMemorySaveFileLocation));
        }
    }

    public static enum PatternIndexWay {
        MEMORY,
        OPENHFT,
        LUCENE;

    }

    public static enum PatternForEachTokenWay {
        MEMORY,
        LUCENE,
        DB;

    }

    public static class ScorePhraseMeasures
    implements Comparable {
        String name;
        static int num = 0;
        int numObj;
        static Map<String, ScorePhraseMeasures> createdObjects = new ConcurrentHashMap<String, ScorePhraseMeasures>();
        static final ScorePhraseMeasures DISTSIM = new ScorePhraseMeasures("DistSim");
        static final ScorePhraseMeasures GOOGLENGRAM = new ScorePhraseMeasures("GoogleNGram");
        static final ScorePhraseMeasures PATWTBYFREQ = new ScorePhraseMeasures("PatWtByFreq");
        static final ScorePhraseMeasures EDITDISTSAME = new ScorePhraseMeasures("EditDistSame");
        static final ScorePhraseMeasures EDITDISTOTHER = new ScorePhraseMeasures("EditDistOther");
        static final ScorePhraseMeasures DOMAINNGRAM = new ScorePhraseMeasures("DomainNgram");
        static final ScorePhraseMeasures SEMANTICODDS = new ScorePhraseMeasures("SemanticOdds");
        static final ScorePhraseMeasures WORDSHAPE = new ScorePhraseMeasures("WordShape");
        static final ScorePhraseMeasures WORDVECPOSSIMAVG = new ScorePhraseMeasures("WordVecPosSimAvg");
        static final ScorePhraseMeasures WORDVECPOSSIMMAX = new ScorePhraseMeasures("WordVecPosSimMax");
        static final ScorePhraseMeasures WORDVECNEGSIMAVG = new ScorePhraseMeasures("WordVecNegSimAvg");
        static final ScorePhraseMeasures WORDVECNEGSIMMAX = new ScorePhraseMeasures("WordVecNegSimMax");
        static final ScorePhraseMeasures ISFIRSTCAPITAL = new ScorePhraseMeasures("IsFirstLetterCapital");
        static final ScorePhraseMeasures WORDSHAPESTR = new ScorePhraseMeasures("WordShapeStr");
        static final ScorePhraseMeasures BOW = new ScorePhraseMeasures("Word");

        public static ScorePhraseMeasures create(String n) {
            if (createdObjects.containsKey(n)) {
                return createdObjects.get(n);
            }
            return new ScorePhraseMeasures(n);
        }

        private ScorePhraseMeasures(String n) {
            this.name = n;
            this.numObj = num++;
            createdObjects.put(n, this);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ScorePhraseMeasures)) {
                return false;
            }
            return ((ScorePhraseMeasures)o).numObj == this.numObj;
        }

        public int compareTo(Object o) {
            if (!(o instanceof ScorePhraseMeasures)) {
                return -1;
            }
            return o.toString().compareTo(this.toString());
        }
    }
}

