/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.math;

import java.util.regex.Pattern;

public class NumberMatchingRegex {
    static final Pattern decintPattern = Pattern.compile("[+-]?\\d+");
    static final String Digits = "(\\p{Digit}+)";
    static final String HexDigits = "(\\p{XDigit}+)";
    static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    static final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
    static final Pattern fpPattern = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");

    private NumberMatchingRegex() {
    }

    public static boolean isDecimalInteger(String string) {
        return decintPattern.matcher(string).matches();
    }

    public static boolean isDouble(String string) {
        return fpPattern.matcher(string).matches();
    }
}

