/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.io;

import edu.stanford.nlp.io.ExtensionFileFilter;
import edu.stanford.nlp.io.NumberRangeFileFilter;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.FileFilter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class FileSequentialCollection
extends AbstractCollection<File> {
    private static Redwood.RedwoodChannels log = Redwood.channels(FileSequentialCollection.class);
    private Collection<?> coll;
    private FileFilter filt;
    private boolean includeDirs;

    public FileSequentialCollection() {
        this(null);
    }

    public FileSequentialCollection(Collection<?> c) {
        this(c, null);
    }

    public FileSequentialCollection(File path, String suffix, boolean recursively) {
        this(Collections.singletonList(path), suffix, recursively);
    }

    public FileSequentialCollection(Collection<?> c, String suffix, boolean recursively) {
        this(c, new ExtensionFileFilter(suffix, recursively), false);
    }

    public FileSequentialCollection(Collection<?> c, FileFilter filt) {
        this(c, filt, false);
    }

    public FileSequentialCollection(String filename, FileFilter filt) {
        this(Collections.singletonList(filename), filt);
    }

    public FileSequentialCollection(Collection<?> c, FileFilter filt, boolean includeDirs) {
        this.coll = c == null ? new ArrayList() : c;
        this.filt = filt;
        this.includeDirs = includeDirs;
    }

    @Override
    public int size() {
        int counter = 0;
        for (File f : this) {
            ++counter;
        }
        return counter;
    }

    @Override
    public Iterator<File> iterator() {
        return new FileSequentialCollectionIterator();
    }

    public static void main(String[] args) {
        FileSequentialCollection fcollect = new FileSequentialCollection(Arrays.asList(args));
        for (Object fi : fcollect) {
            System.out.println(fi);
        }
        System.out.println("Above was Collection constructor");
        System.out.println("Empty constructor");
        FileSequentialCollection fcollect2 = new FileSequentialCollection();
        for (Object fi : fcollect2) {
            System.out.println(fi);
        }
        System.out.println("File String(mrg) boolean(true) constructor");
        FileSequentialCollection fcollect3 = new FileSequentialCollection(new File(args[0]), "mrg", true);
        for (Object fi : fcollect3) {
            System.out.println(fi);
        }
        System.out.println("Collection String(mrg) boolean constructor");
        FileSequentialCollection fcollect4 = new FileSequentialCollection(Arrays.asList(args), "mrg", true);
        for (Object fi : fcollect4) {
            System.out.println(fi);
        }
        System.out.println("Testing number range file filter");
        FileSequentialCollection fcollect5 = new FileSequentialCollection(Arrays.asList(args), (FileFilter)new NumberRangeFileFilter(320, 410, true));
        for (File fi : fcollect5) {
            System.out.println(fi);
        }
        System.out.println("Testing null filter but include dirs");
        FileSequentialCollection fcollect6 = new FileSequentialCollection(Arrays.asList(args), (FileFilter)null, true);
        for (File fi : fcollect6) {
            System.out.println(fi);
        }
    }

    private final class FileSequentialCollectionIterator
    implements Iterator<File> {
        private Object[] roots;
        private int rootsIndex;
        private Stack<Object> fileArrayStack;
        private Stack<Integer> fileArrayStackIndices;
        private File next;

        public FileSequentialCollectionIterator() {
            this.roots = FileSequentialCollection.this.coll.toArray();
            this.rootsIndex = 0;
            this.fileArrayStack = new Stack();
            this.fileArrayStackIndices = new Stack();
            if (this.roots.length > 0) {
                this.fileArrayStack.add(this.roots[this.rootsIndex]);
                this.fileArrayStackIndices.push(0);
            }
            this.next = this.primeNextFile();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public File next() {
            if (this.next == null) {
                throw new NoSuchElementException("FileSequentialCollection exhausted");
            }
            File ret = this.next;
            this.next = this.primeNextFile();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private File primeNextFile() {
            while (this.rootsIndex < this.roots.length) {
                while (!this.fileArrayStack.empty()) {
                    Object obj = this.fileArrayStack.peek();
                    if (obj instanceof File[]) {
                        File[] files = (File[])obj;
                        Integer index = this.fileArrayStackIndices.pop();
                        int ind = index;
                        if (ind < files.length) {
                            index = ind + 1;
                            this.fileArrayStackIndices.push(index);
                            this.fileArrayStack.push(files[ind]);
                            continue;
                        }
                        this.fileArrayStack.pop();
                        continue;
                    }
                    this.fileArrayStack.pop();
                    if (obj instanceof String) {
                        obj = new File((String)obj);
                    }
                    if (!(obj instanceof File)) {
                        throw new IllegalArgumentException("Collection elements must be Files or Strings");
                    }
                    File path = (File)obj;
                    if (path.isDirectory()) {
                        File[] directoryListing = path.listFiles(FileSequentialCollection.this.filt);
                        if (directoryListing == null) {
                            throw new IllegalArgumentException("Directory access problem for: " + path);
                        }
                        if (FileSequentialCollection.this.includeDirs) {
                            if (directoryListing.length > 0) {
                                this.fileArrayStack.push(directoryListing);
                                this.fileArrayStackIndices.push(0);
                            }
                            return path;
                        }
                        if (directoryListing.length <= 0) continue;
                        this.fileArrayStack.push(directoryListing);
                        this.fileArrayStackIndices.push(0);
                        continue;
                    }
                    if (!path.exists()) {
                        throw new IllegalArgumentException("File doesn't exist: " + path);
                    }
                    return path;
                }
                ++this.rootsIndex;
                if (this.rootsIndex >= this.roots.length) continue;
                this.fileArrayStack.add(this.roots[this.rootsIndex]);
                this.fileArrayStackIndices.push(0);
            }
            return null;
        }
    }
}

