/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie;

import edu.stanford.nlp.ie.AbstractSequenceClassifier;
import edu.stanford.nlp.ie.crf.CRFClassifier;
import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;

public class NERServer {
    private static Redwood.RedwoodChannels log = Redwood.channels(NERServer.class);
    private static final boolean ENV_DEBUG = System.getenv("NERSERVER_DEBUG") != null ? Boolean.parseBoolean(System.getenv("NERSERVER_DEBUG")) : false;
    private boolean DEBUG = ENV_DEBUG;
    private final String charset;
    private final ServerSocket listener;
    private final AbstractSequenceClassifier ner;
    private static final String USAGE = "Usage: NERServer [-loadClassifier file|-loadJarClassifier resource|-client] -port portNumber";

    public NERServer(int port, AbstractSequenceClassifier asc, String charset) throws IOException {
        this.ner = asc;
        this.listener = new ServerSocket(port);
        this.charset = charset;
    }

    public void run() {
        Socket client = null;
        while (true) {
            try {
                while (true) {
                    client = this.listener.accept();
                    if (this.DEBUG) {
                        log.info("Accepted request from ");
                        log.info(client.getInetAddress().getHostName());
                    }
                    new Session(client);
                }
            }
            catch (Exception e1) {
                log.info("NERServer: couldn't accept");
                e1.printStackTrace(System.err);
                try {
                    client.close();
                    continue;
                }
                catch (Exception e2) {
                    log.info("NERServer: couldn't close client");
                    e2.printStackTrace(System.err);
                    continue;
                }
            }
            break;
        }
    }

    public static void main(String[] args) throws Exception {
        int port;
        Properties props = StringUtils.argsToProperties(args);
        String loadFile = props.getProperty("loadClassifier");
        String loadJarFile = props.getProperty("loadJarClassifier");
        String client = props.getProperty("client");
        String portStr = props.getProperty("port", "4465");
        props.remove("port");
        if (portStr == null || portStr.equals("")) {
            log.info(USAGE);
            return;
        }
        String charset = "utf-8";
        String encoding = props.getProperty("encoding");
        if (encoding != null && !"".equals(encoding)) {
            charset = encoding;
        }
        try {
            port = Integer.parseInt(portStr);
        }
        catch (NumberFormatException e) {
            log.info("Non-numerical port");
            log.info(USAGE);
            return;
        }
        if (props.getProperty("outputFormat") == null) {
            props.setProperty("outputFormat", "slashTags");
        }
        if (client != null && !client.equals("")) {
            String host = props.getProperty("host");
            NERClient.communicateWithNERServer(host, port, charset);
        } else {
            CRFClassifier asc = loadFile != null && !loadFile.equals("") ? CRFClassifier.getClassifier(loadFile, props) : (loadJarFile != null && !loadJarFile.equals("") ? CRFClassifier.getJarClassifier(loadJarFile, props) : CRFClassifier.getDefaultClassifier(props));
            new NERServer(port, asc, charset).run();
        }
    }

    public static class NERClient {
        private NERClient() {
        }

        public static void communicateWithNERServer(String host, int port, String charset) throws IOException {
            System.out.println("Input some text and press RETURN to NER tag it,  or just RETURN to finish.");
            BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in, charset));
            NERClient.communicateWithNERServer(host, port, charset, stdIn, null, true);
            stdIn.close();
        }

        public static void communicateWithNERServer(String host, int port, String charset, BufferedReader input, BufferedWriter output, boolean closeOnBlank) throws IOException {
            String userInput;
            if (host == null) {
                host = "localhost";
            }
            while ((userInput = input.readLine()) != null) {
                if (userInput.matches("\\n?")) {
                    if (!closeOnBlank) continue;
                    break;
                }
                try {
                    String result;
                    Socket socket = new Socket(host, port);
                    PrintWriter out2 = new PrintWriter((Writer)new OutputStreamWriter(socket.getOutputStream(), charset), true);
                    BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), charset));
                    out2.println(userInput);
                    while ((result = in.readLine()) != null) {
                        if (output == null) {
                            EncodingPrintWriter.out.println(result, charset);
                            continue;
                        }
                        output.write(result);
                        output.newLine();
                    }
                    in.close();
                    socket.close();
                }
                catch (UnknownHostException e) {
                    log.info("Cannot find host: ");
                    log.info(host);
                    return;
                }
                catch (IOException e) {
                    log.info("I/O error in the connection to: ");
                    log.info(host);
                    return;
                }
            }
        }
    }

    private class Session
    extends Thread {
        private final Socket client;
        private final BufferedReader in;
        private PrintWriter out;

        private Session(Socket socket) throws IOException {
            this.client = socket;
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream(), NERServer.this.charset));
            this.out = new PrintWriter(new OutputStreamWriter(this.client.getOutputStream(), NERServer.this.charset));
            this.start();
        }

        @Override
        public void run() {
            if (NERServer.this.DEBUG) {
                log.info("Created new session");
            }
            String input = null;
            try {
                input = this.in.readLine();
                if (NERServer.this.DEBUG) {
                    EncodingPrintWriter.err.println("Receiving: \"" + input + '\"', NERServer.this.charset);
                }
            }
            catch (IOException e) {
                log.info("NERServer:Session: couldn't read input");
                e.printStackTrace(System.err);
            }
            catch (NullPointerException npe) {
                log.info("NERServer:Session: connection closed by peer");
                npe.printStackTrace(System.err);
            }
            try {
                if (input != null) {
                    String output = NERServer.this.ner.classifyToString(input, ((NERServer)NERServer.this).ner.flags.outputFormat, !"slashTags".equals(((NERServer)NERServer.this).ner.flags.outputFormat));
                    if (NERServer.this.DEBUG) {
                        EncodingPrintWriter.err.println("Sending: \"" + output + '\"', NERServer.this.charset);
                    }
                    this.out.print(output);
                    this.out.flush();
                }
            }
            catch (OutOfMemoryError | RuntimeException e) {
                if (NERServer.this.DEBUG) {
                    log.error("NERServer.Session: error classifying string.");
                    log.error(e);
                }
            }
            finally {
                this.close();
            }
        }

        private void close() {
            try {
                this.in.close();
                this.out.close();
                if (NERServer.this.DEBUG) {
                    log.info("Closing connection to client");
                    log.info(this.client.getInetAddress().getHostName());
                }
                this.client.close();
            }
            catch (Exception e) {
                log.info("NERServer:Session: can't close session");
                e.printStackTrace(System.err);
            }
        }
    }
}

