/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.coref.data;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.coref.data.Document;
import edu.stanford.nlp.coref.data.DocumentPreprocessor;
import edu.stanford.nlp.coref.data.InputDoc;
import edu.stanford.nlp.coref.data.Mention;
import edu.stanford.nlp.coref.docreader.CoNLLDocumentReader;
import edu.stanford.nlp.coref.docreader.DocReader;
import edu.stanford.nlp.coref.md.CorefMentionFinder;
import edu.stanford.nlp.coref.md.DependencyCorefMentionFinder;
import edu.stanford.nlp.coref.md.RuleBasedCorefMentionFinder;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.international.pennchinese.ChineseSemanticHeadFinder;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class DocumentMaker {
    private final Properties props;
    private final DocReader reader;
    private final HeadFinder headFinder;
    private final Dictionaries dict;
    private final CorefMentionFinder md;
    private StanfordCoreNLP coreNLP;

    public DocumentMaker(Properties props, Dictionaries dictionaries) throws ClassNotFoundException, IOException {
        this.props = props;
        this.dict = dictionaries;
        this.reader = DocumentMaker.getDocumentReader(props);
        this.headFinder = DocumentMaker.getHeadFinder(props);
        this.md = CorefProperties.useGoldMentions(props) ? new RuleBasedCorefMentionFinder(this.headFinder, props) : null;
    }

    private static DocReader getDocumentReader(Properties props) {
        String corpusPath = CorefProperties.getInputPath(props);
        if (corpusPath == null) {
            return null;
        }
        CoNLLDocumentReader.Options options = new CoNLLDocumentReader.Options();
        if (!PropertiesUtils.getBool(props, "coref.printConLLLoadingMessage", true)) {
            options.printConLLLoadingMessage = false;
        }
        options.annotateTokenCoref = false;
        options.setFilter(".*_auto_conll$");
        options.lang = CorefProperties.getLanguage(props);
        return new CoNLLDocumentReader(corpusPath, options);
    }

    private static HeadFinder getHeadFinder(Properties props) {
        Locale lang = CorefProperties.getLanguage(props);
        if (lang == Locale.ENGLISH) {
            return new SemanticHeadFinder();
        }
        if (lang == Locale.CHINESE) {
            return new ChineseSemanticHeadFinder();
        }
        throw new RuntimeException("Invalid language setting: cannot load HeadFinder");
    }

    public Document makeDocument(Annotation anno) throws Exception {
        return this.makeDocument(new InputDoc(anno, null, null));
    }

    public Document makeDocument(InputDoc input) throws Exception {
        ArrayList<List<Mention>> mentions = new ArrayList<List<Mention>>();
        if (CorefProperties.useGoldMentions(this.props)) {
            List sentences = (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class);
            for (int i = 0; i < sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)sentences.get(i);
                List sentenceWords = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                ArrayList<Mention> sentenceMentions = new ArrayList<Mention>();
                mentions.add(sentenceMentions);
                for (Mention g : input.goldMentions.get(i)) {
                    sentenceMentions.add(new Mention(-1, g.startIndex, g.endIndex, sentenceWords, null, null, new ArrayList<CoreLabel>(sentenceWords.subList(g.startIndex, g.endIndex))));
                }
                this.md.findHead(sentence, sentenceMentions);
            }
        } else {
            for (CoreMap sentence : (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                mentions.add((List<Mention>)sentence.get(CorefCoreAnnotations.CorefMentionsAnnotation.class));
            }
        }
        Document doc = new Document(input, mentions);
        if (input.goldMentions != null) {
            this.findGoldMentionHeads(doc);
        }
        DocumentPreprocessor.preprocess(doc, this.dict, null, this.headFinder);
        return doc;
    }

    private void findGoldMentionHeads(Document doc) {
        List sentences = (List)doc.annotation.get(CoreAnnotations.SentencesAnnotation.class);
        for (int i = 0; i < sentences.size(); ++i) {
            DependencyCorefMentionFinder.findHeadInDependency((CoreMap)sentences.get(i), doc.goldMentions.get(i));
        }
    }

    private StanfordCoreNLP getStanfordCoreNLP(Properties props) {
        if (this.coreNLP != null) {
            return this.coreNLP;
        }
        Properties pipelineProps = new Properties(props);
        if (CorefProperties.conll(props)) {
            pipelineProps.put("annotators", (CorefProperties.getLanguage(props) == Locale.CHINESE ? "lemma, ner" : "lemma") + (CorefProperties.useGoldMentions(props) ? "" : ", mention"));
        } else {
            pipelineProps.put("annotators", "pos, lemma, ner, " + (CorefProperties.useConstituencyParse(props) ? "parse" : "depparse") + (CorefProperties.useGoldMentions(props) ? "" : ", mention"));
        }
        this.coreNLP = new StanfordCoreNLP(pipelineProps, false);
        return this.coreNLP;
    }

    public Document nextDoc() throws Exception {
        InputDoc input = this.reader.nextDoc();
        if (input == null) {
            return null;
        }
        if (!CorefProperties.useConstituencyParse(this.props)) {
            for (CoreMap sentence : (List)input.annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                sentence.remove(TreeCoreAnnotations.TreeAnnotation.class);
            }
        }
        this.getStanfordCoreNLP(this.props).annotate(input.annotation);
        if (CorefProperties.conll(this.props)) {
            input.annotation.set(CoreAnnotations.UseMarkedDiscourseAnnotation.class, true);
        }
        return this.makeDocument(input);
    }

    public void resetDocs() {
        this.reader.reset();
    }
}

