/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.regexp.NumberSequenceClassifier;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorFactory;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.CleanXmlAnnotator;
import edu.stanford.nlp.pipeline.ColumnDataClassifierAnnotator;
import edu.stanford.nlp.pipeline.DependencyParseAnnotator;
import edu.stanford.nlp.pipeline.DeterministicCorefAnnotator;
import edu.stanford.nlp.pipeline.EntityMentionsAnnotator;
import edu.stanford.nlp.pipeline.POSTaggerAnnotator;
import edu.stanford.nlp.pipeline.ParserAnnotator;
import edu.stanford.nlp.pipeline.TokensRegexNERAnnotator;
import edu.stanford.nlp.pipeline.WordsToSentencesAnnotator;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;

public class AnnotatorFactories {
    private AnnotatorFactories() {
    }

    public static AnnotatorFactory tokenize(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String nlsbString;
                WordToSentenceProcessor.NewlineIsSentenceBreak nlsb;
                String extraOptions = null;
                boolean keepNewline = Boolean.valueOf(this.properties.getProperty("ssplit.eolonly", "false"));
                String hasSsplit = this.properties.getProperty("annotators");
                if (hasSsplit != null && hasSsplit.contains("ssplit") && !Boolean.parseBoolean(this.properties.getProperty("ssplit.isOneSentence")) && (nlsb = WordToSentenceProcessor.stringToNewlineIsSentenceBreak(nlsbString = this.properties.getProperty("ssplit.newlineIsSentenceBreak", "never"))) != WordToSentenceProcessor.NewlineIsSentenceBreak.NEVER) {
                    keepNewline = true;
                }
                if (keepNewline) {
                    extraOptions = "tokenizeNLs,";
                }
                return annotatorImplementation.tokenizer(this.properties, false, extraOptions);
            }

            @Override
            public String additionalSignature() {
                StringBuilder os = new StringBuilder();
                os.append("tokenize.whitespace:").append(this.properties.getProperty("tokenize.whitespace", "false"));
                if (this.properties.getProperty("tokenize.options") != null) {
                    os.append(":tokenize.options:").append(this.properties.getProperty("tokenize.options"));
                }
                if (this.properties.getProperty("tokenize.language") != null) {
                    os.append(":tokenize.language:").append(this.properties.getProperty("tokenize.language"));
                }
                if (this.properties.getProperty("tokenize.class") != null) {
                    os.append(":tokenize.class:").append(this.properties.getProperty("tokenize.class"));
                }
                if (Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false")).booleanValue()) {
                    os.append("tokenize.keepeol:").append(this.properties.getProperty("tokenize.keepeol", "false"));
                    os.append("ssplit.eolonly:");
                    os.append(this.properties.getProperty("ssplit.eolonly", "false"));
                } else {
                    os.append("ssplit.eolonly:");
                    os.append(this.properties.getProperty("ssplit.eolonly", "false"));
                    os.append("ssplit.isOneSentence:");
                    os.append(this.properties.getProperty("ssplit.isOneSentence", "false"));
                    os.append("ssplit.newlineIsSentenceBreak:");
                    os.append(this.properties.getProperty("ssplit.newlineIsSentenceBreak", "never"));
                }
                return os.toString();
            }
        };
    }

    public static AnnotatorFactory cleanXML(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String xmlTags = this.properties.getProperty("clean.xmltags", ".*");
                String sentenceEndingTags = this.properties.getProperty("clean.sentenceendingtags", "");
                String singleSentenceTags = this.properties.getProperty("clean.singlesentencetags", CleanXmlAnnotator.DEFAULT_SINGLE_SENTENCE_TAGS);
                String allowFlawedString = this.properties.getProperty("clean.allowflawedxml");
                boolean allowFlawed = true;
                if (allowFlawedString != null) {
                    allowFlawed = Boolean.valueOf(allowFlawedString);
                }
                String dateTags = this.properties.getProperty("clean.datetags", "datetime|date");
                String docIdTags = this.properties.getProperty("clean.docIdtags", "docid");
                String docTypeTags = this.properties.getProperty("clean.docTypetags", "doctype");
                String utteranceTurnTags = this.properties.getProperty("clean.turntags", "turn");
                String speakerTags = this.properties.getProperty("clean.speakertags", "speaker");
                String docAnnotations = this.properties.getProperty("clean.docAnnotations", "docID=doc[id],doctype=doc[type],docsourcetype=doctype[source]");
                String tokenAnnotations = this.properties.getProperty("clean.tokenAnnotations", CleanXmlAnnotator.DEFAULT_TOKEN_ANNOTATIONS_PATTERNS);
                String sectionTags = this.properties.getProperty("clean.sectiontags", CleanXmlAnnotator.DEFAULT_SECTION_TAGS);
                String sectionAnnotations = this.properties.getProperty("clean.sectionAnnotations", CleanXmlAnnotator.DEFAULT_SECTION_ANNOTATIONS_PATTERNS);
                String ssplitDiscardTokens = this.properties.getProperty("clean.ssplitDiscardTokens");
                CleanXmlAnnotator annotator = annotatorImplementation.cleanXML(this.properties, xmlTags, sentenceEndingTags, dateTags, allowFlawed);
                annotator.setSingleSentenceTagMatcher(singleSentenceTags);
                annotator.setDocIdTagMatcher(docIdTags);
                annotator.setDocTypeTagMatcher(docTypeTags);
                annotator.setDiscourseTags(utteranceTurnTags, speakerTags);
                annotator.setDocAnnotationPatterns(docAnnotations);
                annotator.setTokenAnnotationPatterns(tokenAnnotations);
                annotator.setSectionTagMatcher(sectionTags);
                annotator.setSectionAnnotationPatterns(sectionAnnotations);
                annotator.setSsplitDiscardTokensMatcher(ssplitDiscardTokens);
                return annotator;
            }

            @Override
            public String additionalSignature() {
                return "clean.xmltags:" + this.properties.getProperty("clean.xmltags", ".*") + "clean.sentenceendingtags:" + this.properties.getProperty("clean.sentenceendingtags", "") + "clean.sentenceendingtags:" + this.properties.getProperty("clean.singlesentencetags", CleanXmlAnnotator.DEFAULT_SINGLE_SENTENCE_TAGS) + "clean.allowflawedxml:" + this.properties.getProperty("clean.allowflawedxml", "") + "clean.datetags:" + this.properties.getProperty("clean.datetags", "datetime|date") + "clean.docidtags:" + this.properties.getProperty("clean.docid", "docid") + "clean.doctypetags:" + this.properties.getProperty("clean.doctype", "doctype") + "clean.turntags:" + this.properties.getProperty("clean.turntags", "turn") + "clean.speakertags:" + this.properties.getProperty("clean.speakertags", "speaker") + "clean.docAnnotations:" + this.properties.getProperty("clean.docAnnotations", "docID=doc[id],doctype=doc[type],docsourcetype=doctype[source]") + "clean.tokenAnnotations:" + this.properties.getProperty("clean.tokenAnnotations", CleanXmlAnnotator.DEFAULT_TOKEN_ANNOTATIONS_PATTERNS) + "clean.sectiontags:" + this.properties.getProperty("clean.sectiontags", CleanXmlAnnotator.DEFAULT_SECTION_TAGS) + "clean.sectionAnnotations:" + this.properties.getProperty("clean.sectionAnnotations", CleanXmlAnnotator.DEFAULT_SECTION_ANNOTATIONS_PATTERNS);
            }
        };
    }

    public static AnnotatorFactory sentenceSplit(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                boolean nlSplitting = Boolean.valueOf(this.properties.getProperty("ssplit.eolonly", "false"));
                if (nlSplitting) {
                    boolean whitespaceTokenization = Boolean.valueOf(this.properties.getProperty("tokenize.whitespace", "false"));
                    if (whitespaceTokenization) {
                        if (System.getProperty("line.separator").equals("\n")) {
                            return WordsToSentencesAnnotator.newlineSplitter(false, "\n");
                        }
                        return WordsToSentencesAnnotator.newlineSplitter(false, System.getProperty("line.separator"), "\n");
                    }
                    return WordsToSentencesAnnotator.newlineSplitter(false, PTBTokenizer.getNewlineToken());
                }
                String isOneSentence = this.properties.getProperty("ssplit.isOneSentence");
                if (Boolean.parseBoolean(isOneSentence)) {
                    return WordsToSentencesAnnotator.nonSplitter(false);
                }
                String boundaryMultiTokenRegex = this.properties.getProperty("ssplit.boundaryMultiTokenRegex");
                String tokenPatternsToDiscardProp = this.properties.getProperty("ssplit.tokenPatternsToDiscard");
                Set<String> tokenRegexesToDiscard = null;
                if (tokenPatternsToDiscardProp != null) {
                    String[] toks = tokenPatternsToDiscardProp.split(",");
                    tokenRegexesToDiscard = Generics.newHashSet(Arrays.asList(toks));
                }
                String boundaryTokenRegex = this.properties.getProperty("ssplit.boundaryTokenRegex");
                Set<String> boundariesToDiscard = null;
                String bounds = this.properties.getProperty("ssplit.boundariesToDiscard");
                if (bounds != null) {
                    String[] toks = bounds.split(",");
                    boundariesToDiscard = Generics.newHashSet(Arrays.asList(toks));
                }
                Set<String> htmlElementsToDiscard = null;
                bounds = this.properties.getProperty("ssplit.htmlBoundariesToDiscard");
                if (bounds != null) {
                    String[] elements = bounds.split(",");
                    htmlElementsToDiscard = Generics.newHashSet(Arrays.asList(elements));
                }
                String nlsb = this.properties.getProperty("ssplit.newlineIsSentenceBreak", "never");
                return annotatorImplementation.wordToSentences(this.properties, false, boundaryTokenRegex, boundariesToDiscard, htmlElementsToDiscard, nlsb, boundaryMultiTokenRegex, tokenRegexesToDiscard);
            }

            @Override
            public String additionalSignature() {
                StringBuilder os = new StringBuilder();
                if (Boolean.valueOf(this.properties.getProperty("ssplit.eolonly", "false")).booleanValue()) {
                    os.append("ssplit.eolonly=").append(this.properties.getProperty("ssplit.eolonly", "false")).append('\n');
                    os.append("tokenize.whitespace=").append(this.properties.getProperty("tokenize.whitespace", "false")).append('\n');
                } else {
                    os.append(3.baseSignature(this.properties, "ssplit"));
                }
                return os.toString();
            }
        };
    }

    public static AnnotatorFactory posTag(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    return annotatorImplementation.posTagger(this.properties);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public String additionalSignature() {
                return POSTaggerAnnotator.signature(this.properties);
            }
        };
    }

    public static AnnotatorFactory lemma(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.morpha(this.properties, false);
            }

            @Override
            public String additionalSignature() {
                return "";
            }
        };
    }

    public static AnnotatorFactory nerTag(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                try {
                    return annotatorImplementation.ner(this.properties);
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }

            @Override
            public String additionalSignature() {
                return "ner.model:" + this.properties.getProperty("ner.model", "") + "ner.applyNumericClassifiers" + ':' + this.properties.getProperty("ner.applyNumericClassifiers", Boolean.toString(true)) + "ner.useSUTime" + ':' + this.properties.getProperty("ner.useSUTime", Boolean.toString(NumberSequenceClassifier.USE_SUTIME_DEFAULT));
            }
        };
    }

    public static AnnotatorFactory regexNER(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.tokensRegexNER(this.properties, "regexner");
            }

            @Override
            public String additionalSignature() {
                return PropertiesUtils.getSignature("regexner", this.properties, TokensRegexNERAnnotator.SUPPORTED_PROPERTIES);
            }
        };
    }

    public static AnnotatorFactory entityMentions(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.mentions(this.properties, "entitymentions");
            }

            @Override
            public String additionalSignature() {
                return PropertiesUtils.getSignature("entitymentions", this.properties, EntityMentionsAnnotator.SUPPORTED_PROPERTIES);
            }
        };
    }

    public static AnnotatorFactory gender(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.gender(this.properties, false);
            }

            @Override
            public String additionalSignature() {
                return "gender.firstnames:" + this.properties.getProperty("gender.firstnames", "edu/stanford/nlp/models/gender/first_name_map_small");
            }
        };
    }

    public static AnnotatorFactory truecase(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                String model = this.properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz");
                String bias = this.properties.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0");
                String mixed = this.properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list");
                return annotatorImplementation.trueCase(this.properties, model, bias, mixed, false);
            }

            @Override
            public String additionalSignature() {
                return "truecase.model:" + this.properties.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz") + "truecase.bias:" + this.properties.getProperty("truecase.bias", "INIT_UPPER:-0.7,UPPER:-0.7,O:0") + "truecase.mixedcasefile:" + this.properties.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list");
            }
        };
    }

    public static AnnotatorFactory parse(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.parse(this.properties);
            }

            @Override
            public String additionalSignature() {
                String type = this.properties.getProperty("parse.type", "stanford");
                if (type.equalsIgnoreCase("stanford")) {
                    return ParserAnnotator.signature("parse", this.properties);
                }
                if (type.equalsIgnoreCase("charniak")) {
                    return "parse.model:" + this.properties.getProperty("parse.model", "") + "parse.executable:" + this.properties.getProperty("parse.executable", "") + "parse.maxlen:" + this.properties.getProperty("parse.maxlen", "");
                }
                throw new RuntimeException("Unknown parser type: " + type + " (currently supported: stanford and charniak)");
            }
        };
    }

    public static AnnotatorFactory coref(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.coref(this.properties);
            }

            @Override
            public String additionalSignature() {
                return DeterministicCorefAnnotator.signature(this.properties);
            }
        };
    }

    public static AnnotatorFactory relation(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.relations(this.properties);
            }

            @Override
            public String additionalSignature() {
                return "sup.relation.verbose:" + this.properties.getProperty("sup.relation.verbose", "false") + this.properties.getProperty("sup.relation.model", "edu/stanford/nlp/models/supervised_relation_extractor/roth_relation_model_pipelineNER.ser");
            }
        };
    }

    public static AnnotatorFactory sentiment(Properties properties, final AnnotatorImplementations annotatorImplementation) {
        return new AnnotatorFactory(properties, annotatorImplementation){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImplementation.sentiment(this.properties, "sentiment");
            }

            @Override
            public String additionalSignature() {
                return "sentiment.model=" + this.properties.get("sentiment.model");
            }
        };
    }

    public static AnnotatorFactory columnDataClassifier(Properties properties, AnnotatorImplementations annotatorImpls) {
        return new AnnotatorFactory(properties, annotatorImpls){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                if (!this.properties.containsKey("loadClassifier")) {
                    throw new RuntimeException("Must load a classifier when creating a column data classifier annotator");
                }
                return new ColumnDataClassifierAnnotator(this.properties);
            }

            @Override
            protected String additionalSignature() {
                return "classifier=" + this.properties.get("loadClassifier=" + this.properties.get("loadClassifier"));
            }
        };
    }

    public static AnnotatorFactory dependencies(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory(properties, annotatorImpl){
            private static final long serialVersionUID = 1L;

            @Override
            public Annotator create() {
                return annotatorImpl.dependencies(this.properties);
            }

            @Override
            protected String additionalSignature() {
                return DependencyParseAnnotator.signature("depparse", this.properties);
            }
        };
    }

    public static AnnotatorFactory natlog(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory(properties, annotatorImpl){
            private static final long serialVersionUID = 4825870963088507811L;

            @Override
            public Annotator create() {
                return annotatorImpl.natlog(this.properties);
            }

            @Override
            protected String additionalSignature() {
                return "";
            }
        };
    }

    public static AnnotatorFactory quote(Properties properties, final AnnotatorImplementations annotatorImpl) {
        return new AnnotatorFactory(properties, annotatorImpl){
            private static final long serialVersionUID = -2525567112379296672L;

            @Override
            public Annotator create() {
                return annotatorImpl.quote(this.properties);
            }

            @Override
            protected String additionalSignature() {
                return "";
            }
        };
    }
}

