/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.patterns.dep;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.patterns.GetPatternsFromDataMultiClass;
import edu.stanford.nlp.patterns.dep.ExtractedPhrase;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.stats.Counters;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.CollectionValuedMap;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class ExtractPhraseFromPattern {
    public List<String> cutoffRelations = new ArrayList<String>();
    public int maxDepth = Integer.MAX_VALUE;
    public static List<String> ignoreTags = Arrays.asList("PRP", "PRP$", "CD", "DT", ".", "..", ",", "SYM");
    boolean ignoreCommonTags = true;
    public static ArrayList<String> cutoffTags = new ArrayList();
    public int maxPhraseLength = Integer.MAX_VALUE;
    Map<SemgrexPattern, List<Pair<String, SemanticGraph>>> matchedGraphsForPattern = new HashMap<SemgrexPattern, List<Pair<String, SemanticGraph>>>();
    private static int DEBUG = 1;

    public ExtractPhraseFromPattern() {
    }

    public ExtractPhraseFromPattern(boolean ignoreCommonTags, int maxPhraseLength) {
        this.maxPhraseLength = maxPhraseLength;
        this.ignoreCommonTags = ignoreCommonTags;
    }

    public void setMaxPhraseLength(int maxPhraseLength) {
        this.maxPhraseLength = maxPhraseLength;
    }

    private boolean checkIfSatisfiedMaxDepth(SemanticGraph g, IndexedWord parent, IndexedWord child, IntPair depths) {
        if (depths.get(0) == Integer.MAX_VALUE) {
            return true;
        }
        if (parent.equals(child)) {
            return true;
        }
        boolean foundInMaxDepth = false;
        for (IndexedWord c : g.getChildren(parent)) {
            if (!c.equals(child)) continue;
            return true;
        }
        depths.set(1, depths.get(1) + 1);
        if (depths.get(1) >= depths.get(0)) {
            return false;
        }
        for (IndexedWord c : g.getChildren(parent)) {
            foundInMaxDepth = this.checkIfSatisfiedMaxDepth(g, c, child, depths);
            if (!foundInMaxDepth) continue;
            return foundInMaxDepth;
        }
        return false;
    }

    public void processSentenceForType(SemanticGraph g, List<SemgrexPattern> typePatterns, List<String> textTokens, Collection<String> typePhrases, Collection<IntPair> typeIndices, Collection<IndexedWord> typeTriggerWords, boolean findSubTrees, Collection<ExtractedPhrase> extractedPhrases, boolean lowercase) {
        for (SemgrexPattern pattern : typePatterns) {
            Set<IndexedWord> triggerWords = this.getSemGrexPatternNodes(g, textTokens, typePhrases, typeIndices, pattern, findSubTrees, extractedPhrases, lowercase, o -> true);
            for (IndexedWord w : triggerWords) {
                if (typeTriggerWords.contains(w)) continue;
                typeTriggerWords.add(w);
            }
        }
    }

    public Set<IndexedWord> getSemGrexPatternNodes(SemanticGraph g, List<String> tokens, Collection<String> outputNodes, Collection<IntPair> outputIndices, SemgrexPattern pattern, boolean findSubTrees, Collection<ExtractedPhrase> extractedPhrases, boolean lowercase, Function<CoreLabel, Boolean> acceptWord) {
        HashSet<IndexedWord> foundWordsParents = new HashSet<IndexedWord>();
        SemgrexMatcher m = pattern.matcher(g, lowercase);
        while (m.find()) {
            IndexedWord w = m.getNode("node");
            IndexedWord parent = m.getNode("parent");
            boolean ifSatisfiedMaxDepth = this.checkIfSatisfiedMaxDepth(g, parent, w, new IntPair(this.maxDepth, 0));
            if (!ifSatisfiedMaxDepth) continue;
            if (DEBUG > 3) {
                List<Pair<String, SemanticGraph>> matchedGraphs = this.matchedGraphsForPattern.get(pattern);
                if (matchedGraphs == null) {
                    matchedGraphs = new ArrayList<Pair<String, SemanticGraph>>();
                }
                matchedGraphs.add(new Pair<String, SemanticGraph>(StringUtils.join(tokens, " "), g));
                this.matchedGraphsForPattern.put(pattern, matchedGraphs);
            }
            foundWordsParents.add(parent);
            ArrayList<IndexedWord> seenNodes = new ArrayList<IndexedWord>();
            ArrayList<String> cutoffrelations = new ArrayList<String>();
            this.printSubGraph(g, w, cutoffrelations, tokens, outputNodes, outputIndices, seenNodes, new ArrayList<IndexedWord>(), findSubTrees, extractedPhrases, pattern, acceptWord);
        }
        return foundWordsParents;
    }

    public void printSubGraph(SemanticGraph g, IndexedWord w, List<String> additionalCutOffRels, List<String> textTokens, Collection<String> listOfOutput, Collection<IntPair> listOfOutputIndices, List<IndexedWord> seenNodes, List<IndexedWord> doNotAddThese, boolean findSubTrees, Collection<ExtractedPhrase> extractedPhrases, SemgrexPattern pattern, Function<CoreLabel, Boolean> acceptWord) {
        try {
            if (seenNodes.contains(w)) {
                return;
            }
            seenNodes.add(w);
            if (doNotAddThese.contains(w)) {
                return;
            }
            ArrayList<IndexedWord> andNodes = new ArrayList<IndexedWord>();
            this.descendantsWithReln(g, w, "conj_and", new ArrayList<IndexedWord>(), andNodes);
            for (IndexedWord w1 : andNodes) {
                this.printSubGraph(g, w1, additionalCutOffRels, textTokens, listOfOutput, listOfOutputIndices, seenNodes, doNotAddThese, findSubTrees, extractedPhrases, pattern, acceptWord);
            }
            doNotAddThese.addAll(andNodes);
            ArrayList<String> allCutOffRels = new ArrayList<String>();
            if (additionalCutOffRels != null) {
                allCutOffRels.addAll(additionalCutOffRels);
            }
            allCutOffRels.addAll(this.cutoffRelations);
            CollectionValuedMap<Integer, String> featPerToken = new CollectionValuedMap<Integer, String>();
            ArrayList<String> feat = new ArrayList<String>();
            GetPatternsFromDataMultiClass.getFeatures(g, w, true, feat, null);
            Set<IndexedWord> words = ExtractPhraseFromPattern.descendants(g, w, allCutOffRels, doNotAddThese, this.ignoreCommonTags, acceptWord, featPerToken);
            if (words.size() > 0) {
                int min = Integer.MAX_VALUE;
                int max = -1;
                for (IndexedWord word : words) {
                    if (word.index() < min) {
                        min = word.index();
                    }
                    if (word.index() <= max) continue;
                    max = word.index();
                }
                if (max - min + 1 > this.maxPhraseLength) {
                    max = min + this.maxPhraseLength - 1;
                }
                IntPair indices = new IntPair(min - 1, max - 1);
                String phrase = StringUtils.join(textTokens.subList(min - 1, max), " ");
                phrase = phrase.trim();
                feat.add("LENGTH-" + (max - min + 1));
                for (int i = min; i <= max; ++i) {
                    feat.addAll((Collection<String>)featPerToken.get(i));
                }
                ExtractedPhrase extractedPh = new ExtractedPhrase(min - 1, max - 1, pattern, phrase, Counters.asCounter(feat));
                if (!listOfOutput.contains(phrase) && !doNotAddThese.contains(phrase)) {
                    listOfOutput.add(phrase);
                    if (!listOfOutputIndices.contains(indices)) {
                        listOfOutputIndices.add(indices);
                        extractedPhrases.add(extractedPh);
                    }
                    if (findSubTrees) {
                        for (IndexedWord word : words) {
                            if (seenNodes.contains(word)) continue;
                            this.printSubGraph(g, word, additionalCutOffRels, textTokens, listOfOutput, listOfOutputIndices, seenNodes, doNotAddThese, findSubTrees, extractedPhrases, pattern, acceptWord);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Set<IndexedWord> descendants(SemanticGraph g, IndexedWord vertex, List<String> allCutOffRels, List<IndexedWord> doNotAddThese, boolean ignoreCommonTags, Function<CoreLabel, Boolean> acceptWord, CollectionValuedMap<Integer, String> feat) throws Exception {
        HashSet<IndexedWord> descendantSet = new HashSet<IndexedWord>();
        if (doNotAddThese != null && doNotAddThese.contains(vertex)) {
            return descendantSet;
        }
        if (!acceptWord.apply(vertex.backingLabel()).booleanValue()) {
            return descendantSet;
        }
        ExtractPhraseFromPattern.descendantsHelper(g, vertex, descendantSet, allCutOffRels, doNotAddThese, new ArrayList<IndexedWord>(), ignoreCommonTags, acceptWord, feat);
        return descendantSet;
    }

    static boolean checkIfSatisfiesRelConstrains(SemanticGraph g, IndexedWord curr, IndexedWord child, List<String> allCutOffRels, GrammaticalRelation rel) {
        String relName = rel.getShortName();
        String relSpecificName = rel.toString();
        String relFullName = rel.getLongName();
        if (allCutOffRels != null) {
            for (String check : allCutOffRels) {
                if (!relName.matches(check) && (relSpecificName == null || !relSpecificName.matches(check)) && (relFullName == null || !relFullName.matches(check))) continue;
                return true;
            }
        }
        return false;
    }

    private static void descendantsHelper(SemanticGraph g, IndexedWord curr, Set<IndexedWord> descendantSet, List<String> allCutOffRels, List<IndexedWord> doNotAddThese, List<IndexedWord> seenNodes, boolean ignoreCommonTags, Function<CoreLabel, Boolean> acceptWord, CollectionValuedMap<Integer, String> feat) throws Exception {
        if (seenNodes.contains(curr)) {
            return;
        }
        seenNodes.add(curr);
        if (descendantSet.contains(curr) || doNotAddThese != null && doNotAddThese.contains(curr) || !acceptWord.apply(curr.backingLabel()).booleanValue()) {
            return;
        }
        if (!ignoreCommonTags || !ignoreTags.contains(curr.tag().trim())) {
            descendantSet.add(curr);
        }
        for (IndexedWord child : g.getChildren(curr)) {
            boolean dontuse = false;
            if (doNotAddThese != null && doNotAddThese.contains(child)) {
                dontuse = true;
            }
            GrammaticalRelation rel = null;
            if (!dontuse) {
                rel = g.reln(curr, child);
                dontuse = ExtractPhraseFromPattern.checkIfSatisfiesRelConstrains(g, curr, child, allCutOffRels, rel);
            }
            if (!dontuse) {
                for (String cutOffTagRegex : cutoffTags) {
                    if (!child.tag().matches(cutOffTagRegex)) continue;
                    if (DEBUG >= 5) {
                        System.out.println("ignored tag " + child + " because it satisfied " + cutOffTagRegex);
                    }
                    dontuse = true;
                    break;
                }
            }
            if (dontuse) continue;
            if (!feat.containsKey(curr.index())) {
                feat.put((Integer)curr.index(), new ArrayList());
            }
            GetPatternsFromDataMultiClass.getFeatures(g, curr, false, (Collection<String>)feat.get(curr.index()), rel);
            ExtractPhraseFromPattern.descendantsHelper(g, child, descendantSet, allCutOffRels, doNotAddThese, seenNodes, ignoreCommonTags, acceptWord, feat);
        }
    }

    private void descendantsWithReln(SemanticGraph g, IndexedWord w, String relation, List<IndexedWord> seenNodes, List<IndexedWord> descendantSet) {
        if (seenNodes.contains(w)) {
            return;
        }
        seenNodes.add(w);
        if (descendantSet.contains(w)) {
            return;
        }
        if (this.ignoreCommonTags && ignoreTags.contains(w.tag().trim())) {
            return;
        }
        for (IndexedWord child : g.getChildren(w)) {
            for (SemanticGraphEdge edge : g.getAllEdges(w, child)) {
                if (!edge.getRelation().toString().equals(relation)) continue;
                descendantSet.add(child);
            }
            this.descendantsWithReln(g, child, relation, seenNodes, descendantSet);
        }
    }

    public void printMatchedGraphsForPattern(String filename, int maxGraphsPerPattern) throws Exception {
        BufferedWriter w = new BufferedWriter(new FileWriter(filename));
        block0: for (Map.Entry<SemgrexPattern, List<Pair<String, SemanticGraph>>> en : this.matchedGraphsForPattern.entrySet()) {
            w.write("\n\nFor Pattern: " + en.getKey().pattern() + "\n");
            int num = 0;
            for (Pair<String, SemanticGraph> gEn : en.getValue()) {
                if (++num > maxGraphsPerPattern) continue block0;
                w.write(gEn.first() + "\n" + gEn.second().toFormattedString() + "\n\n");
            }
        }
        w.close();
    }
}

